;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-
;;;  $Id: front-end.lisp,v 1.16 92/07/14 19:19:57 bert Exp $

(in-package 'QSIM)

;  Copyright (c) 1988 by Benjamin Kuipers.

;;; This is a machine-dependent file.  It has been written in a way to
;;; minimize the differences between the Explorer and the Symbolics
;;; systems.  It contains the functions used to query the user about
;;; input and in setting global parameters.

;The Example top level, that lets me choose what I want to display.

; To add a new control menu (e.g. for curvature constraint package)
; add a menu entry to the end of *control-menus*.



(defparameter *control-variable-menu-entry*
             '("QSIM Control Variables"
               :eval (set-control-variables)
               :character-style (nil :bold nil)
               :documentation "Set variables controlling Q"))

(defparameter *q2-control-variable-menu-entry*
             '("Q2 quantitative inference controls"
               :eval (Q2-control-variables)
               :character-style (nil :bold nil)
               :documentation "Set variables controlling Q2"))
                              
(defconstant *acc-control-menu-entry*
             '("ACC controls"
               :eval (set-new-acc-control-variables)
               :character-style (nil :bold nil)
               :documentation "Set acc controls"))

(defconstant *nic-control-menu-entry*
	     '("NIC controls" 
	       :eval (set-nic-controls)
	       :character-style (nil :bold nil)
	       :documentation "Set NIC controls"))

(defparameter *ec-control-menu-entry*
	      '("Energy Constraint controls" 
		:eval (set-ec-controls)
		:character-style (nil :bold nil)
		:documentation "Set Energy Constraint controls"))

(defvar *control-menus* (list *control-variable-menu-entry*
                              *acc-control-menu-entry*
                              *q2-control-variable-menu-entry*
                              *ps-control-menu-entry*
			      *nic-control-menu-entry*
			      *ec-control-menu-entry*))

(defparameter *control-menus-pointer*
             '("Control Menus"
               :eval (my-menu " Control menus: " *control-menus*
                              :control-menu nil)
               :character-style (nil :bold nil)
               :loop t
               :documentation "Choose a control variables menu."))

(defparameter *cover-page-shown* nil)           ; Have we already shown the cover page?
(defparameter *dont-load* nil)			; Don't load requested files.
(defparameter *always-load* nil)		; Load file even if it's already loaded.
(defvar *available-catalogs*                    ; Set of possible catalogs.
        '(demos medical tanks))

; B. Kuipers.  9-26-91.

; The QT macro provides a tty menu for the catalog of examples.
; You can specify a path through the structure in advance if desired.
;    (QT)  ->  start by listing available catalogs
;    (QT demos)  ->  start by listing structures on DEMOS catalog
;    (QT demos bathtub)  ->  start by listing examples for BATHTUB structure
;    (QT demos bathtub fill-from-empty)  ->  run the example.
;
;  A similar capability is provided by menu-choice except it does not allow you
;  to specify a partial path.


(defmacro QT (&optional cat struct examp)
  (format *query-io* "~2%| QSIM example menu")
  (let* ((catalog (or (if (boundp cat) cat)
		      (tty-menu *available-catalogs*
				:heading "Pick a catalog (any other key to exit)"
				:label-selector #'(lambda (x) x))
		      (return-from QT nil)))
	 (structure-list (eval catalog))
	 (structure-record (or (when struct (assoc struct structure-list))
			       (tty-menu structure-list
					 :heading "Pick a structure (any other key to exit)"
					 :label-selector #'car)
			       (return-from QT nil)))
	 (example-list (cadddr structure-record))
	 (example-record nil))
    (dolist (file (cadr structure-record))
      (load-file-unless-already-loaded file))
    (eval (caddr structure-record))
    (setq example-record (or (when examp (assoc examp example-list))
			     (tty-menu example-list
				       :heading "Pick an example to run (any other key to exit)"
				       :label-selector #'car)
			     (return-from QT nil)))
    (load-file-unless-already-loaded (cadr example-record))
    (caddr example-record)			; EVAL as macro output
    ))

; TTY version of basic item-selection menu.
;   L is a list of items.
;   label-selector is a function to pick out the name to print.

(defun tty-menu (L &key (label-selector #'car)
		        (stream *query-io*)
			(heading "Menu"))
  (format stream "~2%+------------------------------")
  (format stream "~%| ~a" heading)
  (format stream "~%+------------------------------")
  (do ((sublist L (cdr sublist))
       (i 1 (+ 1 i)))
      ((null sublist))
    (let ((item (car sublist)))
      (format stream "~%|   ~a:~9t~a" i (funcall label-selector item))))
  (format stream "~%+------------------------------")
  (format stream "~%| Select item number (1 to ~a):  " (length L))
  (let ((answer (read stream)))
    (cond ((and (integerp answer)
		(< 0 answer (+ 1 (length L))))
	   (nth (- answer 1) L)))))

; TTY version of a boolean-only set-variable-values menu.


(defparameter *switch-tree* '((debug
			       *show-inconsistent-successors*
			       *show-completion-steps*
			       *plot-beh-numbers*
			       *plot-state-indices*)
			      (Trace
				(QSIM
				 (cfilter
				  *trace-count*              
				  *trace-tuples*             
				  *trace-constraint-filter*  
				  *trace-mult-constraint*    )
				 (qsimulate
				  *trace-main-agenda*    
				  trace-propagation      
				  *show-completion-steps*
				  *print-timing*         )
				 (global-filters
				  *trace-time-label*        	
				  *trace-no-change*         	
				  *trace-analytic-functions* 
				  *trace-ignore-qdir* 	
				  *trace-quiescence* 	
				  *trace-new-landmarks* 	
				  *trace-corresponding-values*
				  *trace-cycle-detection* 	
				  *trace-energy-filter*	
				  *trace-transitions* 	
				  *trace-pruning* 		)
				 )
				(Q2
				 *trace-Q2-check*      
				 *trace-eqn-indexing*  
				 *trace-q2-agenda*     
				 *trace-consider-eqn*  
				 *trace-ranger*        
				 *trace-range-update*  
				 *trace-single-char*   
				 )
				(HOD
				 *trace-chatter-vars*       
				 *trace-sd2-derivation*     
				 *trace-successful-rules*   
				 *trace-AOnode-creation*    
				 *trace-children*           
				 *trace-acc-filter-application*
				 *trace-auto-sd3-evaluation*
				 )
				(Energy
				 (High-Level
				  *trace-decomposition*
				  *trace-energy-filter*)
				 (Low-Level
				  *trace-energy*)
				 ( Prolog
				  *occur-check*    
				  *trace-success*  
				  *trace-goals*    
				  *trace-clauses*	
				  *trace-bindings*	
				  *trace-resolvent* 	
				  *trace-results* 	
				  *trace-solutions* 	)
				 ))
			      (Empty
				(POS
				 )
				(NIC
				 )
				)
			      ))

(defmacro QW (&rest path)
  (format *query-io* "~2%| QSIM switch menu")
  (do ((tree *switch-tree*)
       (L path (cdr L)))
      ((null tree) nil)
    (cond ((listp (car tree))
	   (setq tree (cdr (or (if L (assoc (car L) tree))
			       (tty-menu tree
					 :heading "Pick a category (any other key to exit)"
					 :label-selector #'car)
			       (return-from QW nil)))))
	  (t (let ((switch (or (tty-menu tree
					 :heading "Toggle a switch (any other key to exit)"
					 :label-selector
					 #'(lambda (x) (format nil "~a (~a)" x (eval x))))
			       (return-from QW nil))))
	       (format t "~%Toggling ~a from ~a to ..." switch (eval switch))
	       (set switch (not (eval switch)))
	       (return-from QW (eval switch)))))))

(defun Q (&optional input)
  (catch 'no-choice
    (cover-page)
    (let* ((catalog (or input
                        (eval #+:lispm (my-menu "Select example catalog" *available-catalogs*)
			      #-:lispm (menu-choice "Select example catalog" *available-catalogs*))
                        (throw 'no-choice nil)))
           (structures (mapcar #'car Catalog))
           (choice (or #+:lispm (my-menu " Select structure: " structures)
		       #-:lispm (menu-choice " Select structure: " structures)
                       (throw 'no-choice nil)))
           (retrieved-record (assoc choice Catalog))
           (init-alist nil)
           (inits nil))
      (mapc 'load-file-unless-already-loaded
            (cadr retrieved-record))            ; files to load
      (eval (caddr retrieved-record))           ; structure initialization form
      (setq init-alist (cadddr retrieved-record))
      (setq inits (mapcar #'car init-alist))
      (or (setq choice #+:lispm (my-menu " Select initialization: " inits)
		       #-:lispm (menu-choice " Select initialization: " inits))
          (throw 'no-choice nil))
      (setq retrieved-record (assoc choice init-alist))
      (load-file-unless-already-loaded (cadr retrieved-record))
      (eval (caddr retrieved-record)))))

;;; My-menu gives the pop-up choices menu for several places in the
;;; interface.  It normally has an option for going off to the control
;;; menus.  This can be inhibited, because the control menus themselves
;;; are displayed by My-Menu, and we don't want to edit the control
;;; values recursively.  A menu item may have the :loop keyword in its
;;; specification (eg, see the definition of *control-menus-pointer*) -
;;; that indicates that it is chosen for side effect and that control
;;; should return to the menu after it is chosen.

;;; We loop repeatedly until the user makes a choice.  We distinguish
;;; between the NIL value of moving the mouse off the menu from a choice
;;; whose value is NIL by looking at the second value that the call to
;;; Menu-choose returns.

(defun my-menu (title items &key (control-menu t))
  (let ((tv-args (append (when control-menu
                           `(,*control-menus-pointer*
                             ("" :no-select t)))        ; blank space
                         items
                         `(("" :no-select t)
                           (,(merge-font-info label-font "QUIT")  :value nil))))
        result choice)
    (loop
      do (multiple-value-setq (result choice)
           #+ti (w:menu-choose tv-args :label title)
	   #+symbolics (menu-choose tv-args title)
	   #-(or :ti :symbolics) (menu-choice tv-args title)  ; added DJC porting to Sun
	   )
      when (and (not (when (listp choice)
                       (member :loop choice)))  ; User has not chosen something to Loop on
                (or result                      ; user has made a choice
                    choice))                    ; user has chosen something with NIL value
        return (values result choice))))

;;;  MENU-CHOICE is a version of my-menu designed for a vt100 terminal.  It will
;;;  simply take a list of options along with a prompt and it will display
;;;  the options with numbers beside them.  The user then selects a number and 
;;;  the funtion will return the selection of the user.
;;;  DJC  09/2/91

(defun menu-choice (prompt options)
  (when options
    (let ((i 1)
	  (num-options (1+ (length options))))
      (format t "~%~%~a~%~%" prompt)
      (dolist (option options)
	(format t "~10T~a. ~a~%" i option)
	(setf i (1+ i)))
      (format t "~%~10TQ. Exit~%")
      (format t "~%~% Selection: ")
      (clear-input)
      (do ((choice (read) (read)))
	  ((cond ((or (eq choice 'q)
		      (eq choice 'Q)))
		 ((or (not (numberp choice))
		      (< choice 1)
		      (> choice num-options))
		  (format t "~%~%Invalid Entry.  Try again: ")
		  nil)
		 (t t))
	   (if (or (eq choice 'q)
		   (eq choice 'Q))
	       nil
	       (nth (1- choice) options)))))))



; The cover page gives useful information about the program.
;   Eventually, put into nice fonts.

(defun cover-page ()
  (cond ((null *cover-page-shown*)
         #+lispm (send *qplot-output* :clear-window)
            ; Set globals so that Genera 7 behaves itself.
         #+symbolics (send *qplot-output* :set-borders 2)  ; clear fancy borders from Lisp Listener 1.
         (with-open-file (file  *cover-page-file*)
           (do ((string (read-line file nil t) (read-line file nil t))) ; return T on eof.
               ((eql string T))
             (write-line string *Qsim-Report*)))
	 #-:lispm (progn
		    (format t "~%PRESS RETURN TO CONTINUE: ")
		    (read-line))
         (setq *cover-page-shown* t))))

;; The NAME, which came from an ADD-To-Catalog form in a demo file, is
;; merged against the *System* logical host and the logical directory
;; Examples.  If NAME is a complete pathname, it will be retained.

#+:lispm
(defun load-file-unless-already-loaded (name)
  (cond ((null name))
        ((not (null *dont-load*)))
        (t (let* ((path (merge-pathnames name (format nil "~a:Examples;foo.lisp" *system*)))
                  (truename (probe-file path)))
             (cond ((null truename) (error "Can't load nonexistent file ~A." path))
                   ((and (not *always-load*)
			 (send truename :get 'already-loaded)) nil)
                   (t (load truename :package *package-for-examples*)
                      (send truename :putprop t 'already-loaded)
                      t))))))

;;; This version will always load the file.  It should be modified at some point to 
;;; keep track of the files that are loaded.
;;; DJC  09/2/91
#-:lispm
(defun load-file-unless-already-loaded (name)
  (when name
    (let* ((file-to-load (merge-pathnames name (format nil "~a:examples;foo.lisp" *system*)))
	   (truename (probe-file file-to-load)))
      (format t "~% Trying to load: ~a" file-to-load) 
      (load truename))))


; A catalog is of the form:
;         alist of (structure-name 
;                      list-of-files-to-load
;                      form-to-evaluate
;                      alist of (initialization-name
;                                   file-to-load 
;                                   form-to-evaluate))
;Modified 9/1/89 by Dan B. to allow loading a new version of a structure.
(defun add-to-catalog (catalog record)
  (or (member catalog *available-catalogs*)
      (nconc *available-catalogs* (list catalog)))
  (unless (member record (eval catalog) :test #'equal)
    (let ((new-version  (member record (eval catalog) :test #'(lambda (a b) (eql (car a) (car b))))))
      (if new-version
	  (progn (format *qsim-report* "~%In catalog ~a, loading structure ~a" catalog (car record))
		 (rplaca new-version record))
	  (set catalog (nconc (eval catalog) (list record)))))))

; "catalog-it" pastes its arguments into the appropriate list structure and then 
;  calls add-to-catalog on the result. Dan B. 10/7/90.
;  Example:
;(catalog-it  :catalog-name     '2nd-order
;	      :menu-entry       'd2x/dt2_times_dx/dt^2+[x-x]=0
;	      :file-to-load     (if (symbolics-p)  "alamo:>berleant>q3>d2xdt2_times_dxdt^c=k"  "q:berleant;d2xdt2_times_dxdt^c=k")
;	      :function-to-run  'simulate_d2x/dt2_times_dx/dt^2+[x-x]=0)
(defun choose-q3-init (list-of-alternative-numeric-initial-conditions) list-of-alternative-numeric-initial-conditions nil)
(defun catalog-it (&key catalog-name menu-entry file-to-load function-to-run (list-of-numeric-alternatives nil))
  (add-to-catalog catalog-name   (list menu-entry (list file-to-load)
				       nil
				       (list (list function-to-run nil `(progn (choose-q3-init ',list-of-numeric-alternatives)
									       (,function-to-run)))))))

; This provides a menu for setting control and trace variables.
; *MAIN-CONTROL-CHOICES* was made a separate variable so that it
; wouldn't have to be CONSed up each time, and so that its definition
; wouldn't run off the right margin when hardcopying.

(defparameter *main-control-choices*
  `((*state-limit*                      " Maximum number of states"
					#+ti :fixnum #+symbolics :integer)
    (*time-limit*                       " Time limit"
					;;#+symbolics :integer-or-nil
					;; time limit can be nil (no time limit) or a time point
					;; such as t2, not 2. PF 31 May 91
					) 
    (*check-for-cycles*                 " Cycle detection criterion"
					:menu-alist (("None" . nil) ("Weak" . :weak)
						     ("Standard" . :standard) ("Strong" . :strong)))
    (*analytic-functions-only*          " Accept only analytic functions" :boolean)
    (*check-for-unreachable-values*     " Check for unreachable values" :boolean)
    (*enable-landmark-creation*         " Enable landmark creation"      :boolean)
    (*new-landmarks-on-transition*      " Create landmarks on transition" :boolean)
    (*new-landmarks-across-M-constraints* " Create landmarks across constraints" :boolean)
    (*new-landmarks-at-initial-state*   " Create landmarks at initial state" :boolean)
    (*ask-about-multiple-completions*   " Ask about multiple completions" :boolean)
    (*perform-acc-analysis*             " Perform acc analysis" :boolean)
    (*check-quantitative-ranges*        " Run Q2 quantitative range filter" :boolean)
    (*show-inconsistent-successors*     " Display all inconsistent branches" :boolean)
    (*fire-transitions*                 " Region transitions allowed"
					:menu-alist (("All" . :all) ("First" . :first)
						     ("Unique" . :unique) ("None" . :none)))
    "" "Trace CFILTER algorithm:"
    (*trace-count*              " Show object counts" :boolean)
    (*trace-tuples*             " Show tuples" :boolean)
    (*trace-constraint-filter*  " Show constraint filters" :boolean)
    (*trace-mult-constraint*    " Show multiplication constraints" :boolean)
    
    ""
    "Trace qualitative simulation:"
    
    (*trace-main-agenda*       " Show agenda" :boolean)
    (trace-propagation         " Show propagation steps" :boolean)
    (*show-completion-steps*   " Show state completion stages" :boolean)
    (*print-timing*            " Print run times" :boolean)

    ""
    "Trace Global Filters:"
    (*trace-time-label*        	" Time label" :boolean)
    (*trace-no-change*         	" No change " :boolean)
    (*trace-analytic-functions* " Analytic functions" :boolean)
    (*trace-ignore-qdir* 	" Ignore qdir" :boolean)
    (*trace-quiescence* 	" Quiescence" :boolean)
    (*trace-new-landmarks* 	" Landmark creation" :boolean)
    (*trace-corresponding-values* " Corresponding values" :boolean)
    (*trace-cycle-detection* 	" Cycles" :boolean)
    (*trace-energy-filter*	" Energy" :boolean)
    (*trace-transitions* 	" Transitions" :boolean)
    (*trace-pruning* 		" Pruning" :boolean)))


;; Nobody uses the old display anymore
;    ""
;    "QSIM Display:"
;    (*qsim-display-version*    " QSIM display to use" :choose (New Old))
;    ))

(defun set-control-variables ()
    #+ti (w:choose-variable-values
	   *main-control-choices* ':label "QSIM options and flags"
	   ;; without these args, menu must scroll
	   :height 650) 
    #+symbolics (choose-variable-values
		  *main-control-choices* ':label "QSIM options and flags"
		  ;; without these args, menu must scroll
		  :max-lines (length *main-control-choices*))
; original code.
;    (choose-variable-values
;      *main-control-choices* ':label "QSIM options and flags"
;      ;; without these #+ args, menu must scroll
;      #+ti :height #+ti 500 #+symbolics :max-lines
;      #+symbolics (length *main-control-choices*))
  (values))


; For Q2 control variables.

(defparameter *q2-control-variables* 
  '((*check-quantitative-ranges*  " apply Q2 quantitative filter"     :boolean)
    ""
    (*trace-Q2-check*      " trace global filter use"                 :boolean)
    (*trace-eqn-indexing*  " trace equation index creation"           :boolean)
    (*trace-q2-agenda*        " trace addition of equations to agenda"   :boolean)
    (*trace-consider-eqn*  " trace equation consideration"            :boolean)
    (*trace-ranger*        " trace the range interpreter"             :boolean)
    (*trace-range-update*  " trace changes to intervals"              :boolean)
    (*trace-single-char*   " single-char trace output"                :boolean)))

(defun q2-control-variables ()
  #+symbolics (choose-variable-values *q2-control-variables*
				      :label "Q2 trace and control switches")
  #+ti (w:choose-variable-values *q2-control-variables*
				:label "Q2 trace and control switches")

  nil)

;;;-----------------------------------------------------------------------------
;;; [Refs: Kuipers and Chiu,  IJCAI-87.
;;;        Chiu, Higher order derivative constraints and a QSIM-based total simulation scheme.
;;;             U-Texas, CS tech report AITR88-65, 1988.]              
;;;
;;;  Front-end for automatic curvature constraint determination.

;;;  Setup the ACC menu.
;;; This provides a menu for setting controls for the automatic determination of 
;;; curvature constraint and the trace of HOD trees. 
;;;-----------------------------------------------------------------------------

(defparameter *new-acc-control-variables*
  `((*perform-acc-analysis*          "Apply HOD constraints (SD2 and SD3)"  :boolean)
    (*derive-curvature-constraints*  "Derive SD2 expressions"  :boolean)
    (*auto-sd3-evaluation*           "Derive SD3 expressions" :boolean)
    ""
    (*trace-chatter-vars*         "Trace identification of chattering vars" :boolean)
    (*trace-sd2-derivation*       "Trace derivation of SD2 constraint"     :boolean)
    (*trace-successful-rules*     "Trace successful transformation rules"  :boolean)
    (*trace-AOnode-creation*      "Trace node creation in expression search" :boolean)
    (*trace-children*             "Trace children of search nodes"         :boolean)
    (*search-state-limit*       "Node limit for ACC transformation search"
				#+symbolics :integer #+ti :fixnum)	;:integer is not a ti keyword -PF-
    (*trace-acc-filter-application*  "Trace ACC filter application"        :boolean)
    (*trace-auto-sd3-evaluation* "Trace 3rd-order derivatives" :boolean)))
        
(defun set-new-acc-control-variables ()
  #+:lispm
  (tv:choose-variable-values
    *new-acc-control-variables*
    ':label "New ACC controls:")
  nil)



(defun reset-acc-controls ()
  (mapc #'(lambda(control)(set control nil))
        '(*perform-acc-analysis* *derive-curvature-constraints* *auto-sd3-evaluation*
	     *trace-chatter-vars* *trace-sd2-derivation* *trace-successful-rules* 
	     *trace-aonode-creation* *trace-children* *search-state-limit*
	     *trace-acc-filter-application* *trace-auto-sd3-evaluation*)))


;;;-----------------------------------------------------------------------------
;;;  Front-end interface for Non-Intersection Constraint --- control menu.
;;; These trace switches are defined in qdefs.lisp
;;;-----------------------------------------------------------------------------


(defparameter *nic-control-variables*
  `((*apply-nic-p* "Apply Non-Intersection Constraint" :boolean)
    (*prune-intersections-p* "Prune behaviors with intersection" :boolean)
    (*confirm-when-present-p* "Confirm when Phase-Planes clause is present" :boolean)
    ""
    "Tracing:"
    (*nic-trace-mode* "Trace mode" :choose (along-trajectory on-intersection-only nil))
    (*nic-trace-display* "Displaying the trace" :choose (text-only portrait-also portrait-on-intersection))
    (*intersection-count-p* "Counting the number of intersections" :boolean)
    (*nic-notifications-p* "Display warning message" :boolean)))

(defun set-nic-controls ()
  #+symbolics (choose-variable-values *nic-control-variables*
				      ':label "Non-Intersection Constraint Controls")
  #+ti (w:choose-variable-values *nic-control-variables*
				 ':label "Non-Intersection Constraint Controls")

  nil)


;;;-----------------------------------------------------------------------------
;;;  Front-end interface for the Energy Constraint --- control menu.
;;; These trace switches are defined in qdefs.lisp and in prolog.lisp
;;;-----------------------------------------------------------------------------

(defparameter *ec-control-variables*
  `((*perform-energy-analysis* " Derive Energy Constraint" :boolean)
    (*check-energy-constraint* " Apply Energy Constraint" :boolean)
    ""
    "High Level Trace:"
    (*trace-decomposition* " Trace constraint derivation" :boolean)
    (*trace-energy-filter* " Trace spurious behaviors" :boolean)
    ""
    "Low Level Trace:"
    (*trace-energy* " Trace evaluation of energy terms" :boolean)
    ""
    "Trace Prolog interpreter"
    (*occur-check*    	" Perform occur check " :boolean)
    (*trace-success*  	" Trace success " 	:boolean)
    #+ti
    (*traced-predicates* " Trace predicates " 	:multiple-menu
       (set-difference (get 'ec :predicates)
		       (mapcar #'car *predefined-predicates*)))
    (*trace-goals*    	" Trace goals "		:boolean)
    (*trace-clauses*	" Trace clauses "	:boolean)
    (*trace-bindings*	" Trace bindings "	:boolean)
    (*trace-resolvent* 	" Trace resolvent" 	:boolean)
    (*trace-results* 	" Trace results " 	:boolean)
    (*trace-solutions* 	" Trace solutions" 	:boolean)))


(defun set-ec-controls ()
  #+symbolics (choose-variable-values *ec-control-variables*
				      ':label "Energy Constraint Controls")
  #+ti (w:choose-variable-values *ec-control-variables*
				 ':label "Energy Constraint Controls")
  (untrace-predicate)
  (when *traced-predicates* (eval `(trace-predicate ,@ *traced-predicates*)))
  nil)



;;; These are handy commands for Symbolics Command level.  Other systems
;;; can reach all of these menus via the (q) call.

#+symbolics 
(progn
  (cp:define-command (com-QSIM-Change-Control-Variables
                       :provide-output-destination-keyword nil
                       :command-table "Global")
      ()
     (Set-Control-Variables))

  (cp:define-command (com-QSIM-Change-PostScript-Control-Variables
                       :provide-output-destination-keyword nil
                       :command-table "Global")
      ()
     (Set-ps-Control-Variables))

  (cp:define-command (com-QSIM-Change-ACC-Control-Variables
                       :provide-output-destination-keyword nil
                       :command-table "Global")
      ()
     (Set-new-acc-Control-Variables))
  (cp:define-command (com-QSIM-Change-Q2-Control-Variables
                       :provide-output-destination-keyword nil
                       :command-table "Global")
      ()
     (q2-control-variables))
  (cp:define-command (com-QSIM-PostScript-no
                       :provide-output-destination-keyword nil
                       :command-table "Global")
      ()
     (setf *image-disposal* :screen))

  (cp:define-command (com-QSIM-PostScript-yes
                       :provide-output-destination-keyword nil
                       :command-table "Global")
      ()
     (setf *image-disposal* :both))

  (cp:define-command (com-QSIM-Var-Slice-Viewer
                       :provide-output-destination-keyword nil
                       :command-table "Global")
      ()
     (var-slice-viewer))
  (cp:define-command (com-QSIM-Display-Initial-State
                       :provide-output-destination-keyword nil
                       :command-table "Global")
      (&key (trees 'scl:boolean :default t))
     (if *initial-state*  
	 (qsim-display *initial-state*  :reference-states *reference-states*
		       :trees trees)
	 (format *qsim-report* "*INITIAL-STATE* is NIL, don't know what to display")))
  (cp:define-command (com-QSIM-show-inconsistent-yes                            ;;  added 02/15/91  DJC
                       :provide-output-destination-keyword nil
                       :command-table "Global")
      ()
     (setf *show-inconsistent-successors* t))
  (cp:define-command (com-QSIM-show-inconsistent-no                             ;;  added 02/15/91  DJC
                       :provide-output-destination-keyword nil
                       :command-table "Global")
      ()
     (setf *show-inconsistent-successors* nil))


  ;; COM-QSIM-BOUNDED-DISPLAY binds global variables for BoundingBox
  ;; output, needed by psfig macros.  If printed normally (outside psfig
  ;; macros) figure will be *Text-format-text-width* inches (6") wide.  
  ;;   NOTICE - this is a special set of bindings to work with
  ;; DISPLAY-BEHAVIOR.  It assumes that lmargin, rmargin and bmargin
  ;; are empty.

  (cp:define-command (com-QSIM-Bounded-Display
                       :provide-output-destination-keyword nil
                       :command-table "Global")
      (&key (trees 'scl:boolean :default t))
     (let* ((*x-translation*
	    (/ (- 8.5 *Text-format-text-width*) 2))	; Position on paper of 
	  (*y-translation* 1)			; lowerleft corner, in inches
	  (*rotation* 0)
	  (*bounding-box* (list lmargin (- yscreen bmargin) (- xscreen rmargin) 0))
	  (*postscript-style* :bounded)
	  (*x-scale* (/ (* 72.0 *Text-format-text-width*) xscreen))
	  (*y-scale* *x-scale*))
       (qsim-display *initial-state*  :reference-states *reference-states*
		     :trees trees)))
  (cp:define-command (com-QSIM-state-limit
                       :provide-output-destination-keyword nil
                       :command-table "Global")
      ((limit 'scl:integer :documentation "The number of states to process before QSIM quits"))
     (setf *state-limit* limit)))


#+symbolics 
(zwei:defindentation (add-to-catalog  1 2))
#+symbolics
(zwei:defindentation (plot-h-axis-point 2 3 3 3))
#+symbolics
(zwei:defindentation (allocate-behavior 1 3 2 3 3 3))
