;;; -*- Mode: Common-Lisp; Package: QSIM; Syntax: COMMON-LISP; Base: 10 -*-

;;; This file contains code for VAR-SLICE-VIEWER and PHASE-DIAGRAM-PLOTTER that is not
;;; in vanilla Common Lisp.  The Common Lisp code is in 2 files, Viewers-Clisp and
;;; Viewers-Clisp-2.  The code in this file depends on the code in Viewers-Clisp-2.
;;; The code in Viewers-Clisp depends both on the code in this file and the code in
;;; Viewers-Clisp-2.  Refer to Read-Me-About-Viewers for details.

;;; Although this is machine-dependent code, it should run on both the
;;; Symbolics and TIs.

(defun change-viewer-layout-parms ()
  (tv:choose-variable-values
    '((viewer-rows "Number of rows per screen" :number)
      (viewer-cols "Number of plots per row" :number))
    ':label "Viewer layout parameters"))

;; Selects behaviors from the behavior tree using the mouse, available only on Symbolics.
#+symbolics
(defun select-behs-from-beh-tree (inits max-len btotal &optional (tree-p t))
  (tv:with-mouse-and-buttons-grabbed
    (when tree-p
      (with-plotting-to-postscript-inhibited
	(with-plotting-to-screen-forced
	  (qplot-behavior-tree inits max-len btotal 0))))
    (setq tv:who-line-mouse-grabbed-documentation
	  (format nil "L selects (dragging selects set), M deselects ~
	               (dragging deselects set), R ends selection."))    
    (do* ((mouse (tv:wait-for-mouse-button-down) (tv:wait-for-mouse-button-down))
	  (begin-y sys:mouse-y sys:mouse-y)
	  (mouse-up (tv:wait-for-mouse-button-up) (tv:wait-for-mouse-button-up))
	  (end-y sys:mouse-y sys:mouse-y)
	  (bnum-list nil)
	  (begin-bnum (determine-bnum-from-position begin-y btotal)
		      (determine-bnum-from-position begin-y btotal))
	  (end-bnum (determine-bnum-from-position end-y btotal)
		    (determine-bnum-from-position end-y btotal)))
	 ((eql mouse 4) bnum-list)
      (if (eql mouse 2)
	  (mapc #'(lambda (bnum) (setq bnum-list (remove bnum bnum-list)))
		(sequence-of-nums begin-bnum end-bnum btotal))
	  (setq bnum-list (union bnum-list (sequence-of-nums begin-bnum end-bnum btotal))))
      (set-cursor-pos 0 (- yscreen bmargin))
      (clear-line)
      (format *standard-output* "Current list of behaviors: ~a" bnum-list))))

(defun set-cursor-pos (x y) (send *standard-output* :set-cursorpos x y))

(defun clear-line () (send *standard-output* :clear-rest-of-line))

(defun clear-rest-of-window () (send *standard-output* :clear-rest-of-window))

;; Setting viewport for dynamic windows on Symbolics
#+symbolics
(defun set-viewport (x y) (send *standard-output* :set-viewport-position x y))