;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package 'QSIM)


; This prints a simple table of +0- values for qmag,qdir for a list of states.
; If a reference state is provided, the +0- values are [X]* values wrt the reference state.

(defun display-sign-table (states &optional (ref nil))
  (format *QSIM-Trace* "~%Table of +0- values for qmag,qdir wrt ~a, for ~a states.~%"
	  (or ref 0) (length states))
  (do ((vars (state-qspaces (car states)) (cdr vars))
       (refval nil))
      ((null vars))
    (if (not (null ref))
	(setq refval (qmag (lookup (caar vars) (state-values ref))))
	(setq refval 0))
    (format *QSIM-Trace* "~% ~a: ~20T" (caar vars))
    (mapc #'(lambda (s)
	      (let ((qv (lookup (caar vars) (state-values s)))
		    (qs (lookup (caar vars) (state-qspaces s))))
		(if (null qv)
		    (format *QSIM-Trace* "    ")
		    (format *QSIM-Trace* " ~a~a "
			    (or (qmag-order (qmag qv) refval qs) " ")
			    (or (sign-qdir (qdir qv)) " ")))))
	  states)))

(defun sign-qdir (qd)
  (case qd
    (inc '+)
    (std 0)
    (dec '-)
    (t nil)))

; This function gets the final successors of a given state:

(defun get-final-successors (state)
  (mapcar #'(lambda (beh) (car (last beh)))
	  (get-behaviors state)))

; Collects the state.status for the final successors of a given initial state.

(defun get-final-status (state)
  (mapcar #'get-status
	  (get-final-successors state)))


; This is an experiment to try to compute possible [X]* values for Charles'
; heart model.  This is a modified copy of his function.

(defun perturb-heart-3T (&rest acc-sign-specs)    

   (declare (special HEART-3-TANKs *coupled-qdes*  *acc-label-option*))
   (setq *latest-states* nil)
   (setq *coupled-qdes* t)
   (setq *acc-label-option* t)
;;;   (heart-3t-hod-constraints  acc-sign-specs heart-3-tanks)
   (let* ((normal (get-normal-state HEART-3-TANKs))
          (new    (quasi-equilibrium-solve normal
			      `((sabc         (,(qvalue= (sabc normal)) std))
				(hr            (,(qvalue+ (hr normal)) std))
				(x            ((0 inf) std))
				(y            ((0 inf) std))
				(z            ((0 inf) std))
			       )
			     "Heart rate up, normal volume.")))
     (display-sign-table new normal)
;;;     (qsim new)
;;;     (qsim-display new `((normal ,normal)))
   ))


; This is an experiment to try to compute possible [X]* values for Charles'
; heart model.  This is a modified copy of his function.

(defun perturb-x-heart-3T (&rest acc-sign-specs)    

   (declare (special HEART-3-TANKs *coupled-qdes*  *acc-label-option*))
   (setq *latest-states* nil)
   (setq *coupled-qdes* t)
   (setq *acc-label-option* t)
;;;   (heart-3t-hod-constraints  acc-sign-specs heart-3-tanks)
   (let* ((normal (get-normal-state HEART-3-TANKs))
          (new    (make-modified-state normal
			      `((sabc         (,(qvalue= (sabc normal)) std))
				(ax           (,(qvalue= (ax normal)) std))
				(bx           (,(qvalue+ (bx normal)) std))
				(svx          (,(qvalue= (svx normal)) std))
				(x            ((0 inf) std))
				(y            ((0 inf) std))
				(z            ((0 inf) std))
			       )
			     "Beta stim up, normal volume.")))
     (if (listp new)
	 (display-sign-table new normal)
	 (qsim-display new `((normal ,normal))))
;;;     (qsim new)
;;;     (qsim-display new `((normal ,normal)))
   ))
