;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-
;;; Copyright (c) 1987, Benjamin Kuipers.

(in-package 'QSIM)


; Various experiments.

; EXPERIMENT-7:  Starling alone, to debug unreachable values.
;  These now work correctly.

(defun experiment-7 ()
  (setq *latest-states* nil)
  (let* ((normal (get-normal-state starling))
	 (new (make-modified-state normal
				   `((afp   (,(qvalue+ (afp normal)) nil))
				     (ecw   (,(qvalue+ (ecw normal)) std))
				     (wi    ,(list (normal-value 'wi  normal) nil))
				     (pp    ,(list (normal-value 'pp  normal) 'std))
				     (pi    ,(list (normal-value 'pi  normal) 'std)))
				   "[Experiment 7] Increased volume."
				   )))
    (qsim new)
    (qsim-display new `((normal ,normal)))
    t))

; Heart regulation alone, to debug the structure.

(defun experiment-8 ()
  (setq *latest-states* nil)
  (let* ((normal (get-normal-state heart-regulation))
	 (new (make-modified-state normal
				   `((ss    ,(list (normal-value 'ss  normal) nil))
				     (bb    ,(list (normal-value 'bb normal) 'std))
				     (ab    ,(list (normal-value 'ab  normal) 'std))
				     (sc    ,(list (normal-value 'sc  normal) 'std))
				     (bv    (,(qvalue+ (bv normal)) std))
				     (inx   ,(list (normal-value 'inx  normal) 'std))
				     (hrx   ,(list (normal-value 'hrx  normal) 'std))
				     (pvrx  ,(list (normal-value 'pvrx  normal) 'std)))
				   "[Experiment 8] High blood volume."
				   )))
    (qsim new)
    (qsim-display new `((normal ,normal)))
    t))

; Used only here, and should be replaced by qvalue=

(defun normal-value (varname state)
  (let* ((normal-state (get-normal-state (state-qde state)))
	 (qval   (alookup varname (state-qvalues normal-state)))
	 (qmag   (qmag qval)))
     (if (atom qmag)
	 (lmark-name qmag)
	 (list (lmark-name (first qmag)) (lmark-name (second qmag))))))