;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-
;;; Copyright (c) 1986 by Benjamin Kuipers.
;;; Revised 1989 by Daniel Dvorak.

(in-package 'QSIM)


;;;=============================================================================
;;;
;;;                 T O T A L    E N V I S I O N M E N T S
;;;
;;;          ***  CAUTION:  THIS IS AN EXPERIMENTAL FUNCTION. ***
;;;-----------------------------------------------------------------------------
;;;
;;;  A "total envisionment" is a graph of all possible states interconnected by
;;;  all legal predecessor-successor relations.  This is in contrast to what
;;;  QSIM normally generates, which is called an "attainable envisionment",
;;;  which is the graph of all states reachable from a given initial state
;;;  (where the initial state may be partially specified).
;;;
;;;  For the case of a QDE with no discrete variables, this total-envisionment
;;;  generator does the following:
;;;
;;;  1.  For each variable (other than the "time" variable), all of its
;;;      possible values are created.
;;;  2.  Cfilter is then called, and it returns the list of all consistent 
;;;      value completions.  For large models this may take a long time.
;;;
;;;  --------- Adam: The above is all that is working currently. ------------
;;;
;;;  3.  Run each alist/state through filters.
;;;      Reject any alist at a time point containing a qval whose qmag is at a
;;;      point and whose qdir is 'inc or 'dec.
;;;  4.  If a transition is triggered then:
;;;      (a)  if it is in the same QDE then connect the transition-triggering
;;;           state to the identical state from step 1 (it *should* exist);
;;;      (b)  if it is to a different QDE, then simulate forward using qsim,
;;;           and if it ever transitions back to the original QDE then try
;;;           to connect it to an identical state from step 1.
;;;  
;
;
; This is an experiment in creating total envisionments:  the transition graph of
; all possible states and their legal connections.
;  - Generate all qualitative states (at time-points and time-intervals)
;    consistent with the constraints.
;  - Test all possible I->P and P->I transitions for consistency.
;  - Return the collection of transitions.
;
; In practice, this seems to produce such a large transition graph as not to be
; useful, but I haven't looked at it very carefully.  (BK)
;
; Future developments.
;    -> Store the transitions in State.Other.Transitions.
;    -> Compute average branching factor.
;;;=============================================================================


(defparameter trace-total-envisionment t)	; creation of transition graph
(defparameter *Envisionment* nil)		; holds the envisionment


(defun total-envisionment (qde)
  (let ((alists nil)
	(P-states nil)
	(I-states nil)
	(edges nil)
	(discrete-var-pvals nil))

    (setq *num-completions* 0)

    ;; Install qspaces into constraint network and reset all qvals and pvals.
    (mapc #'(lambda (var qspace-pair)
	      (setf (variable--qspace var) (cdr qspace-pair)
		    (variable--qval var)   NIL
		    (variable--pvals var)  NIL))
	  (qde-variables qde)
	  (qde-qspaces qde))

    ;; Install initial corresponding values.
    (dolist (cvalue (qde-cvalues qde))
      (setf (constraint--cvals (car cvalue)) (cdr cvalue)))

    ;; For all continuous variables except "time", create all possible values.
    (dolist (var (cdr (qde-variables qde)))
      (unless (variable-discrete-p var)
	
	;; This is not an independent variable.
	(let ((qdirs  (cond ((variable-independent-p var) '(std))
			    ((variable-ignore-qdir-p var) '(ign))
			    (t                            '(dec std inc))))
	      (*all-qvals* nil))
	  (declare (special *all-qvals*))
	  ;; Generate all possible qvals for this variable.
	  (gen-qvals nil nil (variable--qspace var) qdirs var)
	  (setq *all-qvals* (delete-if #'(lambda (qval)
					   (member (qmag qval) (variable-unreachable-values var)))
				       *all-qvals*))
	  (setf (variable--pvals var) *all-qvals*))))

    ;; For each discrete variable, generate a list of its possible values
    ;; and save for use in the main loop.  Note that discrete variables
    ;; can only have landmark values, never interval values, and the qdir
    ;; is always 'std.
    (dolist (var (cdr (qde-variables qde)))
      (when (variable-discrete-p var)
	(let ((pvals (mapcar #'(lambda (lmark)
				 (make-qval :variable var
					    :qmag lmark
					    :qdir 'std))
			     (variable--qspace var))))
	  (push (cons var pvals) discrete-var-pvals))))
    
    ;; Generate envisionment.
    (if (null discrete-var-pvals)
	(generate-envisionment qde)
	(loop
	  (if (next-combination-of-discrete-values discrete-var-pvals)
	      (generate-envisionment qde)
	      (return))))
    nil

    ))

;;;-----------------------------------------------------------------------------

;; return nil when all combinations exhausted.
(defun next-combination-of-discrete-values (discrete-var-pvals)

  ;; Loop over all "variations" of this QDE.  Variations occur as
  ;; constraints-within-modes become active or inactive when a
  ;; discrete variable changes value.

  (let ((bumped-a-variable nil))
    (dolist (pair discrete-var-pvals)
      (let* ((var   (car pair))
	     (pvals (cdr pair))
	     (current-pval (first (variable--pvals var)))
	     next-pval)
	    
	(cond (;; If this is the first time through the loop, then set
	       ;; this discrete variable to its first pval.
	       (null current-pval)
	       (setf (variable--pvals var) (list (first pvals))
		     bumped-a-variable     t))
		  
	      (;; If this discrete variable has another value besides its
	       ;; current value, then set it to that value and do cfilter
	       ;; immediately.
	       (setq next-pval (cdr (member current-pval pvals)))
	       (setf (variable--pvals var) (list next-pval)
		     bumped-a-variable     t)
	       (return-from next-combination-of-discrete-values t))
		  
	      (;; This discrete variable must be at the end of its possible
	       ;; values, so reset it to its first possible value.
	       (setf (variable--pvals var) (list (first pvals)))))
	))
	
    bumped-a-variable))


;	  ;; Initialize constraint network prior to propagation.
;	  (constraint-net-for-state nstate)
;	  ;; Run propagation.
;	  (setq after-propagation (propagate-if-possible nstate))
	  
;;;-----------------------------------------------------------------------------

(defun generate-envisionment (qde)
  (declare (special trace-total-envisionment))
  
  (activate-moded-constraints qde)
  ;; Run cfilter.
  (let ((alists (cfilter qde #'check-qsim-constraint)))
  
    ;; Note:  The qvalues returned from cfilter have no time value yet.
    ;; Thus, each set of qvalues can potentially be at a time point or
    ;; a time interval, so we need to consider both cases.
    ;; Filter out invalid alists.
    ;(setq qvalues (delete-if #'filter-alists-at-env qvalues))
	  
    ;; If transition is triggered, then simulate that state with qsim.

    (if trace-total-envisionment
	(format *QSIM-Trace* "~%T.env. created ~a alists." (length alists)))
    alists
    ))

;;;-----------------------------------------------------------------------------

  
;    (setq P-states
;	  (delete nil (mapcar #'(lambda (alist) (make-graph-state alist qde 'ti))
;			      alists)))
;    (setq I-states
;	  (delete nil (mapcar #'(lambda (alist) (make-graph-state alist qde '(ti tj)))
;			      alists)))
;    (do ((L1 P-states (cdr L1)))
;	((null L1))
;      (do ((L2 I-states (cdr L2)))
;	  ((null L2))
;	(cond ((legal-PI-transition (car L1) (car L2) (qde-qspaces qde))
;	       (setq edges (cons (list (car L1) (car L2)) edges))))))
;    (do ((L1 I-states (cdr L1)))
;	((null L1))
;      (do ((L2 P-states (cdr L2)))
;	  ((null L2))
;	(cond ((legal-IP-transition (car L1) (car L2) (qde-qspaces qde))
;	       (setq edges (cons (list (car L1) (car L2)) edges))))))
;    (if trace-total-envisionment
;	(format *QSIM-Trace* "~%T.env. created ~a edges." (length edges)))
;    (setq *Envisionment* (list P-states I-states edges))
;    (format *QSIM-Trace* "~%Total envisionment of ~a created ~a P-states, ~a I-states, and ~a edges."
;	    qde (length P-states) (length I-states) (length edges))
;    (format *QSIM-Trace* "~%The variable *ENVISIONMENT* holds it on a list of the form: (P-states I-states edges).")
   


;;;  This is a modified version of new-state-from-qde.
;(defun make-graph-state (qvalues qde time)
;  (let* ((nqvalues (set-ign-qdirs (copy-alist qvalues)))
;	 (nstate   (make-state :qde           qde
;			       :qvalues       nqvalues
;			       :qspaces       (copy-alist (qde-qspaces qde))
;			       :cvalues       (copy-alist (qde-cvalues qde))
;			       :text          "total envisionment"
;			       :justification `(in-total-envisionment-of ,qde)
;			       :name          (genname 'S)
;			       )))
;
;    (setf (state-time nstate) (make-qval :qmag (convert-qmag (initial-time) (time-qspace qde))
;					 :qdir 'inc
;					 :variable (time-variable qde)
;					 ))
;    (set (state-name nstate) nstate)
;    nstate))
;
;  (let* ((state-name (genname 'S))
;	 (nstate
;	   (make-state :qde qde
;		       :qspaces (qde-qspaces qde)
;		       :constraints (qde-constraints qde)
;		       :name state-name
;		       :values alist
;		       :justification `(in-total-envisionment-of ,qde)
;		       :time time)))
;    (set state-name nstate)
;    (and (setq nstate (label-infinite-times nstate))
;	 (setq nstate (apply-time-label nstate))))



;;;  This checks all the qualitative values in the two alists, and returns T
;;;  if the transition is NOT consistent.
;;;  dd-- This new code assumes that the old and new values are from the same qde.
;;;  If not true, then this won't give correct answer!!!!

;(defun inconsistent-continuity (state candidate-qvalues)
;  (let ((check-function (if (time-point-p (state-time state))
;			    #'test-P-successor
;			    #'test-I-successor)))
;
;    ;; This code expects the three lists to be in the same order, by variable.
;    (notevery #'(lambda (oqvalue nqvalue qspace-pair)
;		  (funcall check-function oqvalue nqvalue (cdr qspace-pair)))
;	      (cdr (state-qvalues state))	; skip over time value
;	      (cdr candidate-qvalues)		; skip over time value
;	      (cdr (state-qspaces state)))))	; skip over time qspace


; These test if all values in a pair of states represent legal transitions.
;(defun legal-PI-transition (P I qspaces)
;  (do ((pvals (state-values P) (cdr pvals))
;       (ivals (state-values I))
;       (qval1 nil)
;       (qval2 nil))
;      ((null pvals) t)
;    (setq qval1 (cadr (car pvals)))
;    (setq qval2 (lookup (car (car pvals)) ivals))
;    (cond ((test-P-transition (qmag qval1) (qdir qval1) (qmag qval2) (qdir qval2)
;			      (lookup (car (car pvals)) qspaces)))
;	  (t (return nil)))))


;(defun legal-IP-transition (I P qspaces)
;  (do ((ivals (state-values I) (cdr ivals))
;       (pvals (state-values P))
;       (qval1 nil)
;       (qval2 nil))
;      ((null ivals) t)
;    (setq qval1 (cadr (car ivals)))
;    (setq qval2 (lookup (car (car ivals)) pvals))
;    (cond ((test-P-transition (qmag qval1) (qdir qval1) (qmag qval2) (qdir qval2)
;			      (lookup (car (car ivals)) qspaces)))
;	  (t (return nil)))))


;(defun filter-alists-at-env (qvalues)
;  "Filter value completions at total envisionment."
;  ;; Filter 1 -- illegal for a qmag to be (x* inc) or (x* dec) over a time interval.
;  (when (time-interval-p (cdar qvalues))
;    (dolist (qvalue qvalues)
;      (let ((qval (cdr qvalue)))
;	(when (and (qmag-point-p (qmag qval))
;		   (member (qdir qval) '(inc dec)))
;	  (if *trace-total-envisionment*
;	      (format t "~%Filtering out ~a over a time interval." qval))
;	  (return-from filter-alists-at-env NIL)))))
;  )


;(defun prepare-for-propagation (qde)
;  ;;; Install corresponding values into constraint network.
;  (dolist (cvalue (qde-cvalues qde))
;    (setf (constraint--cvals (car cvalue)) (cdr cvalue)))
;  
;  ;; 
;  (mapc #'(lambda (qspace-pair qvalue-pair)
;	    (let* ((qval   (cdr qvalue-pair))
;		   (var    (qval-variable qval))
;		   (qspace (cdr qspace-pair)))
;	      (setf (variable--qspace var) qspace
;		    (variable--qval   var) qval)))
;	(state-qspaces nstate)
;	(state-qvalues nstate))
;  ;; Activate/deactivate constraints within modes.
;  (activate-moded-constraints (state-qde nstate)))


;    ;; The "time" variable will be initially undefined.
;    (let ((time-var (time-variable qde)))
;      (setf (variable--pvals time-var) NIL))
;    
;    ;; For "time", create two possible values to represent a time point
;    ;; and a time interval.  The actual time values don't matter as long
;    ;; as they are recognizable as a time-point and time-interval.
;    (let ((time-var (time-variable qde))
;	  (time-0   (first  (time-qspace qde)))
;	  (time-1   (second (time-qspace qde))))
;      (setf (variable--pvals time-var)
;	    (list (make-qval :variable time-var
;			     :qmag time-0
;			     :qdir 'inc)
;		  (make-qval :variable time-var
;			     :qmag (list time-0 time-1)
;			     :qdir 'inc))))
    
