;;; -*- Mode:Common-Lisp; Package: QSIM; Syntax:COMMON-LISP; Base:10 -*-
;;; Copyright (c) 1986 by Benjamin Kuipers.
;;; Revised 1989 by Daniel Dvorak.

(in-package 'QSIM)


;;;=============================================================================
;;;  For each variable in turn, treat it as invisible and see how many
;;;  completions match each other.

(defun check-for-matches (qde)

  ;; For every variable ...
  (dolist (invisible-var (cdr (qde-variables qde)))	; ignore "time"
    (format t "~2%~a" (variable-name invisible-var))

    ;; For every completion1
    (do ((completions1 *all-states* (cdr completions1))
	 (m 0 (1+ m))
	 (preface nil nil))
	((endp completions1))

      ;(format t "~%List of completions = ~a" (car completions1))

      ;; For every completion2
      (do ((completions2 (cdr completions1) (cdr completions2))
	   (n (1+ m) (1+ n)))
	  ((endp completions2))
	
	(when (do ((vars   (cdr (qde-variables qde))  (cdr vars))
		   (pairs1 (cdar completions1)        (cdr pairs1))
		   (pairs2 (cdar completions2)        (cdr pairs2)))
		  ((endp vars) t)
		;(unless (eql (caar pairs1) (caar pairs2))
		;  (format t "~a :: ~a   " (car pairs1) (car pairs2)))
		(unless (eq  invisible-var (car vars))
		  (unless (eq (cdar pairs1) (cdar pairs2))
		    (return nil))))

	  ;; OK, this pair of completions matches except for the invisible var.
	  (if preface
	      (format t ", ~3d" n)
	      (progn
		(setq preface t)
		(format t "~%~3d matches ~3d" m n))))))))

;;;=============================================================================
;;;  Report the fewest variables which, if ignored, allow one state to 
;;;  match another.

(defun find-closest-matches (qde)
    ;; For every completion1
    (do ((completions1 *all-states* (cdr completions1))
	 (m 0 (1+ m))
	 (preface nil nil)
	 (min-diffs 999 999))
	((endp completions1))

      ;(format t "~%List of completions = ~a" (car completions1))

      ;; For every completion2
      (do ((completions2 (cdr completions1) (cdr completions2))
	   (n (1+ m) (1+ n))
	   (ndiffs 0 0))
	  ((endp completions2))
	
	(do ((vars   (cdr (qde-variables qde))  (cdr vars))
	     (pairs1 (cdar completions1)        (cdr pairs1))
	     (pairs2 (cdar completions2)        (cdr pairs2)))
	    ((endp vars))
		
	  ;(unless (eql (caar pairs1) (caar pairs2))
	  ;  (format t "~a :: ~a   " (car pairs1) (car pairs2)))
	  (unless (eq (cdar pairs1) (cdar pairs2))
	    (incf ndiffs)
	    (if (> ndiffs min-diffs)
		(return))))

	(when (< ndiffs min-diffs)
	  (setq min-diffs ndiffs
		best-n    n))
	)

      

	  ;; OK, this pair of completions matches except for the invisible var.
	  (if preface
	      (format t ", ~3d" n)
	      (progn
		(setq preface t)
		(format t "~%~3d matches ~3d" m n))))))))

  
(defun heart-normals ()
  "Find normal values for all variables, and all cvals among them."
  (declare (special heart-3-tanks))
  (let* ((init (make-initial-state heart-3-tanks
				   `(;; independent variables
				     (sabc (sabc* std))
				     (ax   (ax*   std))
				     (bx   (bx*   std))
				     (svx  (svx*  std))
				     (vc   (vc*   std))
				     (lvc  (lvc*  std))
				     ;; history variables
				     (x    (x*    std))
				     (y    (y*    std))
				     (z    (z*    std))
				     )
				   "Normal & quiescent"))
	 )
    ;(qsim init)
    (qsim-display init)
    ))

