;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package 'QSIM)


;;;
;;; D,#TD1PsT[Begin using 006 escapes](1 0 (NIL 0) (:SWISS :ITALIC NIL) "HL12I")Examples
(2 0 (NIL 0) (NIL NIL NIL) "CPTFONT");;;

;;;
;;; 1RC (Resistor-Capacitor) Circuit
2;;; 
(zl:grind-top-level
(macroexpand-1 (quote
(define-model (3 0 (NIL 0) (NIL :BOLD NIL) "CPTFONTCB")RC 2"Resistor-Capacitor-Circuit"
  (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
	      (R resistor (landmarks (r R*)))
	      (C capacitor (landmarks (c C*)) (initable q)))
  (connect (b t1) (r t1))
  (connect (r t2) (c t1))
  (connect (c t2) (b t2))
  )
)))


(defun 3RC-SIM2 ()
  (declare (special rc))
  (let ((initial-state (make-initial-state rc '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
						(c.c (C* std))
						(r.r (R* std))
						(q1  (0 nil))
						(i   ((0 inf) nil))
						)
					   "Charging Capacitor through Resistor")))
    (qsim initial-state)
    (qsim-display initial-state nil)
    ))



;;;
;;; 1Voltage Divider (Resisters in series)
2;;;
(zl:grind-top-level
  (macroexpand-1 (quote
(define-model 3VOLTAGE-DIVIDER 2"Voltage-Divider-Circuit"
  (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
	      (R1 resistor (landmarks (r R1*)))
	      (R2 resistor (landmarks (r R2*)))
	      )
  (connect (b t1) (r1 t1))
  (connect (r1 t2) (r2 t1))
  (connect (r2 t2) (b t2))
  )
)))

(defun 3VOLTAGE-DIVIDER-SIM2 ()
  (declare (special voltage-divider))
  (let ((initial-state (make-initial-state voltage-divider
					   '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
					     (r1.r (R1* std))
					     (r2.r (R2* std))
					     (i6   ((0 inf) nil))
					     )
					   "Voltage-divider (Resistors in series)")))
    (qsim initial-state)
    (qsim-display initial-state nil)
    ))

;;;
;;; 1RC High-Pass Filter
2;;;
(zl:grind-top-level
  (macroexpand-1 (quote
(define-model 3RC-HIGH-PASS-FILTER 2"RC High-Pass Filter"
  (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
	      (C1 capacitor (landmarks (c C1*)) (initable q))
	      (R1 resistor (landmarks (r R1*)))
	      )
  (connect (b t1)  (c1 t1))
  (connect (c1 t2) (r1 t1))
  (connect (r1 t2) (b t2))
  )
)))

(defun 3RC-HIGH-PASS-FILTER-SIM2 ()
  (declare (special rc-high-pass-filter))
  (let ((initial-state (make-initial-state rc-high-pass-filter
					   '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
					     (c1.c (C1* std))
					     (r1.r (R1* std))
					     (q1  (0 nil))
					     (i6  ((0 inf) nil))
						)
					   "RC High-Pass Filter")))
    (qsim initial-state)
    (qsim-display initial-state nil)
    ))


;;;
;;; 1RC-LADDER
2;;;
(zl:grind-top-level
  (macroexpand-1 (quote
(define-model 3RC-LADDER 2"RC Ladder"
  (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
	      (C1 capacitor (landmarks (c C1*)) (initable q))
	      (R1 resistor (landmarks (r R1*)))
	      (C2 capacitor (landmarks (c C2*)) (initable q))
	      (R2 resistor (landmarks (r R2*)))
	      )
  (connect (b t1)  (r1 t1))
  (connect (r1 t2) (c1 t1) (r2 t1))
  (connect (r2 t2) (c2 t1))
  (connect (c1 t2) (c2 t2) (b t2))
  )
)))

(defun 3RC-LADDER-SIM2 ()
  (declare (special rc-ladder))
  (let ((initial-state (make-initial-state rc-ladder
					   '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
					     (c1.c (C1* std))
					     (r1.r (R1* std))
					     (c2.c (C2* std))
					     (r2.r (R2* std))
					     (q1  (0 nil))
					     (q2  (0 nil))
					     (i11 ((0 inf) nil))
					     )
					   "RC Ladder")))
    (qsim initial-state)
    (qsim-display initial-state nil)
    ))


;;;
;;; 1Wheatstone Bridge
2;;;
(zl:grind-top-level
  (macroexpand-1 (quote
(define-model 3WHEATSTONE-BRIDGE 2"Wheatstone Bridge"
  (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
	      (R1 resistor (landmarks (r R1*)))
	      (R2 resistor (landmarks (r R2*)))
	      (R3 resistor (landmarks (r R3*)))
	      (R4 resistor (landmarks (r R4*)))
	      (R5 resistor (landmarks (r R5*)))
	      )
  (connect (b t1)  (r1 t1) (r2 t1))
  (connect (r1 t2) (r3 t1) (r5 t2))
  (connect (r2 t2) (r4 t1) (r5 t1))
  (connect (r3 t2) (r4 t2) (b t2))
  )
)))

(defun 3WHEATSTONE-BRIDGE-SIM2 ()
  (declare (special wheatstone-bridge))
  (let ((initial-state (make-initial-state wheatstone-bridge
					   '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
					     (r1.r (R1* std))
					     (r2.r (R2* std))
					     (r3.r (R3* std))
					     (r4.r (R4* std))
					     (r5.r (R5* std))
					     (i15  (0 nil))
					     )
					   "Wheatstone Bridge")))
    (qsim initial-state)
    (qsim-display initial-state nil)
    ))


;;;
;;; 1LC (Inductor-Capacitor) Circuit
2;;; 

(zl:grind-top-level
 (macroexpand-1 (quote
  (define-model 3LC-A 2"Inductor-Capacitor-Circuit"
  (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
	      (I inductor-a (landmarks (l (minf L* 0))))
	      (C capacitor (landmarks (c C*)) (initable q)))
  (connect (b t1) (i t1))
  (connect (i t2) (c t1))
  (connect (c t2) (b t2))
  )
)))


(defun 3LC-A-SIM2 ()
  (declare (special lc-a))
  (let ((initial-state (make-initial-state lc-a '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
						  (c.c (C* std))
						  (i.l (L* std))
						  (q1  (0 nil))
						  (i6  (0 nil))
						  )
					   "Charging Capacitor through Inductor")))
    (qsim initial-state)
    (qsim-display initial-state nil)
    ))





(zl:grind-top-level
 (macroexpand-1 (quote
  (define-model 3LC-B 2"Inductor-Capacitor-Circuit"
  (components (B battery (landmarks (v V*) (v1 V*) (v2 (0)) (i (0 inf))) (initable i))
	      (I inductor-b (landmarks (l (minf L* 0))))
	      (C capacitor (landmarks (c C*)) (initable q)))
  (connect (b t1) (i t1))
  (connect (i t2) (c t1))
  (connect (c t2) (b t2))
  )
)))


(defun 3LC-B-SIM2 ()
  (declare (special lc-b))
  (let ((initial-state (make-initial-state lc-b '((b.v (V* std)) (b.v1 (V* std)) (b.v2 (0 std))
						  (c.c (C* std))
						  (i.l (L* std))
						  (q1  (0 nil))
						  (i7  (0 nil))
						  )
					   "Charging Capacitor through Inductor")))
    (qsim initial-state)
    (qsim-display initial-state nil)
    ))
