;;; -*- Mode:Common-lisp; Package:qsim; Default-character-style:(Fix Bold Normal) -*-
;;; Copyright 1990, David Throop, University of Texas at Austin
(in-package :qsim)

;;; This file contains examples showing off the versiplot macro.

;;; This shows how to put the full plots of two behaviors, and their
;;; trees and some text, all on one screen, with some dashed lines
;;; breaking up the display.

(defun versiplot-bathtub ()
  (load-file-unless-already-loaded "bathtub")
  (let ((*allow-plotting* nil))
    (increase-flow))
  (let ((*picture*  "versiplot-bathtub")
	(xscreen 900)
	(yscreen 570)
	(layout '((amount level)
		  (pressure)
		  (nil outflow)
		  (inflow netflow)))
	(font #+symbolics '(:dutch :roman :normal) #-symbolics *plain-font*))
    (versiplot
	(.5 1 1 1 1)				; Five rows with top one shorter
	(1 1 1 1)				; Four columns of equal width
	(1)					; Line below first row
	(2)					; Line to right of 2nd column.
	(vplot-tree (v-place 1 1)		; The tree for behavior 1 in 
	    :bnum 1)				;   row 1, column 1.
	(vplot-text (v-place 1 2)		; Text in row 1, column 2.
		    '("The bathtub overflows"
		      "in the first"
		      "behavior") font)
	(vplot-tree (v-place 1 3)		; The tree for behavior 2
	    :bnum 2)				;  in row 1, column 3.
	(vplot-text (v-place 1 4)
		    '("The bathtub hits"
		      "steady state in the"
		      "second behavior") font)
	(vplot-parameters layout 1		; Behavior 1
	    2 5					;  between 2nd and 5th rows
	    1 2)				;  between 1st and 2nd columns
	(vplot-parameters layout 1		; Behavior 2
	    2 5					;  between 2nd and 5th rows
	    3 4)				;  between 3rd and 4th columns
	)))

;;; This is just to show off the :COLUMNS-WIDE and :ROWS-TALL options.

(defun 5box ()
  (let ((xscreen 900)
	(yscreen 570))
    (versiplot
	(2 2 2)
	(2 2 2)
	nil nil
	(vplot-box (v-place 1 1 :columns-wide 2) :label :upleft)
	(vplot-box (v-place 1 3 :rows-tall 2) :label :upright)
	(vplot-box (v-place 3 2  :columns-wide 2) :label :downright)
	(vplot-box (v-place 2 1 :rows-tall 2) :label :downleft)
	(vplot-text (v-place 2 2)
	    '("This function shows how the"
	      ":COLUMNS-WIDE and :ROWS-TALL"
	      "options can be used in the "
	      "V-Place macro to specify"
	      "plots which span more than"
	      "one column or row.")
	    #+symbolics '(:dutch :roman :normal) #-symbolics *plain-font*
	    :margin 20 :max-spacing 17))))

;;; This shows the use of the :COLUMN-OFFSET and :ROW-OFFSET options in
;;; the V-place macro.

(defun 5offbox ()
  (let ((xscreen 900)
	(yscreen 570))
    (load-file-unless-already-loaded "springs")
    (let ((*allow-plotting* nil))
      (release-spring-w-friction-acc))
    (versiplot
	(1 1 1)					; Three equal row, three equal columns
	(1 1 1)
	nil nil					; No horiz or vertical dashed lines
	(vplot-phase-plane
	    (v-place 1 1			; Phase plane in row 1, col 1
		     :columns-wide 1.5		;  extra width
		     :column-offset .5)		;  inset from left edge
	    '(v a) 3)				;  plot V vs A from behavior 3.
	(vplot-phase-plane (v-place 1 3 :rows-tall 1.5 :row-offset .5) '(a x) 3)
	(vplot-phase-plane (v-place 3 2  :columns-wide 1.5) '(v ff) 3)
	(vplot-phase-plane (v-place 2 1 :rows-tall 1.5 ) '(v x) 3)
	(vplot-text (v-place 2 2)
	    '("  This function shows how the"
	      ":COLUMN-OFFSET and"
	      ":ROW-OFFSET options can be"
	      "used in the V-Place macro"
	      "to specify plots which are"
	      "offset from the edge of the"
	      "row or column."
	      "  It also illustrates the use of the"
	      "VPLOT-PHASE-PLANE function.") 
	    #+symbolics '(:dutch :roman :normal) #-symbolics *plain-font*
	    :margin 10 :max-spacing 17))))

(defun tank-chatter-phase-plane ()
  (let ((xscreen 900)
	(yscreen 570))
    (load-file-unless-already-loaded "acc-two-tank")
    (let ((*allow-plotting* nil))
      (fill-two-tanks-from-empty))
    (versiplot (1 1 1)				; 3 equal rows
	(1 1 1 1)				; 4 equal columns
	nil nil					; no dotted lines
	(vplot-many-phase-planes
	    '((1 2 3) (4 6 nil 8)(9 nil nil 11))	; Plot plot phaseplanes of these behaviors
	    '(netflowa netflowb)		; For these parameters
	    1 3					; Between rows 1, 3
	    1 4)				; Between columns 1 4
	(vplot-text (v-place 3 2 :column-offset .5)
	    '("  This function shows how to"
	      "use the VPLOT-MANY-PHASE-PLANES"
	      "macro to compare phase planes"
	      "across a behavior.")
	    #+symbolics '(:dutch :roman :normal) #-symbolics *plain-font*
	    :margin 10 :max-spacing 17))))