;;; -*- Syntax: Common-lisp; Package: qsim; Default-character-style: (:FIX :ROMAN :NORMAL) -*-

;;;  $Id: two-stage-bathtub.lisp,v 1.2 91/09/16 14:12:07 clancy Exp $
(in-package :qsim)
(defun fill-a-plugged-bathtub ()
  (declare (special plugged))
  (let* ((initial-state
	  (make-initial-state plugged
			      '((inflow (if* std))
				(amount (0 nil)))
			      "Filling at constant rate, starting from empty")))
    (format *qsim-report* " This is the deluxe Bathtub example.  It shows 
a region transition to an underspecified state.
 This bathtub has a pressure-sensitive plug.  When the amount of water in the bathtub
 reaches a trigger amount, the plug opens.  This leads to a region transition from Plugged
 to Emptying.  There are three possible continuations - the amount continues to increase,
 or it stays steady at the triggered level, or it decreases. ")
    (qsim initial-state)
    (qsim-display initial-state)        
    ))

(defun increase-inflow-in-plugged-bathtub ()
  (declare (special plugged))
  (let* ((quiet (make-initial-state plugged
				     '((inflow (0 std))
				       (amount ((0 trigger) std)))
				     "No flow, some water"))
	 (filling (make-modified-state quiet
				       `((amount (,(qmag (alookup 'amount (state-qvalues quiet))) nil))
					 (inflow (if* std)))
				       "Now Filling")))
    (qsim filling)
    (qsim-display filling :reference-states `((quiet ,quiet)))))

(define-qde plugged 
	    (text "Filling bathtub with no drain.")
  (quantity-spaces
    (amount    (0 trigger FULL inf) "The Amount")
    (inflow    (0 if* inf) "The Inflow"))
  (constraints ((constant inflow))
	       ((d/dt amount inflow)))
  (layout  (nil nil amount nil)
	   (time inflow outflow)
	   (nil netflow nil))
  (transitions  ((amount (trigger inc)) open-plug)))

(define-qde emptying
	    (text "Emptying tub with open drain.")
  (quantity-spaces
    (amount    (0 trigger FULL inf))
    (inflow    (0 if* inf))
    (outflow   (0 inf))
    (netflow   (minf 0 inf)))
  (constraints ((constant inflow))
	       ((d/dt amount netflow))
	       ((m+ outflow amount)(0 0)(inf inf))
	       ((add outflow netflow inflow)))
  (transitions (overflowing-p t)))

(defun open-plug (state)
  (create-transition-state :from-state state
     :to-qde emptying
     :inherit-qmag '(inflow amount)))

;;; This OVERFLOWING-P could have been implemented as a (amount (full
;;; inc)) test in the transitions clause.  However, the most general
;;; form of the transitions clause is to have a function in that
;;; position, and this is the only test example we have of that.

(defun overflowing-p (state)
  (let ((qval (qval 'amount state)))
    (and (eq (qdir qval) 'inc)
	 (atom (qmag qval))
	 (eq (lmark-name (qmag qval)) 'full))))