;;; -*- Syntax: Common-lisp; Package: qsim -*-
(in-package :qsim)

;;; This variant on the Rocket has a finite length, and a location of
;;; its tail (which is initially below the ground.)  When the rocket
;;; height goes to infinity (at infinite time), we generate values for
;;; the ADD constraint of (inf l* inf).  The handling of such a
;;; situation has caused some confusion; this example tests the scenario
;;; diretly.

(define-QDE rocket-w-tail
  (text  "Rocket with tail - tests (add inf l* inf) where l* is finite.")
  (quantity-spaces
    (y   (minf 0 inf))
    (tail (minf 0 inf))
    (length (0 l* inf))
    (v   (minf 0 v* inf))
    (a   (minf g 0)))
  (constraints
    ((d/dt v a))
    ((constant length))
    ((add tail length y))
    ((d/dt y v))
    ((s+ y a (minf minf) (inf 0))  (0 g))
    )
  (transitions
    ((y (0 dec)) t))
  (layout (tail  y)
	  (length v)
	  ( nil a)))



(defun fire-rocket-w-tail ()
  (let ((initial
	  (make-new-state :from-qde      rocket-w-tail
			  :assert-values '((y  (0 nil))
					   (v  (v* nil))
					   (length  (l* nil))
					   (a  (g  nil)))
			  :text "Rocket shot upward")))
    (qsim initial)
    (qsim-display initial)))
