;;; -*- Syntax: Common-lisp; Package: qsim -*-

;;;  $Id: pressure-regulator.lisp,v 1.2 91/09/16 14:12:04 clancy Exp $
(in-package :qsim)
; This is a modified version of DKB's pressure regulator.  The valve has
; only motion, not accelleration, but we have another derivative constraint
; controlling changes to Pout.

(define-QDE Pressure-Regulator-A
   (text "Pressure Regulator")
   (quantity-spaces
      (Pin     (0 Pin- Pin* Pin+ inf))
      (Pout    (0 Pout* inf))
      (P       (minf 0 P* inf))
      (Q       (minf 0 Q* inf))
      (PQ      (minf 0 PQ* inf))
      (R       (0 R* inf))
      (X       (0 X* XM inf))
      (Fs      (minf 0 Fs* inf))
      (dX      (minf 0 inf))
      (dPout   (minf 0 inf)))
   (constraints
      ((add P Pout Pin)     (p* pout* pin*))
      ((mult R Q P)         (r* q* p*))
      ((m+ Q PQ)            (q* pq*)        (0 0) (inf inf) (minf minf))
      ((add Pout dPout PQ)  (pout* 0 pq*))
      ((d/dt Pout dPout))
      ((m+ X R)             (x* r*)         (XM inf))
      ((m+ X Fs)            (x* fs*)        )
      ((add Fs dX Pout)     (fs* 0 pout*))
      ((d/dt X dX)))
   (independent Pin)
   (history X dX)      
   (print-names
      (Pin  "Input pressure")
      (Pout "Output pressure")
      (P    "Pressure drop")
      (Q    "Flow rate")
      (PQ   "Pressure from Q")
      (dPout "change in Pout")
      (R    "Resistance")
      (X    "Position of valve")          ; positive downward
      (Fs   "Force from spring")          ; positive upward
      (dX   "Valve motion"))
   (layout (Pin Pout X R)
	   (P Q PQ dPout)
	   (nil dX Fs)
	   nil)
   )

; Examples of regulator
; Initialize with Pin higher than normal and steady.

(defun high-input-pressure ()
  (let* ((normal (make-initial-state pressure-regulator-A
				     '((Pin  (Pin* std))
				       (Pout (Pout* nil))
				       (X    (X* nil)))))
	 (init (make-modified-state normal
				    '((Pin  (Pin+ std))
				      (Pout (Pout* nil))
				      (X    (X* nil)))
				    "Increased input pressure")))
    (qsim init)
    (qsim-display init :reference-states `((normal ,normal)))
    ))
