;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package :qsim) ;changed DJC

;;;*****************************************************************************
;;;This qde models an isothermal batch reactor with 3 1st-order irreversible
;;;reactions in series A -> B -> C -> D  occurring. 
;;;*****************************************************************************


(define-qde batch-a->b->c->d
  (text "Isothermal batch CSTR reactor for the reactions A -> B -> C -> D")
  (quantity-spaces
    (-cao (minf cao 0))
    (k1 (0 k1 inf))
    (k2 (0 k2 inf))
    (k3 (0 k3 inf))
    (ca (0 cao inf))
    (cb (0 cao inf))
    (cc (0 cao inf))
    (cd (0 cao inf))
    (ra (0 inf))
    (rb (0 inf))
    (dca/dt (minf 0 inf))
    (dcb/dt (minf 0 inf))
    (dcc/dt (minf 0 inf))
    (dcd/dt (minf 0 inf)))
  (constraints
    ((mult k1 ca ra))
    ((mult k2 cb rb))
    ((mult k3 cc dcd/dt))
    ((minus dca/dt ra))
    ((add dcb/dt rb ra))			
    ((add dcc/dt dcd/dt rb))
    ((sum-zero ca cb cc cd -cao)
     (cao 0 0 0 cao) (0 cao 0 0 cao) (0 0 cao 0 cao) (0 0 0 cao cao))
    ((sum-zero dca/dt dcb/dt dcc/dt dcd/dt))
    ((d/dt ca dca/dt))
    ((d/dt cb dcb/dt))				
    ((d/dt cc dcc/dt))				
    ((d/dt cd dcd/dt)))
  (independent k1 k2 k3 -cao)
  (print-names
    (ca "Concentration of A" ca)
    (cb "Concentration of B" cb)
    (cc "Concentration of C" cc)
    (cd "Concentration of D" cd)
    (-cao "Initial Concentration of A" cao)
    (dca/dt "dcA/dt" dca)
    (dcb/dt "dcB/dt" dcb)
    (dcc/dt "dcC/dt" dcc)
    (dcd/dt "dcD/dt" dcd))
  (layout
    (ca dca/dt)
    (cb dcb/dt)
    (cc dcc/dt)
    (cd dcd/dt))
  )

(defun abcd (analytic-functions-only-p hod-constraints-p)
  (qsim-cleanup)
  (qsim-display
    (envision :qde batch-a->b->c->d
	      :values
	      '((k1 (k1 std))
		(k2 (k2 std))
		(k3 (k3 std))
		(-cao (cao std))
		(ca (cao nil))
		(cb (0 nil))
		(cc (0 nil))
		(cd (0 nil)))
	      :sim (make-sim :state-limit 100
			     :analytic-functions-only analytic-functions-only-p 
			     :hod-constraints hod-constraints-p))))

(defun abcd1 ()
  (abcd nil nil))

(defun abcd2 ()
  (abcd t nil))

(defun abcd3 ()
  (abcd nil t))

(defun abcd4 ()
  (abcd t t))


(defun batch-a->b->c->d-text ()
  (format t "~2%This qde models an isothermal batch reactor with 4 1st-order irreversible")
  (format t "~%reactions in series A -> B -> C -> D -> E occurring.  The modeling equations")
  (format t "~%are:")
  (format t "~2%  dCa/dt = -k1Ca")
  (format t "~2%  dCb/dt = k1Ca - k2Cb")
  (format t "~2%  dCc/dt = k2Cb - k3Cc")
  (format t "~2%  dCd/dt = k3Cc - k4Cd")
  (format t "~2%  dCe/dt = k4Cd")
  (format t "~2%where the ki's are the first-order reaction rate constants."))
