;;; -*- Package: qsim; Syntax: Common-lisp -*-

;;;  $Id: coeffs-w-tube.lisp,v 1.2 91/09/16 14:11:16 clancy Exp $
(in-package :qsim)
; W-tube with modified hod constraints included.

(define-QDE W-tube
	    (text "W-tube system")
  (quantity-spaces
    (amounta (0  amta* sabc* inf))
    (amountb (0  amtb* inf))
    (amountc (0  amtc* inf))
    (pressurea (0 pa* inf))
    (pressureb (0 pb* inf))
    (pressurec (0 pc* inf))
    (inflowa (0 inf))
    (delta-ab (minf 0 inf))
    (delta-bc (minf 0 inf))
    (crossflowab (minf 0 inf))
    (crossflowbc (minf 0 inf))
    (outflowc (0 inf))
    (netflowa (minf 0 inf))
    (netflowb (minf 0 inf))
    (netflowc (minf 0 inf))
    (sumab (0 sab* sabc* inf))
    (sumabc (0 sabc* inf))
    (netflowab (minf 0 inf))
    )
  (constraints
    ((M+ pressurea amounta)(0 0)(pa* amta*))
    ((M+ pressureb amountb)(0 0)(pb* amtb*))
    ((M+ pressurec amountc)(0 0)(pc* amtc*))
    ((add delta-ab pressureb  pressurea)(0 0 0)(0 pb* pa*))
    ((add delta-bc pressurec  pressureb)(0 0 0)(0 pc* pb*))
    ((m+ crossflowab delta-ab)(0 0)(inf inf))
    ((m+ crossflowbc delta-bc)(0 0)(inf inf))
    ((add netflowa crossflowab inflowa)(0 0 0))
    ((add netflowb crossflowbc crossflowab)(0 0 0))
    ((add netflowc outflowc crossflowbc)(0 0 0))
    ((d/dt amounta netflowa))
    ((d/dt amountb netflowb))
    ((d/dt amountc netflowc))
    ((d/dt sumab netflowab))
    ((m- netflowab netflowc))
    ((add amounta amountb sumab)(0 0 0)(sabc* 0 sabc*)(amta* amtb* sab*))
    ((add sumab amountc sumabc)(sab* amtc* sabc*)(sabc* 0 sabc*))
    ((add netflowa netflowb netflowab)(0 0 0))
    )
  (independent inflowa outflowc  sumabc)
  (history amounta amountb  amountc)
  (layout
    (amounta amountb amountc)
    (sumab netflowab sumabc)
    (crossflowab crossflowbc outflowc)
    (netflowa netflowb netflowc))
  (Print-names
    (amounta "amount (A)" amta)
    (amountb "amount (B)" amtb)
    (amountc "amount (C)" amtc)
    (pressurea "pressure (A)" pa)
    (pressureb "pressure (B)" pb)
    (pressurec "pressure (C)" pc)
    (delta-ab "d press(A-B)" dab)
    (delta-bc "d press(B-C)" dbc)
    (inflowa "flow ( -> A)" ifa)
    (crossflowab "crossflow A -> B" cfab)
    (crossflowbc "crossflow B -> C" cfbc)
    (outflowc "flow (C->out)" ofc)    
    (netflowa "d amount (A)" nfa)
    (netflowb "d amount (B)" nfb)
    (netflowc "d amount (C)" nfc)
    (sumab "amount (A+B)" sab)
    (sumabc "amount (A+B+C)" sabc)
    (netflowab "d amount (A+B)" nfc)
))
 
; Modified curvature constraints. Element with "*" symbol does not have sign ambiguity.
; Element without "*" symbol has sign-ambiguity.
; All three assignments, t -> default, 0, and nil -> (minus default), are allowed.

(defun W-tube-hod-constraints(signs qde)
  (let((default-cast-clause  '((netflowB        (sd1 netflowA) )
			       (netflowA        (sd1 netflowB) *)
			       (netflowC        (sd1 netflowB) *))))
    (cast-clause-of-coupled-qdes signs default-cast-clause qde)
    (sd3-clause-of-coupled-qdes  signs default-cast-clause qde)))

; Example 1. Initial state: A tube is full, B and C tubes are empty.
(defun W-tube (&rest acc-sign-specs)    
   (declare (special W-tube))
   (setq *perform-acc-analysis* t)
   (W-tube-hod-constraints  acc-sign-specs W-tube)
   
  (let*((init (make-initial-state W-tube
				    '((amounta (sabc* nil))
				      (amountb (0  nil))
				      (amountc (0  nil))
				      (sumabc (sabc* std))
				      (inflowa (0 std))
				      (outflowc (0 std))
				      (netflowa ((minf 0) inc))
				      (netflowb ((0 inf) nil))
				      (netflowab (nil dec))
				      ))))
    (qsim init)
    (qsim-display init)))

; Example 2. Initial state: A tube is at equilibrium level, B below and C above the equilibrium level.
(defun W-tube1 (&rest acc-sign-specs)    
   (declare (special W-tube))
   (setq *perform-acc-analysis* t)
   (W-tube-hod-constraints  acc-sign-specs W-tube)

  (let*((init (make-initial-state W-tube
				  '((amounta (amta* dec))
				    (amountb ((0 amtb*) inc))
				    (amountc ((amtc* inf) dec))
				    (pressurec ((pc* inf) dec))
				    (delta-ab ((0 inf) dec))
				    (inflowa (0 std))
				    (outflowc (0 std))
				    (sumabc (sabc* std))
				    (netflowb ((0 inf) dec))
				    ))))
    (qsim init)
    (qsim-display init)))

; Sample runs: with maximum 240.
; Output - (No. of simulated-states, No. of behaviors, No. terminated at quiescent-states)
; Initial state B and C empty: 
; (w-tube)             output - (172     4     4)  crossflow: A->B > B->C
; (w-tube   0)                  ( 50     1     1)  crossflow: A->B = B->C
; (w-tube nil)                  ( 29     1     1)  crossflow: A->B < B->C
; Initial state B low and C high: 
; (w-tube1)                     ( 31     1     1)  crossflow: A->B > B->C    
; (w-tube1 0)                   ( 52     1     1)  crossflow: A->B = B->C
; (w-tube1 nil)                 (174     4     4)  crossflow: A->B < B->C

             