;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

;;;  $Id: acc-d-tanks.lisp,v 1.3 91/11/22 19:38:06 clancy Exp $
(in-package :qsim)
; Difference of the amounts of parallel tank systems: 
;
; Results: switch on analytic function control.
; 1. y-tanks: severe branching problem.
; 2. dy-tanks: improved situation.
; 3. dy-tanks-acc: tamed behavior(s). 

; Lessons on knowledge engineering:
; 1. Inclusion of dy/dt: To combat the ambiguity in qualitative mathematics in the 
;    determination of y, it is desirable to include dy/dt term to "control" the prediction 
;    of y. 
; 2. Refinement in qspace: We have introduced "k" and "lam" to allow the ordinal specification
;    among the "k1" and "k2" pair and among the "lam1" and "lam2" pair.
; 3. The curvature constraint tames the residual chattering behavior. 

; 1. Difference of the solutions of two simple tanks.

(define-QDE tanks-y
  (text "Difference of solutions of two simple tanks")
  (quantity-spaces
    (lam1  ( 0    lam1* inf))   ; context: parameters
    (lam2  ( 0    lam2* inf))
    (k1    ( 0      k1* inf))
    (k2    ( 0      k2* inf))
    (u     ( 0       u* u+ inf))

    (x1    ( 0     x1*  inf))   ; tank1: parameters
    (if1   ( 0    if1*  inf))
    (of1   ( 0    of1*  inf))
    (nf1   (minf   0    inf))
    (x2    ( 0     x2*  inf))   ; tank2: parameters
    (if2   ( 0    if2*  inf))
    (of2   ( 0    of2*  inf))
    (nf2   (minf   0    inf))
    (y     ( 0      y*  inf))   ; difference: parameter
    )
  (constraints
    ((mult k1   u  if1) (0 0 0) (k1*   u*  if1*)) ; tank1
    ((mult lam1 x1 of1) (0 0 0) (lam1* x1* of1*))
    ((d/dt x1 nf1))
    ((add  nf1 of1 if1) (0 0 0)(0 of1* if1*))
    ((mult k2   u  if2) (0 0 0)(k2* u* if2*))     ; tank2
    ((mult lam2 x2 of2) (0 0 0)(lam2* x2* of2*))
    ((d/dt x2 nf2))
    ((add   nf2 of2 if2)(0 0 0)(0 of2* if2*))
    ((add y x1 x2)(0 0 0) (y* x1* x2*))
    )
  (independent lam1 lam2 k1 k2 u)
  (history x1 x2 y)
  (layout
    (x1 x2 y)
    (if1 if2 nil)
    (of1 of2 nil)
    (nf1 nf2 nil))
  (print-names
    (if1   "flow(ext->1)"  if1)
    (x1    "amount(1)"     amt1)
    (of1   "outflow(1)"    of1)
    (nf1   "d amount(1)"   nf1)
    (if2   "flow(ext->2)"  if2)
    (x2    "amount(2)"     amt2)
    (of2   "outflow(2)"    of2)
    (nf2   "d amount(2)"   nf2)
    (y     "amt2-amt1"     y)
    )
  )

(defun y-tanks ()
  (let* ((normal (make-initial-state tanks-y
				     '((x1 (x1* std))
				       (x2 (x2* std))
				       (lam1 (lam1* std))
				       (lam2 (lam2* std))
				       (k1 (k1* std))
				       (k2 (k2* std))
				       (u (u* std)))))
	 (init (make-modified-state normal
				    '((lam1 (lam1* std))
				      (lam2 (lam2* std))
				      (k1 (k1* std))
				      (k2 (k2* std))
				      (u (u* std))
				      (y (nil inc))
				      (x1 (0 nil))
				      (x2 (0 nil))))))
    (qsim init)
    (qsim-display init
		  :reference-states `((normal ,normal)))
    ))



; 2. Difference of the solutions with the inclusion of dy of two simple tanks.

(define-QDE Tanks-dy
  (text "Difference of solutions with dy of two simple tanks")
  (quantity-spaces
    (lam1  ( 0    lam1* inf))   ; context: parameters
    (lam2  ( 0    lam2* inf))
    (k1    ( 0      k1* inf))
    (k2    ( 0      k2* inf))
    (u     ( 0       u* u+ inf))

    (x1    ( 0     x1*  inf))   ; tank1: parameters
    (if1   ( 0    if1* if1+ inf))
    (of1   ( 0    of1*  inf))
    (nf1   (minf   0    inf))
    (x2    ( 0     x2*  inf))   ; tank2: parameters
    (if2   ( 0    if2* if2+ inf))
    (of2   ( 0    of2*  inf))
    (nf2   (minf   0    inf))
    (y     ( 0      y*  inf))   ; difference: parameter
    (ify   ( 0    ify*  inf))   ; with dy/dt included
    (ofy   ( 0    ofy*  inf))
    (nfy   ( minf   0   inf))
    (lam   ( 0    lam*  inf))   ; context parameters
    (k     ( 0      k*  inf))
    (lamx1 ( 0  lamx1*  inf))
    (ku    ( 0     ku*  ku+ inf))
    )
  (constraints
    ((mult k1   u  if1) (0 0 0) (k1*   u*  if1*)(k1*   u+  if1+)) ; tank1
    ((mult lam1 x1 of1) (0 0 0) (lam1* x1* of1*))
    ((d/dt x1 nf1))
    ((add  nf1 of1 if1) (0 0 0)(0 of1* if1*))
    ((mult k2   u  if2) (0 0 0)(k2* u* if2*)(k2* u+ if2+))     ; tank2
    ((mult lam2 x2 of2) (0 0 0)(lam2* x2* of2*))
    ((d/dt x2 nf2))
    ((add   nf2 of2 if2)(0 0 0)(0 of2* if2*))
    ((add y x1 x2)(0 0 0) (y* x1* x2*))           ; difference
    ((add lam lam2 lam1)(0 0 0)(lam* lam2* lam1*))
    ((add k k1 k2)(0 0 0)(k* k1* k2*))
    ((mult lam x1 lamx1)(0 0 0)(lam* x1* lamx1*))
    ((mult k u ku)(0 0 0)(k* u* ku*)(k* u+ ku+))
    ((add lamx1 ku ify)(0 0 0)(lamx1* ku* ify*))
    ((mult lam2 y ofy)(0 0 0)(lam2* y* ofy*))
    ((d/dt y nfy))
    ((add nfy ofy ify)(0 0 0)(0 ofy* ify*))
    )
  (independent lam1 lam2 lam k1 k2 k if1 if2 u ku)
  (history x1 x2 y)
  (layout
    (x1 x2 y)
    (if1 if2 ify)
    (of1 of2 ofy)
    (nf1 nf2 nfy))
  (print-names
    (if1   "flow(ext->1)"  if1)
    (x1    "amount(1)"     amt1)
    (of1   "outflow(1)"    of1)
    (nf1   "d amount(1)"   nf1)
    (if2   "flow(ext->2)"  if2)
    (x2    "amount(2)"     amt2)
    (of2   "outflow(2)"    of2)
    (nf2   "d amount(2)"   nf2)
    (ify   "flow(ext->y)"  ify)
    (y     "amt2-amt1"     y)
    (ofy   "outflow(y)"    ofy)
    (nfy   "d amount(y)"   nfy)
    )
  )

(defun dy-tanks ()
  (let* ((normal (make-initial-state tanks-dy
				     '((x1 (x1* std))
				       (x2 (x2* std))
				       (lam1 (lam1* std))
				       (lam2 (lam2* std))
				       (lam (lam* std))
				       (k1 (k1* std))
				       (k2 (k2* std))
				       (k (k* std))
				       (ku (ku* std))
				       (if1 (if1* std))
				       (if2 (if2* std))
				       (nfy (0 std))
				       (ify (ify* std))
				       (u (u* std)))))

	 (init (make-modified-state normal
				    '((lam1 (lam1* std)) ;context parameters
				      (lam2 (lam2* std))
				      (lam (lam* std))
				      (k1 (k1* std))
				      (k2 (k2* std))
				      (k (k* std))
				      (if1 (if1* std))
				      (if2 (if2* std))
				      (u (u* std))
				      (ku (ku* std))
				      (if1 (if1* std))
				      (if2 (if2* std))

				      (x1 (0 nil))       ;variables
				      (x2 (0 nil))
				      (nf1 ((0 inf) nil))
				      (nf2 ((0 inf) nil))
				      (nfy ((0 inf) inc))))))
    (qsim init)
    (qsim-display init
		  :reference-states `((normal ,normal)))
    ))


; 3. ACC: Difference of the solutions with the inclusion of dy of two simple tanks.

(define-QDE Tanks-dy-acc
  (text "Difference of solutions with dy of two simple tanks")
  (quantity-spaces
    (lam1  ( 0    lam1* inf))   ; context: parameters
    (lam2  ( 0    lam2* inf))
    (k1    ( 0      k1* inf))
    (k2    ( 0      k2* inf))
    (u     ( 0       u* u+ inf))

    (x1    ( 0     x1*  inf))   ; tank1: parameters
    (if1   ( 0    if1* if1+ inf))
    (of1   ( 0    of1*  inf))
    (nf1   (minf   0    inf))
    (x2    ( 0     x2*  inf))   ; tank2: parameters
    (if2   ( 0    if2* if2+ inf))
    (of2   ( 0    of2*  inf))
    (nf2   (minf   0    inf))
    (y     ( 0      y*  inf))   ; difference: parameter
    (ify   ( 0    ify*  inf))   ; with dy/dt included
    (ofy   ( 0    ofy*  inf))
    (nfy   ( minf   0   inf))
    (lam   ( 0    lam*  inf))   ; context parameters
    (k     ( 0      k*  inf))
    (lamx1 ( 0  lamx1*  inf))
    (ku    ( 0     ku*  ku+ inf))
    )
  (constraints
    ((mult k1   u  if1) (0 0 0) (k1*   u*  if1*)(k1*   u+  if1+)) ; tank1
    ((mult lam1 x1 of1) (0 0 0) (lam1* x1* of1*))
    ((d/dt x1 nf1))
    ((add  nf1 of1 if1) (0 0 0)(0 of1* if1*))
    ((mult k2   u  if2) (0 0 0)(k2* u* if2*)(k2* u+ if2+))     ; tank2
    ((mult lam2 x2 of2) (0 0 0)(lam2* x2* of2*))
    ((d/dt x2 nf2))
    ((add   nf2 of2 if2)(0 0 0)(0 of2* if2*))
    ((add y x1 x2)(0 0 0) (y* x1* x2*))           ; difference
    ((add lam lam2 lam1)(0 0 0)(lam* lam2* lam1*))
    ((add k k1 k2)(0 0 0)(k* k1* k2*))
    ((mult lam x1 lamx1)(0 0 0)(lam* x1* lamx1*))
    ((mult k u ku)(0 0 0)(k* u* ku*)(k* u+ ku+))
    ((add lamx1 ku ify)(0 0 0)(lamx1* ku* ify*))
    ((mult lam2 y ofy)(0 0 0)(lam2* y* ofy*))
    ((d/dt y nfy))
    ((add nfy ofy ify)(0 0 0)(0 ofy* ify*))
    )
  (independent lam1 lam2 lam k1 k2 k if1 if2 u ku)
  (other (curvature-at-steady nil))
  (history x1 x2 y)
  (layout
    (x1 x2 y)
    (if1 if2 ify)
    (of1 of2 ofy)
    (nf1 nf2 nfy))
  (print-names
    (if1   "flow(ext->1)"  if1)
    (x1    "amount(1)"     amt1)
    (of1   "outflow(1)"    of1)
    (nf1   "d amount(1)"   nf1)
    (if2   "flow(ext->2)"  if2)
    (x2    "amount(2)"     amt2)
    (of2   "outflow(2)"    of2)
    (nf2   "d amount(2)"   nf2)
    (ify   "flow(ext->y)"  ify)
    (y     "amt2-amt1"     y)
    (ofy   "outflow(y)"    ofy)
    (nfy   "d amount(y)"   nfy)
    )
  )

(defun dy-tanks-acc ()
  (let* (( *perform-acc-analysis* t)
	 (normal (make-initial-state tanks-dy-acc
				     '((x1 (x1* std))
				       (x2 (x2* std))
				       (lam1 (lam1* std))
				       (lam2 (lam2* std))
				       (lam (lam* std))
				       (k1 (k1* std))
				       (k2 (k2* std))
				       (k (k* std))
				       (ku (ku* std))
				       (if1 (if1* std))
				       (if2 (if2* std))
				       (nfy (0 std))
				       (ify (ify* std))
				       (u (u* std)))))

	 (init (make-modified-state normal
				    '((lam1 (lam1* std)) ;context parameters
				      (lam2 (lam2* std))
				      (lam (lam* std))
				      (k1 (k1* std))
				      (k2 (k2* std))
				      (k (k* std))
				      (if1 (if1* std))
				      (if2 (if2* std))
				      (u (u* std))
				      (ku (ku* std))
				      (if1 (if1* std))
				      (if2 (if2* std))

				      (x1 (0 nil))       ;variables
				      (x2 (0 nil))
				      (nf1 ((0 inf) nil))
				      (nf2 ((0 inf) nil))
				      (nfy (nil inc)))))) ;admissible choices:inc,std ,dec.
    ;(special *perform-acc-analysis*)  ;commented out DJC
    (qsim init)
    (qsim-display init
		  :reference-states `((normal ,normal)))
    ))

