;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package 'QSIM)


; A bunch of useful and interesting structures to explore.

(defparameter Demos nil)				; General demonstrations
(defparameter Tanks nil)				; Tank problems
(defparameter Medical nil)				; Medical Physiology structures
(defparameter Controllers nil)				; Controller examples
(defparameter Envisionment nil)				; Envisionment demos


;*********************************************************************************
;  Create your own file of demos, with your own catalog name.
;  You can call (Q FOO) for any variable that contains entries of the
;  right structure.  Do NOT modify this file.
;*********************************************************************************

(add-to-catalog 'Demos
  '(gravity					; Name of the example
     ("ball")					; File name in which this example is stored 
     nil					; Form to Evaluate
						; (initialization-name file-to-load form-to-evaluate)
     ((throw-ball nil (throw-upward))
      (drop-ball  nil (drop-thing))
      (throw-w-resistance nil (throw-upward-r))
      (drop-w-resistance  nil (drop-thing-r))
      )))

(add-to-catalog 'Demos
  '(bathtub
     ("bathtub")
     nil
     ((fill-from-empty nil (fill-a-bathtub))
	 (increase-flow nil (increase-flow))
	 (decrease-flow nil (decrease-flow))
	 (underspecified-state nil (fill-underspecified-bathtub))
	 (totally-unspecified nil (totally-underspecified-bathtub))
	 )))

(add-to-catalog 'Demos
  '(U-tube
     ("u-tube")
     nil
     ((one-side-full nil (simple-U-tube-figure))
      (Q2-ranges nil (U-tube-w-ranges))
	 )))

(add-to-catalog 'Demos
  '(double-heat-flow
     ("double-heat-flow")
     nil
     ((temp-unspecified nil (HF-unknown-temp))
      (temp-between-limits nil (HF-intermediate-temp))
      (temp-known nil (HF-airtemp))
      )))

(add-to-catalog 'Demos
  '(springs
     ("springs")
     nil
     ((simple-spring nil (push-simple-spring))
      (spring-w-energy-conservation nil (push-spring-w-energy-conservation))
      (spring-w-friction nil (push-spring-w-friction))
      )))

(add-to-catalog 'Demos
  '(bouncing-ball
     ("bouncing-ball")
     nil
     ((gravity-spring-model nil (throw-bouncing-ball))
      (gravity-reflection-model nil (throw-simple-bouncing-ball))
      )))

(add-to-catalog 'Demos
  '(home-thermostat
     ("home-thermostat")
     nil
     ((on-off-controller nil (low-outside-temperature))
      (proportional-controller nil (low-temperature-prop))
      )))

(add-to-catalog 'Demos
  '(slider-crank
     ("slider-crank")
     nil
     ((rotate-crank nil (rotate-crank))
      )))

(add-to-catalog 'Demos
  '(two-fuses
     ("two-fuses")
     nil
     ((hierarchical-qspace nil (test-fuses))
      (ordinary-qspace nil (test-fuses2))
      )))
						
(add-to-catalog 'Demos
  '(population-model
     ("population")
     nil
     ((famine-then-recovery nil (population-model))
      )))

(add-to-catalog 'Demos
  '(chemical-reaction
     ("reaction")
     nil
     ((fixed-resources  nil  (fixed-resources))
      (inflow-cutoff    nil  (run-reaction))
      )))

(add-to-catalog 'Demos
  '(toaster
     ("toaster")
     nil
     ((push-cook-pop-fly nil  (push-down-toaster))
      (toast-may-burn    nil  (push-down-toaster-w-burn))
      )))

(add-to-catalog 'Demos
  '(rocket
     ("rocket")
     nil
     ((fire-rocket nil (fire-rocket))
      )))

(add-to-catalog 'Demos
  '(Q2-bathtub
     ("bathtub-w-ranges")
     nil
     ((fill-tub nil (q2-bathtub))
      )))


; The one-tank and two-tank problems.

(add-to-catalog 'Tanks
  '(bathtub
     ("bathtub")
     nil
     ((fill-from-empty nil (fill-a-bathtub))
      )))

(add-to-catalog 'Tanks
  '(cascaded-tanks
     ("cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-cascade-from-empty))
      (increase-inflow-rate nil (increase-cascade-inflow-rate))
      )))


(add-to-catalog 'Tanks
  '(cascaded-tanks-ign-test
     ("cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-cascade-from-empty-ign))
      (increase-inflow-rate nil (increase-cascade-inflow-rate-ign))
      )))

(add-to-catalog 'Tanks
  '(cascaded-tanks-nnl-test
     ("cascaded-tanks")
     nil
     ((fill-from-empty nil (fill-cascade-from-empty-nnl))
      (increase-inflow-rate nil (increase-cascade-inflow-rate-nnl))
      )))

(add-to-catalog 'Tanks
  '(two-tanks
     ("two-tanks")
     nil
     ((fill-from-empty nil (fill-two-tanks-from-empty))
      (increase-inflow-rate nil (increase-two-tanks-inflow-rate))
      )))


(add-to-catalog 'Tanks
  '(two-tanks-ign-test
     ("two-tanks")
     nil
     ((fill-from-empty nil (fill-two-tanks-from-empty-ign-NFB))
      (increase-inflow-rate nil (increase-two-tanks-inflow-rate-ign-NFB))
      )))

(setq Debug (union Demos Tanks :test #'equal))			;for compatibility


; The Medical Physiology examples.

(add-to-catalog 'Medical
  '(water-balance
     ("qwater-balance")
     nil
     ((high-water-intake nil (high-water-intake))
      (low-water-intake nil (low-intake))
      (high-water-volume nil (high-volume))
      )))

(add-to-catalog 'Medical
  '(siadh-water-balance
     ("qwater-balance")
     nil
     ((siadh-normal-intake nil (siadh-normal-intake))
      (siadh-therapy nil (siadh-therapy))
      (abstraction-learning nil (siadh-therapy-learn))
      )))

(add-to-catalog 'Medical
  '(sodium-balance
     ("qsodium-balance")
     nil
     ((high-salt-intake nil (high-salt-intake))
      (high-initial-salt-level nil (high-initial-salt-level))
      )))

(add-to-catalog 'Medical
  '(Starling
     ("starling")
     nil
     ((low-plasma-protein nil (low-plasma-protein))
      )))

(add-to-catalog 'Medical
  '(heart-regulation
     ("heart-regulation")
     nil
     ((beta-blocker nil (beta-blocker))
      (beta-stimulation nil (beta-stimulation))
      (low-blood-volume nil (low-blood-volume))
      (high-blood-volume nil (high-blood-volume))
      )))

;;;-----------------------------------------------------------------------------
;;; Catalogs for controllers
;;;-----------------------------------------------------------------------------

(add-to-catalog 'Controllers
  '(|Brief description| 
    ("controllers")
     nil
     ((|In this catalog...| nil (describe-controllers)))))

(add-to-catalog 'Controllers
  '(|Simple tank| 
    ("controllers")
     nil
     ((|Fill from empty| nil (fill-tank))
      (|Same, with q2| nil (q2-fill)))))

(add-to-catalog 'Controllers
  '(|On-Off controller|
    ("controllers")
     nil
     ((|Fill from empty| nil (on-off-control))
      (|Same, with q2| nil (q2-on-off-control)))))

(add-to-catalog 'Controllers
  '( |Proportional controller|
    ("controllers")
     nil
     ((|Reaction to a step increase of inflow, with comparative analysis of the gain value | nil (pc))
      (|Same, with q2| nil (q2-pc)))))

(add-to-catalog 'Controllers
  '(|Proportional-integral controller|
    ("controllers")
     nil
     ((|Reaction to a step increase of inflow, ignoring qdirs of F, F2 and V | nil (pic-ign-qdir))
      (|Same, with ACC instead| nil (pic-acc)))))


;;;-----------------------------------------------------------------------------
;;; Catalog for envisionment examples
;;;-----------------------------------------------------------------------------

(add-to-catalog 'Envisionment
  '(| Springs | 
     ("env-springs")
     nil
     ((|Drop the block, no friction| nil (ss1))
      (|Same, with an initial landmark| nil (ss2))
      (|Drop the block, with friction| nil (sf1))
      (|Same, with an initial landmark | nil (sf2))
      (|With curvature constraints| nil (sf3))
      )))

(add-to-catalog 'Envisionment
  '(| Three reactions in series A->B->C->D | 
     ("env-three-reactions")
     nil
     ((|Brief description| nil (batch-a->b->c->d-text))
      (|Envision from initial concentration [Ca] = C0| nil (abcd1))
      (|Same, with analytic functions only| nil (abcd2))
      (|Same, with curvatures constraints| nil (abcd3))
      (|Same, with both| nil (abcd4)))))

(add-to-catalog 'Envisionment
  '(| Four reactions in series A->B->C->D->E | 
     ("env-four-reactions")
     nil
     ((|Brief description| nil (batch-a->b->c->d->e-text))
      (|Envision from initial concentration [Ca] = C0| nil (abcde1))
      (|Same, with analytic functions only| nil (abcde2))
      (|Same, with curvatures constraints| nil (abcde3))
      (|Same, with both| nil (abcde4)))))
