/*
 *  "mult" tests all combinations of the possible values for its three
 *  arguments and forms 3-tuples from those that pass the consistency
 *  tests for MULT.  Note that if any of the pvals of any argument are
 *  not used in any tuple, then the pval is marked "bad" so that it 
 *  will not be used in any tuples of other constraints remaining to be
 *  processed.
 */


#include  <stdio.h>
#include  "defs.h"
#define   EXTERN  extern
#include  "global.h"
extern int  addqdir[3][3];


/*
 *  The 'checkinf' macro returns GT if the value is 'minf' or 'inf',
 *  LT if the value is '0', and EQ otherwise.
 */
#define  checkinf(PVALP,QSPACEP)  \
  ( (PVALP->qmagx == QSPACEP->zerox) ? LT : \
    ((PVALP->qmagx == 0) ? (QSPACEP->minf ? GT : EQ) : \
    ((PVALP->qmagx == ((QSPACEP->nlmarks - 1) << 1)) ? \
     (QSPACEP->inf ? GT : EQ) : EQ)) )


/*  multrel[rx][ry] contains the allowable relations of z to 0 in z = x * y,
 *  where rx and ry are th relations of x and y to 0, repsectively.
 *  This array is ordered on the assumption that GT=0, EQ=1, LT=2.
 */
static int  multrel[3][3] =
	{   {	GT,  EQ,  LT  },
	    {	EQ,  EQ,  EQ  },
	    {	LT,  EQ,  GT  }
	};

struct dir
{
	int   dir[3][3];
};


/*
 *  The following arrays contain the legal directions-of-change for the
 *  various combinations of signs of f, g and h in MULT(f,g,h). 
 *  The arrays are ordered on the assumption that INC=0, EQ=1, DEC=2.
 *  The array names follow a pattern -- they all begin "fgh", and the
 *  next 3 characters indicate the relations of f, g and h to 0,
 *  where 'p' = +, 'z' = 0, and 'm' = -.
 */
static struct dir  fghppp =
	{{  {	INC,  INC,  ANY   },
	    {	INC,  STD,  DEC   },
	    {	ANY,  DEC,  DEC   }   }};

static struct dir  fghpzz =
	{{  {	INC,  STD,  DEC   },
	    {	INC,  STD,  DEC   },
	    {	INC,  STD,  DEC   }   }};

static struct dir  fghpmm =
	{{  {	ANY,  DEC,  DEC   },
	    {	INC,  STD,  DEC   },
	    {	INC,  INC,  ANY   }   }};

static struct dir  fghzpz =
	{{  {	INC,  INC,  INC   },
	    {	STD,  STD,  STD   },
	    {	DEC,  DEC,  DEC   }   }};

static struct dir  fghzzz =
	{{  {	STD,  STD,  STD   },
	    {	STD,  STD,  STD   },
	    {	STD,  STD,  STD   }   }};

static struct dir  fghzmz =
	{{  {	DEC,  DEC,  DEC   },
	    {	STD,  STD,  STD   },
	    {	INC,  INC,  INC   }   }};

static struct dir  fghmpm =
	{{  {	ANY,  INC,  INC   },
	    {	DEC,  STD,  INC   },
	    {	DEC,  DEC,  ANY   }   }};

static struct dir  fghmzz =
	{{  {	DEC,  STD,  INC   },
	    {	DEC,  STD,  INC   },
	    {	DEC,  STD,  INC   }   }};

static struct dir  fghmmp =
	{{  {	DEC,  DEC,  ANY   },
	    {	DEC,  STD,  INC   },
	    {	ANY,  INC,  INC   }   }};


/*
 *  multdir[xsign][ysign][zsign] contains a pointer to the appropriate table
 *  of combinations-of-directions-of-change.  xsign, ysign, and zsign are
 *  the relations of x, y and z to 0, respectively.  This array is ordered
 *  on the assumption that GT=0, EQ=1, LT=2.
 */
static struct dir  *multdir[3][3][3] =
	{   {	{   &fghppp,	0,		0	},
		{   0,		&fghpzz,	0	},
		{   0,		0,		&fghpmm	}   },
	    {	{   0,		&fghzpz,	0	},
		{   0,		&fghzzz,	0	},
		{   0,		&fghzmz,	0	}   },
	    {	{   0,		0,		&fghmpm	},
		{   0,		&fghmzz,	0	},
		{   &fghmmp,	0,		0	}   }
	};


mult( conp )
struct constraint *conp;
{
    register struct pval  *val1p, *val2p, *val3p;
    register struct corr  *corrp;

    struct param  *p1p, *p2p, *p3p;
    struct qspace *qsp1p, *qsp2p, *qsp3p;
    struct pval   *val1stop, *val2stop, *val3stop;
    struct corr   *corrstop;
    struct dir    *multp;
    int   c1, c2, c3, c12, d1, d2, d3, dir, rel;
    Boolean  foundtuple;


#ifdef TRACE
    if (trace & TR_TUPLES)
	prcon( conp );		/* print constraint and argument names */
#endif


    foundtuple = FALSE;		/* no tuples found yet */
    p1p = conp->paramp[0];	/* pointer to first parameter  */
    p2p = conp->paramp[1];	/* pointer to second parameter */
    p3p = conp->paramp[2];	/* pointer to third parameter */
    qsp1p = p1p->qspacep;
    qsp2p = p2p->qspacep;
    qsp3p = p3p->qspacep;
    conp->tuplep = tup;		/* pointer to next avail tuple space */
    conp->ntuples = 0;		/* number of tuples found so far */

    /*  Initialize pointers.  */
    val1p    = p1p->pvalp;
    val1stop = val1p + p1p->npvals;
    val2p    = p2p->pvalp;
    val2stop = val2p + p2p->npvals;
    val3p    = p3p->pvalp;
    val3stop = val3p + p3p->npvals;

    /*  Loop over all possible values for first argument  */
    for (val1p = p1p->pvalp;  val1p < val1stop;  val1p++)
    {
#ifdef XTRACE
 printf("val1 = (%s %s)  %s\n",
   qmagtostring(val1p->qmagx,p1p->qspacep),
   qdirtostring(val1p->qdir),
   val1p->bad ? "bad" : "");
#endif
	/*  Ignore values known to be bad for any other constraints */
	if (val1p->bad)  continue;

	c1 = compare( val1p->qmagx, qsp1p->zerox );

	/*  Loop over all possible values for second argument  */
	for (val2p = p2p->pvalp;  val2p < val2stop;  val2p++)
	{
#ifdef XTRACE
 printf("      val2 = (%s %s)  %s\n",
   qmagtostring(val2p->qmagx,p2p->qspacep),
   qdirtostring(val2p->qdir),
   val2p->bad ? "bad" : "");
#endif
	    /*  Ignore values known to be bad for any other constraints */
	    if (val2p->bad)  continue;

	    c2 = compare( val2p->qmagx, qsp2p->zerox );
	    c12 = multrel[c1][c2];

	    /*  Loop over all possible values for third argument  */
	    for (val3p = p3p->pvalp;  val3p < val3stop;  val3p++)
	    {
#ifdef XTRACE
 printf("            val2 = (%s %s)  %s\n",
   qmagtostring(val3p->qmagx,p3p->qspacep),
   qdirtostring(val3p->qdir),
   val3p->bad ? "bad" : "");
#endif
		/*  Ignore values known to be bad for any other constraints */
		if (val3p->bad)  continue;

#ifdef TRACE
		if (trace & TR_TUPLES)
		    prcandidate( conp, val1p, val2p, val3p);
#endif
		/*  Check for legal combinations of relations to zero  */
		c3 = compare( val3p->qmagx, qsp3p->zerox );
		if (c3 != c12)
		{
#ifdef TRACE
		    if (trace & TR_TUPLES)
		    {
			puts("  illegal relations to zero");
			printf("%d:%d, %d:%d, %d:%d\n",
				val1p->qmagx, qsp1p->zerox,
				val2p->qmagx, qsp2p->zerox,
				val3p->qmagx, qsp3p->zerox);
			printf("%d %d %d %d\n", c1, c2, c3, c12);
		    }
#endif
		    continue;
		}

		/*  Qualitative directions must agree.  */
		multp = multdir[c1][c2][c3];
		if (((dir = multp->dir[val1p->qdir][val2p->qdir]) !=
			val3p->qdir) && (dir != ANY))
		{
#ifdef TRACE
		    if (trace & TR_TUPLES)
			puts("  qdirs disagree");
#endif
		    continue;
		}

		/*  Loop over all corresponding values for this constraint */
		corrp = conp->corrp;
		corrstop = corrp + conp->ncorrs;
		for ( ;  corrp < corrstop;  corrp++)
		{
		    d1 = compare(val1p->qmagx, corrp->cvalx[0]);
		    d2 = compare(val2p->qmagx, corrp->cvalx[1]);
		    d3 = compare(val3p->qmagx, corrp->cvalx[2]);
		    if (((rel = multp->dir[d1][d2]) != d3) && (rel != ANY))
		    {
#ifdef TRACE
			if (trace & TR_TUPLES)
			    puts("  corrs disagree");
#endif
			goto nextval3;
		    }
		}

		/*  Check infinite values  */
		d1 = checkinf( val1p, p1p->qspacep);
		d2 = checkinf( val2p, p2p->qspacep);
		d3 = checkinf( val3p, p3p->qspacep);
		if (((rel = addqdir[d1][d2]) != d3) && (rel != ANY))
		{
#ifdef TRACE
		    if (trace & TR_TUPLES)
			puts("  fails infinity check");
#endif
			goto nextval3;
		}

#ifdef TRACE
		if (trace & TR_TUPLES)
		    puts("  OK");
#endif
		/*  Form a new tuple  */
		val1p->used = val2p->used = val3p->used = foundtuple = TRUE;
		conp->ntuples++;
		tup->bad = FALSE;
		    tup->pvalp[0] = val1p;
		    tup->pvalp[1] = val2p;
		(tup++)->pvalp[2] = val3p;

nextval3:	continue;
	    }
	}

	/*  If a value is not used at all by this constraint, mark it 'bad'.
	 *  Otherwise, increment the count of the number of constraints
	 *  accepting this pval (used later in Waltz filtering).
	 */
	if (val1p->used)
	{
	    val1p->used = FALSE;
	    val1p->ncons++;
	}
	else
	    val1p->bad = TRUE;
    }

    /*  Loop over 2nd and 3rd arguments and mark as 'bad' any unused values.
     *  For the used values, increment the count of the number of constraints
     *  accepting this pval.  This is the same thing as done above for the
     *  first argument, but it had to wait until now after all combinations
     *  involving the first argument had been tested.
     */
    for (val2p = p2p->pvalp;  val2p < val2stop; )
	if (val2p->used)
	{
	    val2p->used = FALSE;
	    (val2p++)->ncons++;
	}
	else
	    (val2p++)->bad = TRUE;

    for (val3p = p3p->pvalp;  val3p < val3stop; )
	if (val3p->used)
	{
	    val3p->used = FALSE;
	    (val3p++)->ncons++;
	}
	else
	    (val3p++)->bad = TRUE;

    return(foundtuple);
}
