/*
 *  "mminus" tests all combinations of the possible values for its two
 *  arguments and forms 2-tuples from those that pass the consistency
 *  tests for M+.  Note that if any of the pvals of either argument are
 *  not used in any tuple, then the pval is marked "bad" so that it will
 *  not be used in any tuples of other constraints remaining to be
 *  processed.
 *
 *  Implementation note:
 *	I have tried to make the loops very fast by trading a bit of
 *	setup time for faster iteration, and by using register variables.
 */


#include  <stdio.h>
#include  "defs.h"
#define   EXTERN  extern
#include  "global.h"


/*  Note: The ordering of this vector is dependent upon the associations
 *        INC=0, STD=1, DEC=2, and on the associations GT=INC, EQ=STD,
 *        and LT=DEC (as defined in defs.h).
 */
static int  reverse[3] = { DEC, STD, INC };


mminus( conp )
struct constraint *conp;
{
    register struct pval  *val1p, *val2p;
    register struct corr  *corrp;

    struct param  *p1p, *p2p;
    struct pval   *val1stop, *val2stop;
    struct corr   *corrstop;
    Boolean  foundtuple;

#ifdef TRACE
    if (trace & TR_TUPLES)
	prcon( conp );		/* print constraint and argument names */
#endif

    /*  Initialize pointers.  */
    foundtuple = FALSE;		/* no tuples found yet */
    p1p = conp->paramp[0];	/* pointer to first parameter  */
    p2p = conp->paramp[1];	/* pointer to second parameter */
    conp->tuplep = tup;		/* pointer to next avail tuple space */
    conp->ntuples = 0;		/* number of tuples found so far */
    val1p    = p1p->pvalp;
    val1stop = val1p + p1p->npvals;
    val2p    = p2p->pvalp;
    val2stop = val2p + p2p->npvals;

    /*  Loop over all possible values for first argument  */
    for (val1p = p1p->pvalp;  val1p < val1stop;  val1p++)
    {
	/*  Ignore values known to be bad for any other constraints */
	if (val1p->bad)  continue;

	/*  Loop over all possible values for second argument  */
	for (val2p = p2p->pvalp;  val2p < val2stop;  val2p++)
	{
	    /*  Ignore values known to be bad for any other constraints */
	    if (val2p->bad)  continue;

	    /*  Qualitative directions must agree.  */
	    if (val1p->qdir != reverse[val2p->qdir])  continue;

	    /*  Loop over all corresponding values for this constraint */
	    corrp = conp->corrp;
	    corrstop = corrp + conp->ncorrs;
	    for ( ;  corrp < corrstop;  corrp++)
	    {
/*
 printf("correspondence test: (%d :: %d) =?= (%d :: %d)\n",
	val1p->qmagx, corrp->cvalx[0], val2p->qmagx, corrp->cvalx[1]);
*/

		if (compare(val1p->qmagx, corrp->cvalx[0]) !=
		    reverse[compare(val2p->qmagx, corrp->cvalx[1])])
			goto nextval2;
	    }

	    /*  Form a new tuple  */
	    val1p->used = val2p->used = foundtuple = TRUE;
	    conp->ntuples++;
	    tup->bad = FALSE;
	        tup->pvalp[0] = val1p;
	    (tup++)->pvalp[1] = val2p;

#ifdef TRACE
	    if (trace & TR_TUPLES)
	    {	prtuple( conp, tup-1 );  putchar('\n');  }
#endif

nextval2:   continue;
	}

	/*  If a value is not used at all by this constraint, mark it 'bad'.
	 *  Otherwise, increment the count of the number of constraints
	 *  accepting this pval (used later in Waltz filtering).
	 */
	if (val1p->used)
	{
	    val1p->used = FALSE;
	    val1p->ncons++;
	}
	else
	    val1p->bad = TRUE;
    }

    /*  Loop over second argument and mark as 'bad' any unused values.
     *  For the used values, increment the count of the number of constraints
     *  accepting this pval.  This is the same thing as done above for the
     *  first argument, but it had to wait until now after all combinations
     *  involving the first argument had been tested.
     */
    for (val2p = p2p->pvalp;  val2p < val2stop; )
	if (val2p->used)
	{
	    val2p->used = FALSE;
	    (val2p++)->ncons++;
	}
	else
	    (val2p++)->bad = TRUE;

    return(foundtuple);
}
