/*=============================================================================
 *  CQ -- Global variables.
 *
 *  This file contains most global variables.  The word EXTERN is #define'ed
 *  in the #include'ing file to be either 'extern' or null, as needed.
 *
 *  The following integers and pointers are deliberately placed at the
 *  beginning of this file and not intermingled with the arrays that follow.
 *  The reason for this is that some of the arrays can be overrun slightly
 *  before being detected.  The overrun detection depends on the integrity
 *  of the various "max" pointers (e.g., qvpmax).  If any of these pointers
 *  got "stepped on" during an overrun then bizarre bugs could occur.
 *========================================================================== */


EXTERN int                nparams;	   /* number of parameters */
EXTERN int                nconstraints;	   /* number of constraints */
EXTERN int                nstates;	   /* number of states */
EXTERN int                nsymbols;	   /* number of symbols */
EXTERN int		  curtime;	   /* current simulation time */
EXTERN int		  trace;	   /* trace flag (bit flags) */
EXTERN Boolean		  modified;	   /* TRUE if make-modified-state */


EXTERN FILE		 *mstream;	/* model input stream */

EXTERN char              *symp;		/* next avail position in 'symspace' */
EXTERN char              *sympmax;

EXTERN struct qval       *qvp;
EXTERN struct qval       *qvpmax;

EXTERN struct pval       *pvp;
EXTERN struct pval       *pvpmax;
EXTERN struct pval       *pvphigh;

EXTERN struct qspace	 *qsp;
EXTERN struct qspace	 *qspmax;

EXTERN struct corr	 *crp;
EXTERN struct corr	 *crpmax;

EXTERN struct scorr	 *scrp;
EXTERN struct scorr	 *scrpmax;

EXTERN struct tuple	 *tup;
EXTERN struct tuple	 *tupmax;
EXTERN struct tuple	 *tuphigh;

EXTERN struct state	 *stp;
EXTERN struct state	 *stpmax;
EXTERN struct state	 *curstatep;

EXTERN short		 *lmp;
EXTERN short		 *lmpmax;


/*
 *  Arrays (size fixed at compile time).
 */

EXTERN char               symspace[MAXSYMCHARS];

EXTERN char              *symbol[MAXSYMBOLS];

EXTERN struct qval        qval[MAXQVALS];

EXTERN struct pval        pval[MAXPVALS];

EXTERN struct qspace	  qspace[MAXQSPACES];

EXTERN struct corr	  corr[MAXCORR];

EXTERN struct scorr	  scorr[MAXSCORR];

EXTERN struct tuple	  tuple[MAXTUPLES];

EXTERN struct state	  state[MAXSTATES];

EXTERN short		  lmark[MAXLMARKS];

EXTERN struct param       param[MAXPARAMS];

EXTERN struct constraint  constraint[MAXCONSTRAINTS];
