/*
 *  "add" tests all combinations of the possible values for its three
 *  arguments and forms 3-tuples from those that pass the consistency
 *  tests for ADD.  Note that if any of the pvals of any argument are
 *  not used in any tuple, then the pval is marked "bad" so that it 
 *  will not be used in any tuples of other constraints remaining to be
 *  processed.
 *
 *  Implementation note:
 *	I have tried to make the loops very fast by trading a bit of
 *	setup time for faster iteration, and by using register variables.
 */


#include  <stdio.h>
#include  "defs.h"
#define   EXTERN  extern
#include  "global.h"

/*
 *  The 'checkinf' macro returns LT if the value is 'minf', GT if the
 *  value is 'inf', and EQ otherwise.
 */
#define  checkinf(PVALP,QSPACEP)  \
 ( (PVALP->qmagx == 0) ? (QSPACEP->minf ? LT : EQ) : \
 ((PVALP->qmagx == ((QSPACEP->nlmarks - 1) << 1)) ? \
  (QSPACEP->inf ? GT : EQ) : EQ) )


/*  addqdir[x][y] contains the allowable qdirs for z in z = x + y.
 *  This array is ordered on the assumption that INC=0, STD=1, DEC=2.
 *  This array also serves double-duty as defining the allowable relations
 *  of x, y, and z to corresponding values.  For this situation, we rely
 *  on the fact that GT=INC, EQ=STD, and LT=DEC.
 *
 *  This array is an external global so that it can be used by 'mult'
 *  in the multiplier's inifinite value check.
 */
int  addqdir[3][3] =
	{   {	INC,  INC,  ANY   },
	    {	INC,  STD,  DEC   },
	    {	ANY,  DEC,  DEC   }
	};



add( conp )
struct constraint *conp;
{
    register struct pval  *val1p, *val2p, *val3p;
    register struct corr  *corrp;

    struct param  *p1p, *p2p, *p3p;
    struct pval   *val1stop, *val2stop, *val3stop;
    struct corr   *corrstop;
    int   c1, c2, c3, dir, rel;
    Boolean  foundtuple;


#ifdef TRACE
    if (trace & TR_TUPLES)
	prcon( conp );		/* print constraint and argument names */
#endif


    foundtuple = FALSE;		/* no tuples found yet */
    p1p = conp->paramp[0];	/* pointer to first parameter  */
    p2p = conp->paramp[1];	/* pointer to second parameter */
    p3p = conp->paramp[2];	/* pointer to third parameter */
    conp->tuplep = tup;		/* pointer to next avail tuple space */
    conp->ntuples = 0;		/* number of tuples found so far */

    /*  Initialize pointers and reset all "used" flags */
    val1p    = p1p->pvalp;
    val1stop = val1p + p1p->npvals;
    val2p    = p2p->pvalp;
    val2stop = val2p + p2p->npvals;
    val3p    = p3p->pvalp;
    val3stop = val3p + p3p->npvals;

    /*  Loop over all possible values for first argument  */
    for (val1p = p1p->pvalp;  val1p < val1stop;  val1p++)
    {
	/*  Ignore values known to be bad for any other constraints */
	if (val1p->bad)  continue;

	/*  Loop over all possible values for second argument  */
	for (val2p = p2p->pvalp;  val2p < val2stop;  val2p++)
	{
	    /*  Ignore values known to be bad for any other constraints */
	    if (val2p->bad)  continue;

	    dir = addqdir[val1p->qdir][val2p->qdir];

	    /*  Loop over all possible values for third argument  */
	    for (val3p = p3p->pvalp;  val3p < val3stop;  val3p++)
	    {
		/*  Ignore values known to be bad for any other constraints */
		if (val3p->bad)  continue;
#ifdef TRACE
		if (trace & TR_TUPLES)
		    prcandidate( conp, val1p, val2p, val3p );
#endif

		/*  Qualitative directions must agree.  */
		if ((val3p->qdir != dir) && (dir != ANY))
		{
#ifdef TRACE
		    if (trace & TR_TUPLES)
			puts("  qdirs don't agree");
#endif
		    continue;
		}

		/*  Loop over all corresponding values for this constraint */
		corrp = conp->corrp;
		corrstop = corrp + conp->ncorrs;
		for ( ;  corrp < corrstop;  corrp++)
		{
		    c1 = compare(val1p->qmagx, corrp->cvalx[0]);
		    c2 = compare(val2p->qmagx, corrp->cvalx[1]);
		    c3 = compare(val3p->qmagx, corrp->cvalx[2]);
		    if (((rel = addqdir[c1][c2]) != c3) && (rel != ANY))
		    {
#ifdef TRACE
			if (trace & TR_TUPLES)
			    puts("  corrs don't agree");
#endif
			goto nextval3;
		    }
		}

		/*  Check infinite values  */
		c1 = checkinf( val1p, p1p->qspacep);
		c2 = checkinf( val2p, p2p->qspacep);
		c3 = checkinf( val3p, p3p->qspacep);
		if (((rel = addqdir[c1][c2]) != c3) && (rel != ANY))
		{
#ifdef TRACE
		    if (trace & TR_TUPLES)
			puts("  fails infinite check");
#endif
		    goto nextval3;
		}

#ifdef TRACE
		if (trace & TR_TUPLES)
		    puts("  OK");
#endif

		/*  Form a new tuple  */
		val1p->used = val2p->used = val3p->used = foundtuple = TRUE;
		conp->ntuples++;
		tup->bad = FALSE;
		    tup->pvalp[0] = val1p;
		    tup->pvalp[1] = val2p;
		(tup++)->pvalp[2] = val3p;

nextval3:	continue;
	    }
	}

	/*  If a value is not used at all by this constraint, mark it 'bad'.
	 *  Otherwise, increment the count of the number of constraints
	 *  accepting this pval (used later in Waltz filtering).
	 */
	if (val1p->used)
	{
	    val1p->used = FALSE;
	    val1p->ncons++;
	}
	else
	    val1p->bad = TRUE;
    }

    /*  Loop over 2nd and 3rd arguments and mark as 'bad' any unused values.
     *  For the used values, increment the count of the number of constraints
     *  accepting this pval.  This is the same thing as done above for the
     *  first argument, but it had to wait until now after all combinations
     *  involving the first argument had been tested.
     */
    for (val2p = p2p->pvalp;  val2p < val2stop; )
	if (val2p->used)
	{
	    val2p->used = FALSE;
	    (val2p++)->ncons++;
	}
	else
	    (val2p++)->bad = TRUE;

    for (val3p = p3p->pvalp;  val3p < val3stop; )
	if (val3p->used)
	{
	    val3p->used = FALSE;
	    (val3p++)->ncons++;
	}
	else
	    (val3p++)->bad = TRUE;

    return(foundtuple);
}
