;;;  THis file contains code to install the program on the MAC

(in-package 'user)

(format t "~%This file will load the Common Lisp Defsystem and will compile ~
           ~%    the QSIM and POS files.  Prior to loading this program, the ~
           ~%    following special variables must be modified to reflect the ~
           ~%    pathnames at your cite: ~
         ~%~%            *lisp-root* ~
           ~%            *qsim-root*  ~
         ~%~%    These variables are defined in the following files:  ~
         ~%~%             compile-qsim-mac.lisp  ~
           ~%             start-nq.lisp")

(when (not (y-or-n-p "~%Have these files been modified?"))
  (format t "~%~%Installation aborted.  Modify these files and try again.")
  (abort))


(defparameter *lisp-root* (format nil "hd:ccl"))
(defparameter *qsim-root* (format nil "~a:nsim" *lisp-root*))
(format t "~%Loading QuickDraw Library.")
(load (format nil "~a:Library:QuickDraw.lisp" *lisp-root*))
(format t "~%Loading the Common Lisp Defsystem")
(load (format nil "~a:c-lisp:new-defsystem.lisp" *qsim-root*))

(setf mk::*central-registry* (format nil "~a:sys-site:" *qsim-root*))

(defun compile-qsim (&key (verbose nil)
			  (force :new-source-and-dependents))
  (let ((*warn-if-redefine-kernel* nil))
    (cond ((equal force :all)
	   (format t "~%Compiling all of the QSIM files "))
	  ((equal force :new-source-and-dependents)
	   (format t "~%Compiling modified QSIM files ")))
    (operate-on-system 'nq 'compile :verbose verbose :force :force)))



(compile-qsim :force :all :verbose t)

