#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

#include <stdio.h>

#include "xbatch.h"



#define BITMAPDEPTH	1
#define SMALL		1
#define OK		0

#define YOFFSET		50




Display			*display;
int			screen;
Window			win;
DrawLisType		*drawLis, *drawLisTail 	= NULL;
GC			gc;
/*	Font			fontID;	*/
XFontStruct		*fontinfo;
int			eraseFile;





void main(argc, argv)
int			argc;
char			**argv;
{
	unsigned int		width, height, x = 10, y = 10;		/* window size and position */
	unsigned int		border_width = 4;			/* four pixels */
	unsigned int		display_width, display_height;
	char			*windowName;
	char			*fileName;
	XSizeHints		size_hints;
	XEvent			report;
	char			*displayName;
	int			window_size = 0;			/* OK, or too SMALL to display contents */
	int			root_x, root_y;
	int			win_x, win_y;
	Window			root, child;
	unsigned int		keys_buttons;


	/* We must parse the command line */

	ParseCommandLine(argc, argv, &fileName, &displayName, &windowName);


	/* connect to X server */

	if ((display = XOpenDisplay(displayName)) == NULL) {
		(void) fprintf(stderr, "xbatch: cannot connect to X server %s\n", XDisplayName(displayName));
		exit(-1);
	}

	/* get screen size from display structure macro */

	screen		= DefaultScreen(display);
	display_width	= DisplayWidth(display, screen);
	display_height	= DisplayHeight(display, screen);


	LoadFont("9x15");

	ParseDataFile(fileName);

	if (eraseFile == TRUE)
		unlink(fileName);

	GetWindowSize(&width, &height, display_width, display_height);


	/* create opaque window */

	win = XCreateSimpleWindow(display, RootWindow(display,screen), x, y, width, height, border_width, BlackPixel(display,
	                          screen), WhitePixel(display,screen));




	/* Set resize hints */

	size_hints.flags	= PPosition | PSize | PMinSize;
	size_hints.x		= x;
	size_hints.y		= y;
	size_hints.width	= width;
	size_hints.height	= height;
	size_hints.min_width	= 300;
	size_hints.min_height	= 200;

	/* set Properties for window manager (always before mapping) */

	XSetStandardProperties(display, win, windowName, windowName, None,
	                       argv, argc, &size_hints);

	/* Select event types wanted */

	XSelectInput(display, win, ExposureMask | KeyPressMask | ButtonPressMask | StructureNotifyMask);


	/* create GC for text and drawing */

	getGC(win);


	/* Display window */

	XMapWindow(display, win);
	

	/* get events, use first to display text and graphics */

	while (1)  {
		XNextEvent(display, &report);
		switch  (report.type) {
		case MotionNotify:
			break;
		case Expose:
			DrawCloseBox();
			TraverseLis();
			break;
		case ConfigureNotify:
			/* window has been resized, change width and
			 * height to send to place_text and place_graphics
			 * in next Expose */

			width		= report.xconfigure.width;
			height		= report.xconfigure.height;

			if ((width < size_hints.min_width) || (height < size_hints.min_height))
				window_size = SMALL;
			else
				window_size = OK;
			break;
		case ButtonPress:
			if (InCloseBox(report.xbutton.x, report.xbutton.y)) {
				HighlightCloseBox();
				DrawCloseBox();
				XFreeGC(display, gc);
				XCloseDisplay(display);
				FreeDrawLis();
				exit(1);
			}
		default:
			/* all events selected by StructureNotifyMask
			 * except ConfigureNotify are thrown away here,
			 * since nothing is done with them */
			break;
		} /* end switch */
	} /* end while */
}





getGC(win)
Window			win;
{
	unsigned long		valuemask	= 0; /* ignore XGCvalues and use defaults */
	XGCValues		values;
	unsigned int		line_width	= 6;
	int			line_style	= LineSolid;
	int			cap_style	= CapButt;
	int			join_style	= JoinMiter;



	/* Create default Graphics Context */
	gc = XCreateGC(display, win, valuemask, &values);

	/* specify black foreground since default may be white on white */
	XSetForeground(display, gc, BlackPixel(display,screen));

	/* set line attributes */
	XSetLineAttributes(display, gc, line_width, line_style, cap_style, join_style);
}





LoadFont(fontname)
char			*fontname;
{

	if ((fontinfo = (XFontStruct *) XLoadQueryFont(display,fontname)) == NULL)
	{
		(void) fprintf(stderr, "xbatch: cannot open font, defaulting to 9x15\n");

		if ((fontinfo = (XFontStruct *) XLoadQueryFont(display, "9x15")) == NULL) {
			(void) fprintf(stderr, "xbatch: Cannot open 9x15 font\n");
			exit(-1);
		}
	}
}




PrintUsage()
{
	printf("\n\nUsage : xbatch -[defhns]\n\n");
	printf("\td <displayname>\tSpecify the x server.\n");
	printf("\te\t\tErase input file after reading it.\n");
	printf("\tf <filename>\tName of input file.\n");
	printf("\th\t\tHELP!!!!!\n");
	printf("\tn <name>\tName of window.\n");
	printf("\ts\t\tPrint exact syntax of each command.\n\n");
}



PrintHelp()
{
	printf("\n\n\tXbatch is a simple batch file driven graphics\n");
	printf("command intperpeter.  All commands are specified in\n");
	printf("the file specified by the -f option.  Type xbatch -s\n");
	printf("for a complete listing of the xbatch command syntax.\n\n");
}


PrintSyntax()
{
	printf("\n\n");
	printf("drawline	upper left x, upper left y, lower right x, lower right y\n");
	printf("drawarc		upper left x, upper left y, arc width, arc height, angle 1, angle 2\n");
	printf("fillarc		upper left x, upper left y, arc width, arc height, angle 1, angle 2\n");
	printf("drawpoint	any x, any y\n");
	printf("drawrectangle	upper left x, upper left y, width, height\n");
	printf("fillrectangle	upper left x, upper left y, width, height\n");
	printf("setlinewidth	any integer\n");
	printf("setlinestyle	either Dashed or Solid\n");
	printf("drawlines	number of points, x,y,x1,y1,x2,y2... where each x,y pair is a point\n");
	printf("setdashes	number of dashes, 3 4 5...  where 3 dashes on, 4 dashes off 5 dashes on and repeat\n");
	printf("fillpolygon	number of points, points\n");
	printf("drawstring	x,y,string\n");
	printf("setfont		font in x-window format\n");
	printf("setcolor	color in text format [use xcolors to get list]\n");
	printf("\n\n");
}



ParseCommandLine(argc, argv, fileName, displayName, windowName)
int			argc;
char			**argv;
char			**fileName, **displayName, **windowName;
{
	int			i;


	*fileName	= NULL;
	*displayName	= NULL;
	*windowName	= NULL;
        eraseFile	= FALSE;


	*displayName = (char *) getenv("DISPLAY");

	for (i = 1; i < argc; i++) {
		if (strcmp(argv[i],"-h") == 0) {
			PrintHelp();
			exit(1);
		}
		if (strcmp(argv[i],"-s") == 0) {
			PrintSyntax();
			exit(1);
		}
		if (strcmp(argv[i],"-f") == 0) {
			*fileName = argv[i + 1];
		}
		if (strcmp(argv[i],"-d") == 0) {
			*displayName = argv[i + 1];
		}
		if (strcmp(argv[i],"-n") == 0) {
			*windowName = argv[i + 1];
		}
                if (strcmp(argv[i], "-e") == 0) {
			eraseFile = TRUE;
		}
	}
	if (*fileName == NULL) {
		PrintUsage();
		exit(1);
	}		
	if (*windowName == NULL) {
		*windowName = "xbatch";
	}
}



int max(x,y)
int			x;
int			y;
{
	if (x > y)
		return(x);
	return(y);
}



GetWindowSize(width, height, displayWidth, displayHeight)
unsigned int		*width;
unsigned int		*height;
unsigned int		displayWidth;
unsigned int		displayHeight;
{
	DrawLisType		*p;
	int			i;
	int			linewidth;



	*width		= 300;
	*height		= 200;
	linewidth	= 1;

	p = drawLis;
	while (p != NULL) {
		switch(p->info.command) {
			case DRAWLINE :
				if (max(p->info.x1, p->info.x2) > *width)
					*width = max(p->info.x1, p->info.x2);
				if (max(p->info.y1, p->info.y2) > *height)
					*height = max(p->info.y1, p->info.y2);
				break;
			case DRAWARC :
			case FILLARC :
				if ((p->info.x1 + p->info.width) > *width)
					*width = p->info.x1 + p->info.width;
				if ((p->info.y1 + p->info.height) > *height)
					*height = p->info.y1 + p->info.height;
				break;
			case DRAWPOINT :
				if (p->info.x1 > *width)
					*width = p->info.x1;
				if (p->info.y1 > *height)
					*height = p->info.y1;
				break;
			case DRAWRECTANGLE :
			case FILLRECTANGLE :
				if ((p->info.x1 + p->info.width) > *width)
					*width = p->info.x1 + p->info.width;
				if ((p->info.y1 + p->info.height) > *height)
					*height = p->info.y1 + p->info.height;
				break;
			case DRAWLINES :
			case FILLPOLYGON :
				for (i = 0; i < p->info.npts; i++) {
					if ((p->info.pts)[i].x > *width)
						*width = (p->info.pts)[i].x;
					if ((p->info.pts)[i].y > *height)
						*height = (p->info.pts)[i].y;
				}
				break;
			case DRAWSTRING :
				if ((p->info.x1 + p->info.width) > *width)
					*width = p->info.x1 + p->info.width;
				if (p->info.y1 > *height)
					*height = p->info.y1;
				break;
			case SETLINEWIDTH :
				if (p->info.width > linewidth)
					linewidth = p->info.width;
				break;
			default :
				break;
		}
		p = p->next;
	}
	*width	+= (linewidth + 20);
	*height	+= (linewidth + 20);

	if (*width > (displayWidth - 50))
		*width = displayWidth - 50;

	if (*height > (displayHeight - 50))
		*height = displayHeight - 50;
}



DrawCloseBox()
{
	XSetForeground(display, gc, BlackPixel(display,screen));
	XSetLineAttributes(display, gc, 3, LineSolid, CapButt, JoinBevel);

	XDrawRectangle(display, win, gc, 10, 10, 70, 30);

	LoadFont("9x15");
	XSetFont(display, gc, fontinfo->fid);

	XDrawString(display, win, gc, 20, 30, "Quit", 4);
	
}


int InCloseBox(x,y)
int		x,y;
{
	if ((x >= 10) && (x <= 80) && (y >= 10) && (y <= 40))
		return(1);
	return(0);
}



HighlightCloseBox()
{
	XSetForeground(display, gc, BlackPixel(display,screen));
	XFillRectangle(display, win, gc, 10, 10, 70, 30);
}
	

GetInfo(f)
FILE			*f;
{
	DrawLisType		*p;
	char			command[50];



	p = (DrawLisType *) malloc(sizeof(DrawLisType));

	p->next		= NULL;

	p->info.command = UNDEFINED;
	p->info.pts	= NULL;
	p->info.str	= NULL;
	p->info.fid	= 0;

	strcpy(command, "undefined");

	fscanf(f, "%s", command);


	if (strcmp(command, "drawline") == 0) {
		p->info.command = DRAWLINE;
		fscanf(f, "%d %d %d %d", &(p->info.x1), &(p->info.y1), 
                                         &(p->info.x2), &(p->info.y2));
		p->info.y1	+= YOFFSET;
		p->info.y2	+= YOFFSET;
/*		printf("%d %d %d %d\n", p->info.x1, p->info.y1, p->info.x2, p->info.y2);	*/
	}
	if (strcmp(command, "drawarc") == 0) {
		p->info.command = DRAWARC;
		fscanf(f, "%d %d %d %d %d %d", &(p->info.x1), &(p->info.y1), &(p->info.width),
                                               &(p->info.height), &(p->info.angle1), &(p->info.angle2));
		p->info.y1	+= YOFFSET;
	}
	if (strcmp(command, "fillarc") == 0) {
		p->info.command = FILLARC;
		fscanf(f, "%d %d %d %d %d %d", &(p->info.x1), &(p->info.y1), &(p->info.width),
                                               &(p->info.height), &(p->info.angle1), &(p->info.angle2));
		p->info.y1	+= YOFFSET;
	}
	if (strcmp(command, "drawpoint") == 0) {
		p->info.command = DRAWPOINT;
		fscanf(f, "%d %d", &(p->info.x1), &(p->info.y1));
		p->info.y1	+= YOFFSET;
	}
	if (strcmp(command, "drawrectangle") == 0) {
		p->info.command = DRAWRECTANGLE;
		fscanf(f, "%d %d %d %d", &(p->info.x1), &(p->info.y1), &(p->info.width), &(p->info.height));
		p->info.y1	+= YOFFSET;
	}
	if (strcmp(command, "fillrectangle") == 0) {
		p->info.command = FILLRECTANGLE;
		fscanf(f, "%d %d %d %d", &(p->info.x1), &(p->info.y1), &(p->info.width), &(p->info.height));
		p->info.y1	+= YOFFSET;
	}
	if (strcmp(command, "setlinewidth") == 0) {
		p->info.command = SETLINEWIDTH;
		fscanf(f, "%d", &(p->info.width));
	}
	if (strcmp(command, "setlinestyle") == 0) {
		char			buffer[20];


		p->info.command = SETLINESTYLE;

		fscanf(f, "%s", buffer);

		p->info.style 	= LineSolid;

		if (strcmp(buffer, "Dashed") == 0)
			p->info.style = LineOnOffDash;
	}
	if (strcmp(command, "drawlines") == 0) {
		int			numpts, i;


		p->info.command = DRAWLINES;

		fscanf(f, "%d", &numpts);

		p->info.npts = numpts;

                p->info.pts = (XPoint *) calloc(numpts, sizeof(XPoint));

		for (i = 0; i < numpts; i++) {
			fscanf(f, "%hd %hd",&((p->info.pts)[i].x), &((p->info.pts)[i].y));
			(p->info.pts)[i].y	+= YOFFSET;
/*			printf("%hd	%hd\n", (p->info.pts)[i].x, (p->info.pts)[i].y);     */
		}
	}
	if (strcmp(command, "setdashes") == 0) {
		int			numdashes, i;
		int			temp;


		p->info.command = SETDASHES;

		fscanf(f, "%d", &numdashes);

		p->info.ndashes = numdashes;

		p->info.dashes = (char *) calloc(numdashes, sizeof(char));

		for (i = 0; i < numdashes; i++) {
			fscanf(f, "%d", &temp);
			(p->info.dashes)[i] = (char) temp;
		}
	}
	if (strcmp(command, "fillpolygon") == 0) {
		int			numpts, i;


		p->info.command = FILLPOLYGON;

		fscanf(f, "%d", &numpts);

		p->info.npts = numpts;

                p->info.pts = (XPoint *) calloc(numpts, sizeof(XPoint));

		for (i = 0; i < numpts; i++) {
			fscanf(f, "%hd %hd",&((p->info.pts)[i].x), &((p->info.pts)[i].y));
			(p->info.pts)[i].y	+= YOFFSET;
/*			printf("%hd	%hd\n", (p->info.pts)[i].x, (p->info.pts)[i].y);     */
		}
	}
	if (strcmp(command, "drawstring") == 0) {
		int			i;
		char			ch;

												
		p->info.command = DRAWSTRING;

		fscanf(f, "%d %d", &(p->info.x1), &(p->info.y1));
		p->info.y1	+= YOFFSET;
		
		p->info.str = (char *) calloc(256, sizeof(char));

		fscanf(f, "%c", &ch);

		fgets(p->info.str, 250, f);

		p->info.width	= XTextWidth(fontinfo, p->info.str, strlen(p->info.str) - 1);

		p->info.fid 	= fontinfo->fid;

	}
	if (strcmp(command, "setfont") == 0) {
		char			buffer[200];
		

		p->info.command = SETFONT;

		fscanf(f, "%s", buffer);
		LoadFont(buffer);

		p->info.fid = fontinfo->fid;

	}
	if (strcmp(command, "setcolor") == 0) {
		char			buffer[200];
		XColor			rgb, hgb;
/*		int			i;


		i = DefaultDepthOfScreen(display, screen);	*/

		p->info.command = SETCOLOR;

		fscanf(f, "%s", buffer);

		if (DefaultDepth(display, screen) != 1) {
			XAllocNamedColor(display, DefaultColormap(display, screen), buffer, &hgb, &rgb);
			p->info.pixel = hgb.pixel;
		}
		else {
			p->info.pixel = BlackPixel(display,screen);
		}
	}



	if (drawLis == NULL) {
		drawLis		= p;
		drawLisTail	= p;
		return;
	}

	drawLisTail->next = p;
	drawLisTail = p;
}

	


ParseDataFile(fileName)
char			*fileName;
{
	FILE			*f;
	char			command[50];



	if ((f = fopen(fileName, "rt")) == NULL) {
		(void) fprintf(stderr, "xbatch: File %s was not found\n", fileName);
		exit(-1);
	}	
	while (feof(f) == 0) {
		GetInfo(f);
	}
}




TraverseLis()
{
	DrawLisType		*p;
	unsigned int		linewidth	= 1;
	int			linestyle	= LineSolid;

/*	XSegment		lineSegment;			*/
		



	XSetForeground(display, gc, BlackPixel(display,screen));
	XSetLineAttributes(display, gc, linewidth, linestyle, CapButt, JoinRound);
/*	XSetFillStyle(display, gc, FillStippled);								*/

	p = drawLis;
	while (p != NULL) {
/*		printf("%d\n", p->info.command);		*/
		switch(p->info.command) {
			case DRAWLINE : 
/*				printf("%d %d %d %d\n", p->info.x1, p->info.y1, p->info.x2, p->info.y2);	*/
				XDrawLine(display, win, gc, p->info.x1,p->info.y1,p->info.x2,p->info.y2);
				
/*				lineSegment.x1	= p->info.x1;
				lineSegment.y1	= p->info.y1;
				lineSegment.x2	= p->info.x2;
				lineSegment.y2	= p->info.y2;

				XDrawSegments(display, win, gc, &lineSegment, 1);	*/
				break;
			case DRAWARC :
				XDrawArc(display, win, gc, p->info.x1,p->info.y1,p->info.width,p->info.height,
                                                           p->info.angle1, p->info.angle2);
				break;
			case FILLARC :
				XFillArc(display, win, gc, p->info.x1,p->info.y1,p->info.width,p->info.height,
                                                           p->info.angle1, p->info.angle2);
				break;
			case DRAWPOINT :
				XSetLineAttributes(display, gc, 1, LineSolid, CapButt, JoinBevel);
				XDrawLine(display, win, gc, p->info.x1, p->info.y1, p->info.x1 + 1, p->info.y1);
				XSetLineAttributes(display, gc, linewidth, linestyle, CapButt, JoinBevel);

/*				XDrawPoint(display, win, gc, p->info.x1, p->info.y1);					*/

				break;
			case DRAWRECTANGLE :
				XDrawRectangle(display, win, gc, p->info.x1, p->info.y1, p->info.width, p->info.height);
				break;
			case FILLRECTANGLE :
				XFillRectangle(display, win, gc, p->info.x1, p->info.y1, p->info.width, p->info.height);
				break;
			case SETLINEWIDTH :
/*				printf("Line width -> %d\n", p->info.width);     */
				linewidth	= p->info.width;
				XSetLineAttributes(display, gc, linewidth, linestyle, CapButt, JoinBevel);
				break;
			case SETLINESTYLE :
				linestyle	= p->info.style;
				XSetLineAttributes(display, gc, linewidth, linestyle, CapButt, JoinBevel);
				break;
			case DRAWLINES :
				XDrawLines(display, win, gc, p->info.pts, p->info.npts, CoordModeOrigin);
				break;
			case SETDASHES :
				XSetDashes(display, gc, 0, p->info.dashes, p->info.ndashes);
				break;
			case FILLPOLYGON :
				XFillPolygon(display, win, gc, p->info.pts, p->info.npts, Nonconvex, CoordModeOrigin);
				break;
			case DRAWSTRING :
				XSetFont(display, gc, p->info.fid);
				XDrawString(display, win, gc, p->info.x1, p->info.y1, p->info.str, strlen(p->info.str) - 1);
				break;
			case SETFONT :
				XSetFont(display, gc, p->info.fid);
				break;
			case SETCOLOR :
				XSetForeground(display, gc, p->info.pixel);
				break;
			default :
				break;
		}
		p = p->next;
	}
	XFlush(display);
}







FreeDrawLis()
{
	DrawLisType		*p,*q;


	p = drawLis;

	while (p != NULL) {
		q = p;

		if (p->info.pts != NULL)
			free(p->info.pts);
		if (p->info.str != NULL)
			free(p->info.str);
		if (p->info.fid != 0)
			XUnloadFont(display, p->info.fid);

		p = p->next;
		free(q);
	}
}
