;;; -*- Mode:Common-Lisp; Package:POS; Syntax:COMMON-LISP; Default-character-style:(FIX BOLD NORMAL); Base:10 -*-
;;; Copyright 1988 David Throop at the University of Texas at Austin

;;; EXPLORER version of Machine Dependent Parameters.

(in-package 'pos)

;;; This file is full of parameters and some functions that are specific to the particular
;;; host machine and terminal on which the output is diplayed.

;;; Although these functions are, generally, device dependent, the parameters in the front
;;; of this file are identical between their SYMBOLICS and EXPLORER versions.

(defparameter *symbol-x-offset* -3)		; peculiar positional offsets to get
(defparameter *symbol-y-offset* +4)		; symbols in the right place.
 
(defparameter xscreen 1037.)                    ; horizontal screen size
(defparameter yscreen 700.)                     ; vertical screen size
(defparameter bmargin 50.)			; Size of margin at bottom of screen

(defparameter *black*       tv:alu-seta)		; Drawing Black and White is (at least on 3600's
(defparameter *white*       tv:alu-andca)		; implemented in hardware.)
(defparameter *gray-one*    tv:alu-seta)
(defparameter *gray-two*    tv:alu-seta)
(defparameter *gray-three*  tv:alu-seta)
(defparameter *gray-four*   tv:alu-seta)
(defparameter *gray-five*   tv:alu-seta)
(defparameter *gray-six*    tv:alu-seta)
(defparameter *gray-seven*  tv:alu-seta)
(defparameter *gray-eight*  tv:alu-seta)
(defparameter *gray-nine*   tv:alu-seta)
(defparameter *gray-ten*    tv:alu-seta)
(defparameter *flip*        tv:alu-xor)

;;; End of code common to Explorer and Symbolics.  Begin Explorer specific code.

;;; Define some fonts for common-plotting styles

(defparameter axis-font				; for labeling axis points
	      'fonts:tvfont) 

(defparameter *axis-font*     'fonts:tvfont)

(defparameter *axis-font-height*
	      #+ti (tv:font-char-height (eval axis-font)))      ; For TI Explorer

(defparameter label-font			; for labeling individual plots
	      'fonts:medfnb)

(defparameter *label-font*    'fonts:medfnb)

(defparameter *plain-font* 'fonts:cptfont)

(defparameter *dot-font*			;
	      'fonts:mouse)

(defun reset-fonts (&optional new-fonts)	; to get a better PostScript output
  (if new-fonts
      (setf axis-font    'fonts:tr8
	    *plain-font* 'fonts:tr12)
      (setf axis-font    'fonts:tvfont
	    *plain-font* 'fonts:cptfont)))

;;; Remember, for Explorers, you use different fonts for writing and
;;; drawing on the Lisp Listener.  Qplot-string uses the fonts in FONTS: but drawing
;;; on a window uses fonts in the w: package

(defparameter *qplot-output* *standard-output*
  "Screen output stream (also set on initialization) in QPLOT-NEW-BEHAVIOR")

;;; The next funtion maps the EXPLORER fonts into Postscript fonts.

;;;  If this is a new font, we will have to execute PostScript FINDFONT and SCALEFONT
;;; commands, (which is expensive, so we only want to do it once.)  Keep track of what
;;; fonts we have already seen as an Alist on *used-fonts*.  Associate each new font with
;;; a GENTEMP atom in the Alist.     If the font has been seen before (if we find it when
;;; we look it up in *used-fonts*), check to see if it is the *current-font*.  If so, do
;;; nothing.  If not, tell PostScript to SETFONT to this font.

; Explorer version:  Currently, if a font is used that is not listed in this function
; no value is assigned to the font for postscript, and the file won't print.
; This is not good, and a default value needs to be assigned if no match is found.

(defun get-font-for-string (ignore explorer-font)
  (let* ((*print-case* :upcase)
	 (pair					;pair is a list of (font size)
	   (or (case explorer-font
		 (fonts:tvfont    (list :|Courier| 10))
		 (fonts:medfnb    (list :|Times-Bold| 14))
		 (fonts:mouse     (list :|Symbol| 8))
		 (fonts:hl10      (list :|Helvetica| 10))
		 (fonts:hl12      (list :|Helvetica| 12))
		 (fonts:hl12i     (list :|Helvetica-Oblique| 12))
		 (fonts:hl12b     (list :|Helvetica-Bold| 12))
		 (fonts:hl12bi    (list :|Helvetica-BoldOblique| 12))
		 (fonts:cptfont   (list :|Courier| 12))
		 (fonts:cptfonti  (list :|Courier-Oblique| 12))
		 (fonts:cptfontb  (list :|Courier-Bold| 12))
		 (fonts:cptfontbi (list :|Courier-BoldOblique| 12))
		 (fonts:tr8       (list :|Times-Roman| 8))
		 (fonts:tr10      (list :|Times-Roman| 10))
		 (fonts:tr12      (list :|Times-Roman| 12))
		 (fonts:tr12b     (list :|Times-Bold| 12))
		 (fonts:tr12i     (list :|Times-Italic| 12))
		 (fonts:tr12bi    (list :|Times-BoldItalic| 12))
		 )
	       (list :|Courier| 12)
	       ))
	 (familiar-font (assoc pair *used-fonts* :test #'equal))
	 (gatom (if familiar-font
		    (second familiar-font)
		    (gentemp (format nil "~:@(~a-~)" (car pair))))))
    (enforce-string (car pair) familiar-font (cadr pair) gatom pair)))

(defun merge-font-info (ignore char)
  char)

(defun strip-font-info (string)
  string)


