;;; -*- Mode:Common-Lisp; Package:POS; Syntax:COMMON-LISP; Default-character-style:(FIX BOLD NORMAL); Base:10 -*-


;;;;  Main test file for qplot routines


(in-package :pos)

#+:ccl
(use-package :ccl :pos)

#+symbolics
(use-package :scl :pos)

#+symbolics
(import '(self send defmethod))


(defun l-test () (load (format nil "~aqplot-test.lisp" *lisp-dir*)))



(defun test-one ()
       (device-interface
	       (qplot-new-behavior)
	       (qplot-vector 100 200 100 100 :shaftthick 1 :arrow-base-width 30 :arrow-head-length 50)
	       (qplot-vector 100 200 500 200  :shaftthick 1 :dashed t :arrow-base-width 30 :arrow-head-length 50)
	       (qplot-hline 100 100 100 :thickness 10)
	       (qplot-vline 100 100 220 :thickness 10)
	       (qplot-lines '(110 300 160 400 220 200 260 350 310 100 360 275) :thickness 5)
	       (qplot-line 10 50 300 50 :thickness 20)
	       (qplot-string "Qsim lives!!!!!!!!!!!" 100 85 :font *axis-font*)
	       (qplot-circle 100 100 50 :filled t :end-angle (* pi 1.50) :thickness 5)
	       (qplot-ring 400 100 80 100)
	       (qplot-ellipse 400 200 100 50 :thickness 5)
	       (qplot-polygon '(100 100 200 200 300 100)  :filled nil :thickness 5)
	       (qplot-box 200 100 200 50 :thickness 2)
	       (qplot-dot 30 30)
	       (qplot-dot 40 40)
	       (qplot-end-display)))



(defun test-two ()
       (device-interface
	       (qplot-new-behavior)
	       (qplot-line 10 50 300 50 :thickness 20 :color *gray-six*)
	       (qplot-end-display)))



(defun test-three ()
       (device-interface
		(qplot-new-behavior)
	        (qplot-symbol 10 10 :inc)
	        (qplot-symbol 20 20 :dec)
	        (qplot-symbol 30 30 :left)
	        (qplot-symbol 40 40 :right)
	        (qplot-symbol 50 50 :ign)
	        (qplot-symbol 60 60 :std)
	        (qplot-symbol 70 70 nil)
		(qplot-line 100 100 400 400 :dashed t :thickness 20 :dash-pattern '(30 10))
                (qplot-special-char 80 80 "k" "135")
		(qplot-end-display) ))



(defun test-device ()
       (device-interface
                (qplot-new-behavior)
	        (qplot-vector 100 400 100 100 :shaftthick 10 :arrow-base-width 30 :arrow-head-length 50)
	        (qplot-vector 95 400 800 400  :shaftthick 10 :arrow-base-width 30 :arrow-head-length 50)       
                (qplot-end-display)
                (device-interface
			(qplot-new-behavior)
 	                (qplot-lines '(110 300 160 400 220 200 260 350 310 100 360 275) :thickness 5)
	                (qplot-line 130 370 700 150 :thickness 10)
	                (qplot-string "Qsim lives!!!!!!!!!!!" 100 500)
                        (qplot-end-display))))


(defun test-fonts ()
       (device-interface
                 (qplot-new-behavior)
                 (qplot-string "Kee was here" 100 100 :font *plain-font*)
                 (qplot-end-display)))


