;;; -*- Mode:Common-Lisp; Package:POS; Syntax:COMMON-LISP; Default-character-style:(FIX BOLD NORMAL); Base:10 -*- 
;;; Copyright 1988, 1989, 1990 David Throop at the University of Texas at Austin

(in-package :pos)

#+:ccl
(use-package :ccl :pos)

#+symbolics
(use-package :scl :pos)

#+symbolics
(import '(self send defmethod))

;;; This file includes functions that have been implemented on all
;;; platforms supported, but can be considered as advanced features, not
;;; necessary to most plotting.


(defun qplot-dashed-line (x1 y1 x2 y2  &key (alu *black*)
			 (thickness 1) (dash-pattern '(10 10)))
       (when (image-to-postscript-p)
             (ps-draw-dashed-line x1 y1 x2 y2 :alu alu :dash-pattern dash-pattern))
       (when (image-to-screen-p)
             #+symbolics	(graphics:draw-line
		                     (round x1)(round y1)(round x2)(round y2)
		                     :alu alu :thickness thickness :stream *qplot-output*
		                     :dashed t :dash-pattern dash-pattern)

             #+ti		(send *qplot-output* :draw-dashed-line
	                             (round x1) (round y1)  (round x2) (round y2)
	                              thickness 8 alu)

             #-(or symbolics ti)(qplot-line x1 y1 x2 y2 :dashed t :dash-pattern dash-pattern
			                                :alu alu :thickness thickness)))



;;;  QPLOT-SUPERSCRIPTED-STRING does about what you'd expect.  STRING is
;;; printed at (x,y) just as it would be in QPLOT-STRING, and the ALU
;;; and FONT arguments also work the same as in QPLOT-STRING.  After
;;; printing STRING in FONT, it moves SUPERSCRIPT-HEIGHT pixels up and
;;; XADV pixels to the right (measured from the right end of string) and
;;; prints SUPERSCRIPT in SUPERSCRIPT-FONT.  
;;;   What makes this different than just printing both the string and
;;; the superscript individually with QPLOT-STRING is the way it maps
;;; onto PostScript -- the right end of a string printed on the screen
;;; may match imperfectly to the same string printed in the
;;; corresponding font in PostScript.  Therefore,
;;; QPLOT-SUPERSCRIPTED-STRING does its .ps plotting entirely through a
;;; call to PS-DRAW-SUPERSCIPTED-STRING, which plots the superscript
;;; relative to the end of the string in PostScript, rather than the
;;; string's end on the screen.
;;;   Of course, printing with negative values of SUPERSCRIPT-HEIGHT
;;; allows subscripting.

(defun qplot-superscripted-string
       (string superscript x y &key (alu *black*)(font *plain-font*)
	(superscript-height 5)(xadv 2)(superscript-font axis-font))
  (setf string (string-conversion string)
	superscript (string-conversion superscript ))
  (when (image-to-postscript-p)
    (ps-draw-superscipted-string string superscript x y superscript-height
				 xadv alu font superscript-font))
  (when (image-to-screen-p)
    (with-plotting-to-postscript-inhibited
      (qplot-string
	superscript (+ xadv (qplot-string string x y :font font
					  :alu alu))
	(round (- y superscript-height)) :alu alu 
	:font superscript-font ))))

(defun qplot-oval
       (center-x center-y x-radius y-radius &key (alu *black*) (filled nil) (thickness 1))
  (when (image-to-postscript-p)
    (ps-draw-oval center-x center-y x-radius y-radius :alu alu :filled filled
		  :thickness thickness))
  (when (image-to-screen-p)			; tolerates floating point
    #+symbolics (graphics:draw-oval center-x center-y x-radius y-radius :alu alu	
				    :stream *qplot-output* :filled filled :thickness thickness)
    #+ti (if filled				; This hasn't been debugged on a TI yet...
	     (send *qplot-output*  :draw-filled-oval
		   center-x center-y x-radius y-radius w:black alu)
	     (send *qplot-output*  :draw-oval
		   center-x center-y x-radius y-radius 1 w:black alu))
    #-(or symbolics ti) (error "Oval Not Implemented Yet")))


;; Plot a label for a behavior on the screen.  X,Y will specify the
;; starting point for the string, just below the left hand side of the box.

                                ; (defun qplot-box-label (x y string)   old version
(defun qplot-box-label (x y string &key (plot-function 'qplot-string)) ;D.B. 5/22/91
  (let ((font (if (and (or (stringp string)(symbolp string))
		       (> (length (string string)) 32))
		  axis-font label-font)))
                     ; (qplot-string string x y :alu #+lispm *flip*     old version
    (funcall plot-function string x y :alu #+lispm *flip*              ;D.B. 5/22/91
		  #-lispm *black* :font font)))

;; Put a label for a landmark value on the right hand side of the graph,
;; placing it on the Y-axis.

(defun qplot-axis-label (x y string)
  (qplot-string  string x y :alu #+lispm *flip* #-lispm *black* :font axis-font))


;;; Same as QPLOT-LINES, but adds an arrowhead onto the end.

(defun qplot-lines-with-arrowhead
       (pointlist &key (alu *black*) (shaftthick 1)
	(arrow-head-length 10) (arrow-base-width 5))
  (setf pointlist (copy-list pointlist))
  (let* ((len (length pointlist))
	 (end4 (subseq pointlist (- len 4))))
    (multiple-value-bind (6points  xbas ybas)
	(triangle-point-translation
	  (first end4)(second end4)(third end4)(fourth end4)
	  (* shaftthick arrow-base-width) (* shaftthick arrow-head-length))
      (setf (nth (- len 2) pointlist) xbas
	    (nth (- len 1) pointlist) ybas)
      (qplot-lines pointlist :alu alu :thickness shaftthick)
      #+ti (send *qplot-output* :draw-filled-triangle
		 (first 6points)(second 6points)(third 6points)
		 (fourth 6points)(fifth 6points)(sixth 6points)
		 w:black alu)
      #-ti (qplot-polygon 6points :alu alu :filled t))))


#|
;;;  Defined qplot-primitves.lisp

(defun qplot-arrowhead (from-x from-y to-x to-y &optional (drawlinep t)
			(shaftthick 1) (alu *black*) (arrow-head-length 10) (arrow-base-width 5))
  (multiple-value-bind (points  xbas ybas)
      (triangle-point-translation
	from-x from-y to-x to-y (* shaftthick arrow-base-width)
	(* shaftthick arrow-head-length))
    (when  drawlinep
      (qplot-line from-x from-y xbas ybas
		  :thickness shaftthick :alu alu))
    #+ti (send *qplot-output* :draw-filled-triangle
	       (first points)(second points)(third points)
	       (fourth points)(fifth points)(sixth points)
	       w:black alu)
    #-ti (qplot-polygon points :alu alu :filled t)))

|#
