;; This file is designed to start nq on the Suns using xwindows.

(in-package 'user)


;;; This file contains code used to load QSIM on either
;;; a unix machine or on the Mac.  The code for these
;;; versions are different.

#+:unix
(let ((*qsim-root-dir* "/v/deepthought/v0/qr"))
  (progn
  ;;; LOAD  the LOGICAL-PATHNAME and DEFSYSTEM facilities
  
    (load (format nil "~a/c-lisp/logical-pathnames.lisp" *qsim-root-dir*))
    (load (format nil "~a/c-lisp/new-defsystem.lisp" *qsim-root-dir*))
    (load (format nil "~a/c-lisp/defsystem-patches.lisp" *qsim-root-dir*))))

#+:unix (defun compile-qsim (&key (force :new-source-and-dependents)
				  (verbose nil))
	  (with-deferred-warnings
	      (operate-on-system 'nq 'compile :verbose verbose :force force)))

#+:unix
(let ((*qsim-root-dir* "/v/deepthought/v0/qr"))
  (progn
    (setq mk::*central-registry* (format nil "~a/sys-site/" *qsim-root-dir*))
    
    (format t "~%~%")
    (defvar user::*qsim-pos-options* '((pos-display-choice :x-windows)))
    (cond ((mk::y-or-n-p-wait #\y 15 "Load QSIM? [yn] ")
	   (operate-on-system 'nq 'load :verbose t :load-source-if-no-binary t))
	  ((mk::y-or-n-p-wait #\n 30 "Compile QSIM [ny] ")
	   (compile-qsim :verbose t)))))
  
  

#+:ccl
(progn
  (defparameter *lisp-root* (format nil "hd:ccl"))
  (defparameter *qsim-root* (format nil "~a:qsim" *lisp-root*))
  
  (load (format nil "~a:Library:QuickDraw.lisp" *lisp-root*))
  (load (format nil "~a:c-lisp:new-defsystem.lisp" *qsim-root*)))

#+:ccl
(progn
  (setf mk::*central-registry* (format nil "~a:sys-site:" *qsim-root*))
  (let ((*warn-if-redefine-kernel* nil))
    (operate-on-system 'nq 'load :verbose t :load-source-if-no-binary t)))
