;;; -*- Mode: LISP; Syntax: Common-lisp; Package: QSIM; Base: 10 -*-
;;;  $Id: qsim-exports.lisp,v 1.2 1992/04/23 16:19:21 clancy Exp $
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; SET UP THE EXPORTS
;;;
(in-package :qsim)

;; NOTE: these lists are VERY incomplete!
;;       if you use a function, and it is not here, please add it!
;;

(eval-when (compile load eval)
  (defparameter *export-qsim-functions*
		'(q qsim propagation define-qde qsim-display
		    make-new-state qsim-cleanup lookup qde-layout))

  (defparameter *export-qde-clauses*
		'(quantity-spaces constraints layout transitions print-names
				  other unreachable-values  qspace-hierarchy
				  Text Discrete-Variables 
				  Coeffs Sd3-Constraint Abstracted-From Faster Slower
				  Normal-State Abstracted-To
				  Curvature-At-Steady Define-Normal
				  Independent History No-New-Landmarks Ignore-Qdirs Ignore-Qvals
				  energy-constraint M-envelopes initial-ranges
				  initial-values))

  (defparameter *export-qsim-constraints*
		(mapcar #'contype-name *known-constraint-types*))

  (defparameter *export-qsim-lmarks*
		'(inc std dec inf minf))

  (defparameter *export-qsim-misc*
		'(*seq *eqv *set))

  (defparameter *export-qsim-switches*
		'(*paths-for-dumping-NQ* *paths-for-NQ-system-files* *paths-for-dumping-Q*
					 *paths-for-Q-system-files*))

  (defparameter *export-interface-functions*
		'(bboxbind bboxbind-no-margin)))

;;;
;;; Export them at load time
;;;
;;; Replaced the #, syntax with the eval-when (load eval).  I hope that this will 
;;; eliminate problems on the TIs and also be more portable (#, has been removed
;;; from the language CLtL2 pg 535). Adam Farquhar 24.Oct.90.
;;;


(export *export-qsim-functions* :qsim)
(export *export-qde-clauses*    :qsim)
(export *export-qsim-constraints* :qsim)
(export *export-qsim-lmarks*    :qsim)
(export *export-qsim-misc*      :qsim)
(export  *export-qsim-switches* :qsim)
(export *export-interface-functions* :qsim)
;;; If using qsim from another package, do 
;;; (use-package '(:qsim)