;; -*- Mode:Common-Lisp; Package:User; Syntax:Common-Lisp; Base:10 -*-
;       Copyright 1987, Benjamin Kuipers
;;;  $Id: cl-nq-system.lisp,v 1.28 1992/07/22 16:32:29 clancy Exp $

;;;  THis file contains the Common Lisp Defsystem for QSIM.


(in-package 'User)

;;; Define a special variable which keps track of the options which
;;; can be selected when loading QSIM.  This variable defines options
;;; for both QSIM and POS and it is defined in both system files.
;;;
;;; This variable is also defined in
;;;
;;;       cl-nq-system.lisp
;;;
;;; IF CHANGES ARE MADE, PLEASE UPDATE THIS FILE TOO !!!!!!!!

(defvar user::*qsim-pos-options* '((pos-display-choice nil)))

;;; Functions and macros which can be used to access the options list.
;;; These functions should also be defined in the
;;;
;;;        cl-nq-system.lisp
;;;
;;; IF YOU MAKE CHANGES PLEASE UPDATE THIS FILE TOO!!!!

(unless (fboundp 'user::get-qsim-pos-option)
  (defmacro user::get-qsim-pos-option (option)
    `(cadr (assoc ,option user::*qsim-pos-options*))))

(unless (fboundp 'user::set-qsim-pos-option)
  (defmacro user::set-qsim-pos-option (option setting)
    `(cond ((assoc ,option user::*qsim-pos-options*)
	    (setf (cadr (assoc ,option user::*qsim-pos-options*)) ,setting))
            (t (pushnew (list ,option ,setting) user::*qsim-pos-options*)
	       (cadr (assoc ,option user::*qsim-pos-options*))))))




;;;  THe Common Lisp Logical pathname package is not used
;;;  in the Mac Intosh version.  Thus, all of the declarations
;;;  used with the logical-pathname package are contained within one
;;;  big read-time conditional.

; Set up logical device NQ with logical directories for code and
; examples.  Any changes to these pathname translations should also be
; made in sys:site;nq.translations.

#+:logical-pathnames-mk
(let ((*qsim-root* "/v/ai/v5/qr"))  ;;;  FOR INSTALLATION, CHANGE THIS VARIABLE.
  (declare (special *qsim-root*))
  (setf (lp:physical-host-type "ai") :unix)

  (setf (lp:logical-pathname-translations "sys")
	'(("site;*"     (format nil "~a/sys-site/" *qsim-root*))))
  
  (setf (lp:logical-pathname-translations "root")
	'(("nq;*"       (format nil "~a/nq/" *qsim-root*))
	  ("pos;*"      (format nil "~a/pos/" *qsim-root*))
	  ("xpos;*"     (format nil "~a/xpos/" *qsim-root*))))
  
  
  (defvar user::*bin-dir-component*
    #+:pos-lispview (format nil "~a_lispview"
			    (mk::afs-component
			     (mk::machine-type-translation (machine-type))
			     (mk::software-type-translation (software-type))))
    #-:pos-lispview (format nil "~a"
			    (mk::afs-component
			     (mk::machine-type-translation (machine-type))
			     (mk::software-type-translation (software-type)))))
  
  (setf *bin-dir* (format nil 
			  "~a/nq/bins/~a/"
			  *qsim-root*
			  user::*bin-dir-component*))
  
  
  (setf (lp:logical-pathname-translations "NQ")
	'(("nq;*"              (format nil "~a/nq/source/main/" *qsim-root*))
	  ("examples;*"        (format nil "~a/nq/source/examples/" *qsim-root*))
	  ("catalogs;*"        (format nil "~a/nq/source/catalogs/" *qsim-root*))
	  ("text;*"	     (format nil "~a/nq/source/text/" *qsim-root*))
	  ("experiments;*"     (format nil "~a/nq/source/experiments/" *qsim-root*))
	  ("interface;*"       (format nil "~a/nq/source/interface/" *qsim-root*))
	  ("cc;*"              (format nil "~a/nq/source/cc/" *qsim-root*))
	  ("c-code;*"	     (format nil "~a/nq/source/c-code/" *qsim-root*))
	  ("ps;*"              (format nil "~a/nq/source/postscript/" *qsim-root*))
	  ("bin;*"             *bin-dir*)
	  ("bin;nq;*"          *bin-dir*)
	  ("bin;examples;*"    *bin-dir*)
	  ("bin;catalogs;*"    *bin-dir*)
	  ("bin;text;*"	     *bin-dir*)
	  ("bin;experiments;*" *bin-dir*)
	  ("bin;interface;*"   *bin-dir*)
	  ("bin;cc;*"          *bin-dir*)
	  ("bin;ps;*"          *bin-dir*))))
  
  

;;;  Set-up the logical pathnames for the Mac using the logical pathname 
;;;  facility provided there.  Added DJC


#+:ccl
(progn
  (def-logical-pathname "nq:nq;"          (format nil "~a:nq:source:main:" user::*qsim-root*))
  (def-logical-pathname "nq:examples;"    (format nil "~a:nq:source:examples:" user::*qsim-root*))
  (def-logical-pathname "nq:catalogs;"    (format nil "~a:nq:source:catalogs:" user::*qsim-root*))
  (def-logical-pathname "nq:text;"        (format nil "~a:nq:source:text:" user::*qsim-root*))
  (def-logical-pathname "nq:experiments;" (format nil "~a:nq:source:experiments:" user::*qsim-root*))
  (def-logical-pathname "nq:interface;"   (format nil "~a:nq:source:interface:" user::*qsim-root*))
  (def-logical-pathname "nq:cc;"          (format nil "~a:nq:source:cc:" user::*qsim-root*))
  (def-logical-pathname "nq:ps;"          (format nil "~a:nq:source:postscript:" user::*qsim-root*))
  (def-logical-pathname "nq:bin;"         (format nil "~a:nq:bin:" user::*qsim-root*))
  (def-logical-pathname "nq:bin;nq;"         (format nil "~a:nq:bin:" user::*qsim-root*))
  (def-logical-pathname "nq:bin;examples;"   (format nil "~a:nq:bin:" user::*qsim-root*))
  (def-logical-pathname "nq:bin;catalogs;"   (format nil "~a:nq:bin:" user::*qsim-root*))
  (def-logical-pathname "nq:bin;text;"       (format nil "~a:nq:bin:" user::*qsim-root*))
  (def-logical-pathname "nq:bin;experiments" (format nil "~a:nq:bin:" user::*qsim-root*))
  (def-logical-pathname "nq:bin;interface;"  (format nil "~a:nq:bin:" user::*qsim-root*))
  (def-logical-pathname "nq:bin;cc;"         (format nil "~a:nq:bin:" user::*qsim-root*))
  (def-logical-pathname "nq:bin;ps;"         (format nil "~a:nq:bin:" user::*qsim-root*)))

; Q is written in CommonLisp, with device-dependencies limited to a few files.
; The code is in the QSIM package.

(unless (find-package 'qsim)
  (make-package 'qsim
		:use '(lisp)))					; inherit from pure Common Lisp


;;; This is needed by loop.lisp which gets loaded while in package qsim and
;;; provide is referenced there.  BKay 3Sept91
;;;
#+allegro-v4.0 (import 'cltl1:provide 'qsim)


;;; Load the patches for the son code

(load "nq:nq;sun-patches.lisp")


(mk:defsystem NQ
    :host "ai"
    :source-pathname     "nq:"
    :source-extension    "lisp"
    :binary-pathname     #-:ccl"nq:bin;"   ; the MAC logical pathnames does not work with this  DJC
                         #+:ccl nil
    :package             qsim
    :depends-on ("xpos")
    :finally-do          (pushnew :qsim *features*)
    :components 
    ((:module defs                                                 ;Compile and Load these first
	      :source-pathname ""    ; DJC 13July92 made loading loop the default
	      :components (#-(or :lcl3.0 :lcl4.0 :loop) 
			     (:file "interface;loop"
				    :depends-on nil)
			   (:file "nq;qdefs")                         ; Definitions
			   (:file "nq;qutils"                       
				  :depends-on ("nq;qdefs"))
			   (:file "nq;dynamic-slots"
				  :depends-on ("nq;qutils"))
			   (:file "nq;structures"
				  :depends-on ("nq;dynamic-slots"))
			   (:file "nq;defothers"
				  :depends-on ("nq;structures")))
	      :depends-on nil)
     (:module prolog
	      :source-pathname "nq;"
	      :components ((:file "prolog"))
	      :depends-on ("defs"))

     (:module core
	      :source-pathname "nq;"
	      :components  ((:file "define-qde")	    ; Convert QDE input to internal form
			    (:file "cfilter")		    ; Basic QSIM filtering algorithm
			    (:file "constraints")	    ; Definition of QSIM constraints
			    (:file "qspace-hierarchy")	    ; Shared qspaces and the = constraint
			    (:file "propagation")	    ; Propagating partial to complete state
			    (:file "states")		    ; Simulating successor states
			    (:file "global-filters")	    ; Filter predicted states
			    (:file "transitions"))
	      :depends-on ("prolog"))

     (:module interface
	      :source-pathname ""
	      :components ((:file "interface;plotting-constants")     ; All of the Defparameters
			   (:file "interface;qplot"		      ; Top level calls and some user query
				  :depends-on ("interface;plotting-constants"))
			   (:file "interface;allocations"	      ; Allocating space within plots
				  :depends-on ("interface;qplot"))
			   (:file "interface;time-plot")	      ; Standard qsim plotting routine
;			   (:file "interface;qgraph")                 ; Core qgraph functions and structs
;			   (:file "interface;qgraph-io"               ; I/O and hi-level plotting
;			          :depends-on ("interface;qgraph"))
			   (:file "interface;qsim-to-qgraph"          ; qsim->qgraph structure conversion
			          :depends-on ("interface;allocations"))
			   (:file "interface;numeric-plot"            ; qsim display interface for numeric plots
			          :depends-on ("interface;qsim-to-qgraph"))
			   (:file "interface;examine")		      ; Debugging examination and display tools
			   (:file "interface;special-displays")	      ; Macros for producing .ps plots for latex
			   (:file "interface;versiplot")	      ;  more, better of same
			   (:file "interface;tables")		      ; Tabular, rather than graphical, printing
			   (:file "nq;front-end")		      ; Menus of examples (device dependent)
			   (:file "nq;hq-plot")			      ; Plot hierarchical behaviors
			   (:file "interface;viewers-clisp-2")	      ; View one variable across behaviors
;			   (:file "interface;viewers-misc"	      ; Plot phase diagrams across behaviors
;				  :depends-on ("interface;viewers-clisp-2"))
			   (:file "interface;viewers-clisp"	      ; Extras
				  :depends-on ("interface;viewers-clisp-2"))
			   (:file "nq;syntax"))			      ; Warn of malformed Define-QDEs
	      :depends-on ("core"))

     (:module extensions
	      :source-pathname ""
	      :components ((:file "nq;time-scale")				; Time-scale abstraction
			   (:file "nq;hod-derivation")			; Curvature constraint
			   (:file "nq;ncurvature"			;  "
				  :depends-on ("nq;hod-derivation"))
			   (:file "nq;qmatch")				;  "
			   (:file "nq;hod-system-property")
			   ; INTERVALS.lisp replaced by:  arithmetic, equations, q2.
			   (:file "nq;arithmetic")		    ; Interval arithmetic routines
			   (:file "nq;equations"		    ; Q2 equation generation
				  :depends-on ("nq;arithmetic"))
			   (:file "nq;q2"			    ; Q2 interval propagator
				  :depends-on ("nq;equations"))
			   (:file "nq;rk45s")                       ; 4th order Runge-Kutta simulator
			   (:file "nq;numeric-eqn-gen")             ; Numeric eqn generator for nsim and numsim
			   (:file "nq;nsim-interval"                ; Nsim simulator
			          :depends-on ("nq;rk45s"))
			   (:file "nq;nsim-init"                    ; Nsim extremal system generator
			          :depends-on ("nq;nsim-interval"
					       "nq;numeric-eqn-gen"))
			   (:file "nq;numsim"                       ; Numerical simulator for QDEs
				  :depends-on ("nq;rk45s"
					       "nq;numeric-eqn-gen"))
			   (:file "nq;nic")			    ; Non-intersection constraint
			   (:file "nq;energy-gf")		    ; Energy-based global filter
			   (:file "interface;comparison")	    ; Compare examples' behaviors after changing code
			   (:file "nq;occ-branch-elimination")      ;  Elimination of occurrence branching
			   (:file "nq;focusing-techniques")         ;  Techniques for focusing on behaviors
			   (:file "nq;xedge")                       ; cross edge envisionment code
			   (:file "nq;envision-guide-filter")       ; Filter to perform envisionment guided
			                                            ; simulation.

			   )
	      :depends-on ("core"))
     
     (:module examples
	      :source-pathname ""
	      :load-only t
	      :components ((:file "catalogs;examples")		
			   (:file "catalogs;tsa")
			   (:file "catalogs;extras")
			   (:file "catalogs;chatter4")
			   (:file "catalogs;chatter3")
			   (:file "catalogs;chatter2")
			   (:file "catalogs;chatter1")
			   (:file "catalogs;q-features")
			   (:file "cc;cc-catalog"))
	      :depends-on nil)

     (:module cc
	      :source-pathname ""
	      :components ((:file "cc;definitions")
			   (:file "cc;functions"
				  :depends-on ("cc;definitions"))
			   )
	      :depends-on nil)

     (:module cc-defs
	      :source-pathname ""
	      :load-only t
	      :components ((:file "cc;hydraulic")
			   (:file "cc;electrical"))
	      :depends-on ("cc"))

     (:file "nq;qsim-exports"
	    :depends-on ("cc-defs"))))

     


; Keep track of version

(defparameter qsim::*system* "NQ")
(defparameter qsim::*cover-page-file* "NQ:nq;cover-page.text")
(defparameter qsim::*package-for-examples* :qsim)	; Load into this package



; To Migrate NQ to Q: 
;   - make sure that the TI version of NQ (in ti-nq-system.lisp) is up to date.
;   - run a complete compilation (compile everything) on a freshly booted 
;     machine.  Fix any errors whatsoever.  Repeat on an Explorer.
; Make the following changes in both the Symbolics and TI system files:
;   - delete the experiments :module
;	     any references to files in the experiments directory
;	     the reference to the experiments module from the :serial clause
;   - if any new subdirectories have been added, and if these new subdirectories  
;     are used by the system definition), update logical pathnames definitions:
;     > in this file
;     > in ti-nq-system.lisp
;     > in sys:site;nq.translations and sys:site;q.translations (in 
;       lonestar:>sys>site>)
;     > in the TI sys:site; nq.translations and sys:site;q.translations
;        (in Genevieve:site;)
;     > and update *paths-for-dumping-NQ* in this file.
;   - Replace String "nq" "q"
;   - Replace String "Xpos" "Pos"
;   - set :physical-host to Schepps
;   - set :initial-status to :released
;   - write changes to q:q;q-system.lisp and q:q;ti-q-system.lisp
;   - Update revision date in Cover-Page.Text
; Remember also to migrate XPOS to POS.  See "XPOS:XPOS;System.lisp"
;
; IMPORTANT:  Send me (Kuipers @ CS.UTexas.edu) your net address and US Mail
;             address if you acquire QSIM by FTP, so I can keep track of who
;             has what version of QSIM.  



