;;; -*- Syntax: Common-Lisp; Package: QSIM -*-

; Accelleration away from the peak of the hill increases with distance.
; Thus, the peak is an unstable equilibrium.

(define-QDE Unstable-Hilltop
   (quantity-spaces
	      (A      (minf 0 inf))
	      (V      (minf 0 inf))
	      (X      (minf 0 inf)))
   (constraints
	      ((d/dt X V))
	      ((d/dt V A))
	      ((M+ A X)         (0 0) (minf minf) (inf inf)))
   (independent)
   (history X V)
   (print-names  (A   "Accelleration")
		 (V   "Velocity")
		 (X   "Position"))
   (text "Unstable equilibrium at hilltop")
   (layout  (nil x nil)
	    (nil v nil)
	    (nil a nil))
   )


; This rolls the ball uphill toward the peak, and disables the
; quiescence filter, so it might fall back down the hill, on either side.

(defun roll-uphill ()
  (let ((initial
	  (make-initial-state unstable-hilltop
			      '((x  ((minf 0) nil))
				(v  ((0 inf) nil)))
			      "Start with initial upward velocity"))
	(*global-state-filters* (remove 'quiescence-filter
					*global-state-filters*)))
    (declare (special *global-state-filters*))
    (qsim initial)
    (qsim-display initial nil)		; no reference points yet.
    ))