;;;  -*- Mode:Common-Lisp; Package: QSIM; Syntax:COMMON-LISP; Base:10 -*-
;;;  Dan Dvorak, 1989.

(in-package :qsim) ;changed DJC


;;;  QSIM-REORDER reorders a Qsim behavior tree to make the shortest
;;;  behaviors come out first, the longest behaviors last.
;;;  After running a simulation, do the following:
;;;
;;;     (qsim-reorder *initial-state*)
;;;     (qsim-display *initial-state*)


(defun qsim-reorder (state)
  (q-reorder state 0))

(defun q-reorder (state n)
  (if (or (null (state-successors state))
	  (null (cadr (state-successors state)))  ; as in '(transition-identity nil)
	  (eql 'cycle-identity (car (state-successors state)))
	  (eql 'partial-match (car (state-successors state))))
      n
      (let* ((lengths (mapcar #'(lambda (state)
				  (q-reorder state (1+ n)))
			      (cdr (state-successors state))))
	     (pairs   (pairlis lengths (cdr (state-successors state))))
	     (sorted  (stable-sort pairs #'< :key #'car)))
	(setf (cdr (state-successors state)) (mapcar #'cdr sorted))
	;; return largest value
	(car (car (last sorted))))))


;;;  analyze behavior tree -- 
;;;    for each behavior:
;;;    -- mention any transitions that occurred
;;;    -- mention final state status if not quiescent (cycle,...)
;;;    -- list values of each history variable during behavior
;;;    -- describe final value of history variables wrt original landmarks
;;;
;;;    for every set of quiescent behaviors of same length,
;;;       show the variables in which they differ
