;;; -*- Package: QSIM; Syntax: Common-Lisp -*-

;  Toward defining generic mechanisms.


; This is the standard Gravity QDE.

(define-QDE Gravity
  (text  "Throw a ball upward in constant gravity.")
  (quantity-spaces
    (y   (minf 0 inf))
    (v   (minf 0 inf))
    (a   (minf g 0 inf)))
  (constraints
    ((d/dt v a))
    ((d/dt y v)))
  (independent a)
  (history y v)
  (layout (nil y nil)
	  (nil v nil)
	  (nil a nil))
  )

; This is a macro that defines instances of the Gravity QDE, with
; appropriately-named variables.

(defmacro Gravity-model (y v a)
  (let ((name (genname 'gravity)))
    `(define-QDE ,name
	 (quantity-spaces
	   (,y   (minf 0 inf))
	   (,v   (minf 0 inf))
	   (,a   (minf g 0 inf)))
         (constraints
	   ((d/dt ,v ,a))
	   ((d/dt ,y ,v)))
         (independent ,a)
         (history ,y ,v))))

; (Gravity-model 'position 'velocity 'accelleration)
; (Gravity-model 'bread-position 'bread-velocity 'gravity)

; Defines a QDE named GRAVITY-nn, but returns NIL, because define-QDE returns NIL
; from the interpreter.  (fix this!)
;
;  - define additional landmarks
;  - define transition functions
;  - 

; The actual gravity model as it appeared in the toaster example.

(define-QDE Gravity-on-bread
  (text  "Throw a ball upward in constant gravity.")
  (quantity-spaces
    (bread-position   (minf click top 0 inf))	; <= problem
    (bread-velocity   (minf 0 inf))
    (gravity          (minf g 0)))
  (constraints
    ((d/dt bread-velocity gravity))
    ((d/dt bread-position bread-velocity)))
  (independent gravity)
  (history bread-position bread-position)
  (transitions
    ((bread-position (top dec)) t)		; <= problem
    ((bread-position (0 dec)) t))		; <= problem
  (layout (nil bread-position nil)
	  (nil bread-velocity nil)
	  (nil gravity nil))
  )

(defun bread-flies-upward (ostate)		; from spring model
  (make-transition-result ostate
			  Gravity-on-bread
			  '((bread-position (top inc))
			    (gravity (g std)))))