;;;  -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-
;;;  Dan Dvorak, 1989.


(define-QDE test-x1
  (text "Test-x1")
  (quantity-spaces
    (a (0 inf))
    (b (0 inf))
    (c (0 inf))
    (d (0 inf)))
  (constraints
    ((M+ a b))
    ((M+ a c))
    ((M+ b c))
    ((M+ b d))
    ((M+ c d)))
  )

(define-QDE xyz
  (text "test invisible variables")
  (quantity-spaces
    (x     (0 inf))
    (y     (0 inf))
    (z     (0 inf))
    (total (0 inf))
    (xy    (0 inf)))
  (constraints
    ((add x y xy))
    ((add xy z total)))
  ;(invisible xy)
  (layout (x y z total)
	  (xy nil nil nil)
	  (nil nil nil nil))
  (other
    (ignore-qdirs xy)
    (unreachable-values ((x 0 inf) (y 0 inf) (z 0 inf)))))

(defun inv-test ()
  (declare (special xyz))
  (let* ((init (make-initial-state xyz
				   `((x     ((0 inf) inc))
				     (y     ((0 inf) dec))
				     (z     ((0 inf) inc))
				     (total ((0 inf) inc))
				     )
				   ))
	 )
    ;(qsim init)
    (qsim-display init)
    ))

(define-QDE xyz2
  (text "test invisible variables")
  (quantity-spaces
    (x     (0 x1 x*))
    (y     (0 y1 y*))
    (sum   (0 sum*)))
  (constraints
    ((add x y sum) (0 0 0) (x* 0 sum*) (0 y* sum*))
    ((increasing x))
    ((increasing y)))
  ;(invisible x y)
  (layout (x y sum)
	  (nil nil nil)
	  (nil nil nil))
  ;(other
  ;  (unreachable-values ((x 0 inf) (y 0 inf) (z 0 inf))))
  )

(defun inv-test-2 ()
  (declare (special xyz2))
  (let ((init (make-initial-state xyz2 `((x     (0 inc))
					 (y     (0 inc))))))
    (qsim init)
    (qsim-display init)
    ))

(define-QDE HEART-REGULATION
 (text "Heart model homeostasis via sympathetic stimulation (H.Tanaka)")
  (quantity-spaces
    (SS (0 SS* INF))
    (AB (0 AB% AB* AB%% INF))
    (AS (0 AS* INF))
    (BB (0 BB% BB* BB%% INF))
    (BS (0 BS* INF))
    (PL (0 PL* INF))
    (PLA (0 PLA* INF))
    (BV (0 BV% BV* BV%% INF))
    (SC (0 SC% SC* SC%% INF))
    (HR (0 HR* INF))
    (HRA (0 HRA* INF))
    (HRX (0 HRX% HRX* HRX%% INF))
    (SV (0 SV* INF))
    (CO (0 CO* INF))
    (PVR (0 PVR* INF))
    (PVRA (0 PVRA* INF))
    (PVRX (0 PVRX% PVRX* PVRX%% INF))
    (MSFP (0 MSFP* INF))
    (MSP (0 MSP* INF))
    (MDP (0 MDP* INF))
    (DSS (MINF 0 INF))
    (EDV (0 EDV* INF))
    (EF (0 EF* INF))
    (IN (0 IN* INF))
    (INA (0 INA* INF))
    (INB (0 INB* INF))
    (INC (0 INC* INF))
    (INX (0 INX% INX* INX%% INF)))
  (other
    (unreachable-values ((ss 0 inf) (ab inf) (as inf) (bb inf) (bs inf)
			 (pl 0 inf) (pla inf) (bv 0 inf) (sc inf) (hr 0 inf) (hra inf)
			 (hrx inf)
			 (sv 0 inf) (co 0 inf) (pvr 0 inf) (pvra inf) (pvrx inf)
			 (msfp 0 inf) (msp 0 inf) (mdp 0 inf) (dss inf) (edv 0 inf) (ef 0 inf)
			 (in inf) (ina inf) (inb inf) (inc inf) (inx inf))))
  (constraints
    ((ADD SS AB AS)       (ss* ab* as*))
    ((ADD SS BB BS)       (ss* bb* bs*))
    ((M+ PLA AS)          (pla* as*)         (0 0) (inf inf))
    ((MULT MSFP SC BV)    (msfp* sc* bv*))
    ((ADD BV PLA PL)      (bv* pla* pl*))
    ((M+ HRA BS)          (hra* bs*)         (0 0) (inf inf))
    ((ADD HRA HRX HR)     (hra* hrx* hr*))
    ((M+ PVRA AS)         (pvra* as*)        (0 0) (inf inf))
    ((ADD PVRA PVRX PVR)  (pvra* pvrx* pvr*))
    ((M+ EDV PL)          (edv* pl*)         (0 0) (inf inf))
    ((M+ INA EDV)         (ina* edv*)        (0 0) (inf inf))
    ((M+ INC BS)          (inc* bs*)         (0 0) (inf inf))
    ((ADD INC INX INB)    (inc* inx* inb*))
    ((ADD INA INB IN)     (ina* inb* in*))
    ((M+ EF IN)           (ef* in*)          (0 0) (inf inf))
    ((MULT EDV EF SV)     (edv* ef* sv*))
    ((MULT HR SV CO)      (hr* sv* co*))
    ((MULT CO PVR MDP)    (co* pvr* mdp*))
    ((ADD MDP MSFP MSP)   (mdp* msfp* msp*))
    ((M- MDP DSS)         (mdp* 0)           (0 inf)  (inf minf))
    ((D/DT SS DSS)) )
  (independent ab bb sc bv inx hrx pvrx)
  (history ss)
 )

; The U-tube:  a simple two-tank system.

(define-QDE U-tube
  (text "U-tube")
  (quantity-spaces
    (amtA       (0 Amax))         ;(0 Amax inf))
    (amtB       (0 Bmax))         ;(0 Bmax inf))
    (total      (0 Tmax))
    (pressureA  (0 pA*))
    (pressureB  (0 pB*))
    (pAB        (minf 0 inf))
    (flowAB     (minf 0 inf))
    (mflowAB    (minf 0 inf)))
  (constraints
    ((M+ amtA pressureA)  (0 0) (Amax pA*))     ; (inf inf))
    ((M+ amtB pressureB)  (0 0) (Bmax pB*))     ; (inf inf))
    ((ADD amtA amtB total) (Amax 0 Tmax) (0 Bmax Tmax))
    ((ADD pAB pressureB pressureA) (0 pB* pA*))
    ((M+ pAB flowAB)      (0 0) (inf inf) (minf minf))
    ((d/dt amtB flowAB))
    ((minus flowAB mflowAB))
    ((d/dt amtA mflowAB)))
  (independent total)
  (history amtA amtB)
;  (transitions
;    ((amtA (Amax inc)) t)
;    ((amtB (Bmax inc)) t)
;    ;((amtB (Bmax inc)) tank-B-burst)
;    )
  (other
    (unreachable-values ((total 0 inf))))
;			))
;		;;;	 (pressureA inf) (pressureB inf))))
  )

(defun simple-U-tube-figure ()
  (declare (special u-tube))
  (let* ((init (make-initial-state U-tube
				   `(;(amtA (Amax nil))
				     ;(amtB (0 nil))
				     (total ((0 t*) std))
				     )
				   "Tank A full; B empty"))
	 (nlayout '((amtA amtB total)
		    (pressureA pressureB)
		    (pAB flowAB)))
	 )
    (qsim init)
    (qsim-display init nil :layout nlayout)
    ))

