
;;; -*- Syntax: Common-Lisp; Package: QSIM -*-

(in-package 'QSIM)

(defun describe-unreachable-landmarks ()
  (format *qsim-report*
"~2%QSIM may be told that certain landmarks in the quantity spaces are
unreachable.  That is, a quantity space can be treated as an open
or half-open interval:  one which does not contain one or both of
its boundary points.

For example, a model of the circulatory system may want to assert
that AMT (amount of blood) cannot reach zero.  Strictly speaking,
there should be constraints that prevent this, or there should be
a minimum value of AMT at which a region transition takes place
(perhaps to a `shock' state).  However, for debugging purposes,
it would be convenient to be able to assert that zero is an
unreachable value and eliminate the possibility.  This is done by
including an Unreachable-Values subclause in the Other clause of
the QDE:  (UNREACHABLE-VALUES (AMT 0))."))