;;; -*- Syntax: Common-lisp; Package: QSIM -*-
(in-package :qsim)

; These examples show how the hierarchical qspaces work, to filter ambiguity
; in the relation among landmarks in different qspaces.

; Simple test example;

(define-QDE FUSES
  (text "Two fuses in series")
  (quantity-spaces
    (I1  (minf 0 Imax1 inf))
    (I2  (minf 0 Imax2 inf))
    (up  (minf 0 up* inf)))
  (constraints
    ((d/dt I1 up))
    ((d/dt I2 up))
    ((= I1 I2))				; Here is the new one!
    ((constant up)))
  (transitions
    ((I1 (Imax1 inc)) -> t)
    ((I2 (Imax2 inc)) -> t))
  (layout (I1 I2 nil)
	  (nil up nil)
	  (nil nil nil))
  (other
    (qspace-hierarchy
      ((I1 I2) -> (*seq minf 0 Imax1 Imax2 inf)))
    ))

(defun test-fuses ()
  (let ((s (make-new-state :from-qde fuses
			   :assert-values '((I1 (0 nil))
					    (I2 (0 nil))
					    (up (up* std)))
			   :text "Increase I1 and I2 to max")))
    (qsim s)
    (qsim-display s)))



(define-QDE FUSES2
  (text "Two fuses in series, unrelated qspaces")
  (quantity-spaces
    (I1  (minf 0 Imax1 inf))
    (I2  (minf 0 Imax2 inf))
    (up  (minf 0 up* inf)))
  (constraints
    ((d/dt I1 up))
    ((d/dt I2 up))
;;;    ((= I1 I2))				; Here is the new one!
    ((constant up)))
  (transitions
    ((I1 (Imax1 inc)) -> t)
    ((I2 (Imax2 inc)) -> t))
  (layout (I1 I2 nil)
	  (nil up nil)
	  (nil nil nil))
  (other
    (qspace-hierarchy
      ((I1 I2) -> (*seq minf 0 Imax1 Imax2 inf)))
    ))

(defun test-fuses2 ()
  (let ((s (make-new-state :from-qde fuses2
			   :assert-values '((I1 (0 nil))
					    (I2 (0 nil))
					    (up (up* std)))
			   :text "Increase I1 and I2 to max")))
    (qsim s)
    (qsim-display s)))
