;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package 'QSIM)

;       Copyright (c) 1987, Benjamin Kuipers.

; Abstraction properties:
;   faster:             set of mechanisms
;   slower:             set of mechanisms
;   abstracted-from:    alist of (constraint mechanism)
;   abstracted-to:      set of (constraint corr-vals assumptions)

;   PROBLEM:  Water balance could not include the NFNPU and CNU
;   parameters, since the constant-normal assumption in WB conflicted
;   with the abnormal conclusion of propagation in SB when the
;   implication of the fast mechanism was propagated to the slow one.

; Knowledge structure note: 
;  There was a conflict between Water-Balance and Starling, in which WB
; implicitly assumed that unmentioned parameters like WI and ECW are
; constant.   In fact, WI is constant and ECW varies with AFP.  In
; Starling, the situation is different:  AFP and WI both vary, but ECW
; is constant, providing a mass-conservation constraint.  The different
; assumptions about the role of unmentioned parameters prevented the two
; structures from communicating adequately, until both were modified to
; include AFP + WI = ECW.  (We will need ECW + ICW = TBW sometime.)

; Adding WI = M+(AFP) to abstract the effect of faster Starling equilibrium.

(define-QDE WATER-BALANCE
  (text "Water balance via ADH (naked qspace)")
  (quantity-spaces
    (afp   (0 inf))
    (ecw   (0 inf))
    (wi    (0 inf))
    (anp   (0 inf))
    (nfwip (0 inf))
    (cnh   (0 inf))
    (ffwpu (minf 0 inf))
    (cnp   (0 inf))
    (cadh  (0 inf))
    (rfup  (0 inf))
    (nfpu  (0 inf))
    (nfwop (minf 0 inf))
    )
  (constraints
    ((M+ AFP WI)             (0 0)  (inf inf))
    ((M+ AFP CNH)            (0 0)  (inf inf))
    ((M+ CNH FFWPU)          (0 0)  (inf inf))
    ((mult AFP CNP ANP)      )
    ((add afp wi ecw))
    ((add RFUP NFPU FFWPU)   )
    ((M+ CNP CADH)           (0 0)  (inf inf))
    ((M+ CADH RFUP)          (0 0)  (inf inf))
    ((d/dt AFP NFWOP))
    ((add NFPU NFWOP NFWIP)  )
    )
  (independent nfwip anp)
  (history afp)
  (layout
    (AFP CNP ANP)
    (wi CNH CADH)
    (ecw FFWPU RFUP)
    (NFWIP NFPU NFWOP))
  (print-names
    (AFP    "amt(water,P)")
    (WI     "amt(water,I)")
    (ECW    "extra-cellular water")
    (CNH    "c(natriuretic-hormones,P)")
    (FFWPU  "flow(water,P->U)")
    (ANP    "amt(Na,P)")
    (CNP    "c(Na,P)")
    (CADH   "c(ADH,P)")
    (RFUP   "reabs.flow(water,U->P)")
    (NFPU   "net flow(water,P->U)")
    (NFWIP  "net flow(water,in->P)")
    (NFWOP  "net flow(water,out->P)"))
  (other
    (unreachable-values (nfpu 0))		; reabsorption cannot be total
    (normal-state nil)
    (slower sodium-balance-naked
	    )
    (faster starling-naked)
    (abstracted-from ((m+ afp wi) starling-naked))
    (abstracted-to ((m+ anp afp))))    
  )


(define-QDE SODIUM-BALANCE
  (text "Sodium balance via aldosterone (naked qspaces)")
  (quantity-spaces
    (anp   (0 inf))
    (afp   (0 inf))
    (cnh   (0 inf))
    (ffnpu (0 inf))
    (caldo (0 inf))
    (rfnup (0 inf))
    (nfnpu (0 inf))
    (nfnip (0 inf))
    (nfnp  (minf 0 inf)))
  (constraints
    ((M+ ANP AFP)              (0 0) (inf inf))
    ((M+ AFP CNH)              (0 0) (inf inf))
    ((M+ CNH FFNPU)            (0 0) (inf inf))
    ((M- AFP CALDO)            (0 inf) (inf 0) )
    ((M+ CALDO RFNUP)          (0 0) (inf inf))
    ((add RFNUP NFNPU FFNPU)   )
    ((add NFNPU NFNP NFNIP)    )
    ((d/dt ANP NFNP)))
  (independent nfnip)
  (history anp)
  (layout
    (ANP AFP)
    (CNH CALDO)
    (FFNPU RFNUP)
    (NFNIP NFNPU NFNP))
  (print-names
    (anp   "amt(Na,P)")
    (afp   "amt(water,P)")
    (cnh   "c(natriuretic-hormones,P)")
    (Ffnpu "flow(Na,P->U)")
    (caldo "c(aldosterone,P)")
    (rfnup "reabs.flow(Na,U->P)")
    (nfnpu "net flow(Na,P->U)")
    (nfnip "net flow(Na,in->P)")
    (nfnp  "net change(Na,P)"))
  (other
    (unreachable-values (nfnpu 0)		; reabsorption cannot be total
			(anp 0 inf))
    (normal-state nil)
    (faster water-balance-naked)
    (abstracted-from
      ((m+ anp afp) water-balance-naked))))

(Define-QDE Starling
  (text "The Starling equilibrium between plasma and interstitial compartments")
  (quantity-spaces
    (PP     (0 inf))
    (PI     (0 inf))
    (AFP    (0 inf))
    (WI     (0 inf))
    (ECW    (0 inf))
    (CPP    (0 inf))
    (CPI    (0 inf))
    (HPP    (0 inf))
    (HPI    (0 inf))
    (OPI    (0 inf))
    (OPP    (0 inf))
    (HPPI   (0 inf))
    (OPIP   (0 inf))
    (FWPI   (minf 0 inf))
    (FWIP   (minf 0 inf))
    (NFPI   (minf 0 inf))
    (MNFPI  (minf 0 inf)))
  (constraints
    ((MULT WI CPI PI)        )
    ((MULT AFP CPP PP)        )
    ((ADD AFP WI ECW))
    ((M+ AFP HPP)               (0 0) (inf inf))
    ((M+ WI HPI)                (0 0) (inf inf))
    ((M+ CPP OPI)               (0 0) (inf inf))
    ((M+ CPI OPP)               (0 0) (inf inf))
    ((M+ HPPI FWPI)             (0 0) (inf inf))
    ((M+ OPIP FWIP)             (0 0) (inf inf))
    ((ADD HPI HPPI HPP))
    ((ADD OPP OPIP OPI))
    ((ADD FWIP NFPI FWPI))
    ((D/DT AFP MNFPI))
    ((D/DT WI NFPI))
    ((MINUS NFPI MNFPI)         (0 0) (inf minf) (minf inf)))
  (independent pp pi ecw)
  (history afp)
  (print-names
    (PP "amt(protein,P)")
    (PI "amt(protein,I)")
    (AFP "amt(water,P)")
    (WI "amt(water,I)")
    (ECW "extra-cellular water")
    (CPP "c(protein,P)")
    (CPI "c(protein,I)")
    (HPP "HP(water,P->I)")
    (HPI "HP(water,I->P)")
    (OPI "OncP(water,I->P)")
    (OPP "OncP(water,P->I)")
    (HPPI "net HP(water,P->I)")
    (OPIP "net OncP(water,I->P)")
    (FWPI "flow(water,P->I)")
    (FWIP "flow(water,I->P)")
    (NFPI "net flow(water,P->I)")
    (MNFPI "-NFPI"))
  (layout (ecw nil pp pi)
	  (afp wi  cpp cpi)
	  (hpp hpi opi opp)
	  (nil hppi opip nil)
	  (nfpi fwpi fwip nil))
  (other
    (define-normal ((pp ((0 inf) std)) (pi ((0 inf) std)) 
		    (afp ((0 inf) std)) (wi ((0 inf) std)) (ecw ((0 inf) std))
		    (hppi ((0 inf) std)) (opip ((0 inf) std))))
    (normal-state nil)
    (unreachable-values (opip 0)
			(fwip 0))
    (slower water-balance-naked)
    (abstracted-from))
)

; PROBLEM:  still branch on the possibility that OPIP = FWIP = 0.


; Tanaka heart regulation model, for Q.

(define-QDE HEART-REGULATION
 (text "Heart model homeostasis via sympathetic stimulation (H.Tanaka)")
  (quantity-spaces
    (SS    (0 INF))
    (AB    (0 INF))
    (AS    (0 INF))
    (BB    (0 INF))
    (BS    (0 INF))
    (PL    (0 INF))
    (PLA   (0 INF))
    (BV    (0 INF))
    (SC    (0 INF))
    (HR    (0 INF))
    (HRA   (0 INF))
    (HRX   (0 INF))
    (SV    (0 INF))
    (CO    (0 INF))
    (PVR   (0 INF))
    (PVRA  (0 INF))
    (PVRX  (0 INF))
    (MSFP  (0 INF))
    (MSP   (0 INF))
    (MDP   (0 INF))
    (DSS   (MINF 0 INF))
    (EDV   (0 INF))
    (EF    (0 INF))
    (IN    (0 INF))
    (INA   (0 INF))
    (INB   (0 INF))
    (INC   (0 INF))
    (INX   (0 INF)))
  (constraints
    ((ADD SS AB AS)      )
    ((ADD SS BB BS)      )
    ((M+ PLA AS)                    (0 0) (inf inf))
    ((MULT MSFP SC BV)   )
    ((ADD BV PLA PL)     )
    ((M+ HRA BS)                    (0 0) (inf inf))
    ((ADD HRA HRX HR)    )
    ((M+ PVRA AS)                   (0 0) (inf inf))
    ((ADD PVRA PVRX PVR) )
    ((M+ EDV PL)                    (0 0) (inf inf))
    ((M+ INA EDV)                   (0 0) (inf inf))
    ((M+ INC BS)                    (0 0) (inf inf))
    ((ADD INC INX INB)   )
    ((ADD INA INB IN)    )
    ((M+ EF IN)                     (0 0) (inf inf))
    ((MULT EDV EF SV)    )
    ((MULT HR SV CO)     )
    ((MULT CO PVR MDP)   )
    ((ADD MDP MSFP MSP)  )
    ((M- MDP DSS)                   (0 inf)  (inf minf))
    ((D/DT SS DSS)) )
  (independent ab bb sc bv inx hrx pvrx)
  (history ss)
 (layout
   (SS AB AS BB BS)
   (SC BV nil INX IN)
   (BV  nil PL EDV EF)	
   (HRX  nil HR SV CO)
   (SC nil PVRX PVR)
   (MSFP MDP MSP DSS))
 (print-names
   (SS "sympathetic stimulation")
   (AB "alpha stimulation base")
   (AS "alpha stimulation")
   (BB "beta stimulation base")
   (BS "beta stimulation")
   (PL "preload")
   (BV "blood volume")
   (SC "systemic compliance")
   (PLa "preload(alpha)")
   (HR "heart rate")
   (HRa "heart rate(beta)")
   (HRx "heart rate(other)")
   (SV "stroke volume")
   (CO "cardiac output")
   (PVR "peripheral vascular resistance")
   (PVRa "PVR(alpha)")
   (PVRx "PVR(other)")
   (MSFP "mean syst. filling pressure")
   (MDP "mean dynamic pressure")
   (MSP "mean systemic pressure")
   (DSS "derivative(symp.stim.)")
   (EDV "end diastolic volume")
   (EF "ejection fraction")
   (IN "inotropic state")
   (INa "inotropic(preload)")
   (INb "inotropic(partial sum)")
   (INc "inotropic(beta)")
   (INx "inotropic(other)"))
 (other
   (normal-state nil)
   (unreachable-values (ss 0))))