;;; -*- Mode:Common-Lisp; Package:QSIM; Base:10 -*-

(in-package :qsim) ;changed DJC

;;;*****************************************************************************
;;;				  S P R I N G S, again...
;;;*****************************************************************************

;;;-----------------------------------------------------------------------------
;;; The simple spring-block system
;;;-----------------------------------------------------------------------------

(define-QDE Spring1
   (text "Simple spring.")
   (quantity-spaces
     (x  (minf 0 inf))
     (v  (minf 0 inf))
     (a  (minf 0 inf)))
   (constraints
     ((d/dt x v))
     ((d/dt v a))
     ((M- a x)   (0 0) (minf inf) (inf minf)))
   (layout (x v a) nil nil))
   
(defun ss1 ( )
  (qsim-cleanup)
  (qsim-display (envision :qde spring1
			  :values '((x ((0 inf) std))))))


;;;-----------------------------------------------------------------------------
;;; Introducing an initial landmark
;;;-----------------------------------------------------------------------------

(define-QDE Spring2
   (text "Simple spring.")
   (quantity-spaces
     (x   (minf 0 x0 inf))
     (v   (minf 0 inf))
     (a   (minf 0 inf)))
   (constraints
     ((d/dt x v))
     ((d/dt v a))
     ((m- a x)   (0 0) (minf inf) (inf minf)))
   (layout (x v a) nil nil))

(defun ss2 ( )
  (qsim-cleanup)
  (qsim-display (envision :qde spring2
			  :values '((x (x0 std))))))


;;;-----------------------------------------------------------------------------
;;; The Damped Spring
;;;-----------------------------------------------------------------------------

(define-QDE Spring3
  (quantity-spaces
    (x     (minf 0 inf))
    (v     (minf 0 inf))
    (a     (minf 0 inf))
    (ff    (minf 0 inf))
    (fs    (minf 0 inf)))
  (constraints
    ((d/dt x v))
    ((d/dt v a))
    ((m- x fs)    (0 0)  (minf inf)  (inf minf))
    ((m- v ff)    (0 0)  (minf inf)  (inf minf))
    ((add fs ff a)))
  (layout  (x fs )
	   (v ff)
	   (a)))

(defun sf1()
  (qsim-cleanup)
  (qsim-display (envision :qde spring3
			  :values
			  '((x ((0 inf) std)))
			  :sim (make-sim :state-limit 100))))

(define-QDE Spring4
  (quantity-spaces
    (x     (minf 0 x0 inf))
    (v     (minf 0 inf))
    (a     (minf 0 inf))
    (ff    (minf 0 inf))
    (fs    (minf 0 inf)))
  (constraints
    ((d/dt x v))
    ((d/dt v a))
    ((m- x fs)    (0 0)  (minf inf)  (inf minf))
    ((m- v ff)    (0 0)  (minf inf)  (inf minf))
    ((add fs ff a)))
  (layout  (x fs )
	   (v ff)
	   (a)))

(defun sf2()
  (qsim-cleanup)
  (qsim-display (envision :qde spring4
			  :values
			  '((x (x0 std)))
			  :sim (make-sim :state-limit 100))))

(defun sf3()
  (qsim-cleanup)
  (qsim-display (envision :qde spring3
			  :values
			  '((x ((0 inf) std)))
			  :sim (make-sim :state-limit 100
					 :hod-constraints t))))
