;;; -*- Syntax: Common-lisp; Package: qsim -*-
(in-package :qsim)

;;; This problem exercises code in PROPAGATE-MULT-CV-TUPLE that is not invoked by
;;; any other example.  PROPAGATE-MULT-CV-TUPLE has a COND clause that splits on
;;; whether (landmark-lt *zero-lmark* landmark).  This example runs the 3rd
;;; clause, ie, the condition where  (landmark-lt landmark *zero-lmark*).

(define-QDE rock
  (text  "Rock in gravity field")
  (quantity-spaces
    (force (minf weight 0))
    (mass (0 m* inf))
    (r   (minf 0 ground inf))
    (v   (minf 0 inf))
    (a   (minf g 0)))
  (constraints
    ((d/dt v a))
    ((d/dt r v))
    ((M+ r force)(0 minf)(ground weight)(inf 0))
    ((mult mass a force)(m* g weight)))
  (independent mass)
  (transitions
    ((r (ground dec)) t))
  (layout (force mass)
	  (r v)
	  (a nil)))

;;; QSIM will conclude that Force is between (weight 0), from the cv's (M+ r
;;; force) relationship.  Then it will conclude that a is between (g 0) from the
;;; cv's of (mult mass a force).  That conclusion exercises the target code.

(defun drop-rock ()
  (format *qsim-report* "This problem exercises code in PROPAGATE-MULT-CV-TUPLE that is not invoked by~&~
                any other example.  PROPAGATE-MULT-CV-TUPLE has a COND clause that splits on~&~
                whether (landmark-lt *zero-lmark* landmark).  This example runs the 3rd~&~
                clause, ie, the condition where  (landmark-lt landmark *zero-lmark*).")
  (let ((initial
	  (make-initial-state rock
			      '((r  ((ground inf) nil))
				(v  (0 nil))
				(mass (m* std)))
			      "Rock dropped from height")))	
    (qsim initial)
    (qsim-display initial)
    ))
