;;; -*- Syntax: Common-Lisp; Package: QSIM -*-
(in-package :qsim)
;;; Copyright (c) 1991, Benjamin Kuipers.

;;;
;;;      One-compartment "bathtub":  ->[]->
;;;

(define-component Bathtub hydraulic "One-compartment system"
  (components (C0  source)
	      (f01 QPump)
	      (C1  compartment)
	      (f12 arrow)
	      (C2  sink))
  (connections (n0 (C0 out)  (f01 in))
	       (n1 (f01 out) (C1 in))
	       (n2 (C1 out)  (f12 in))
	       (n3 (f12 out) (C2 in))
	       ))



(defun test-bathtub ()
  (setq qde (build-qde 'bathtub))
  (let* ((sim  (make-sim :HOD-constraints nil
			 :Q2-constraints nil))
	 (init (make-CC-state :from-qde qde
			      :sim sim
			      :assert-values '(((C1 amount)  (0 nil))
					       ((F01 Q)      ((0 inf) std))
					       ((F12 K)      ((0 inf) std))
					       )
			      :text "Fill an empty bathtub"))
	 (cc-layout '(( (n2 effort)  nil      nil )
		      ( (F01 Q)      (F12 K))
		      ( (F12 Q)  )
		      nil)))
    (qsim init)			
    (CC-display init :layout CC-layout)
    ))

;;; Note that (F12 K) need not be initialized.  Its value is in the component def.


(defun test-bathtub+Q2 ()
  (setq qde (build-qde 'bathtub))
  (let* ((sim  (make-sim :HOD-constraints nil
			 :Q2-constraints t))
	 (init (make-CC-state :from-qde qde
			      :sim sim
			      :assert-values '(((N2 effort)  (0 nil))
					       ((F01 Q)      (Q* std))
					       )
			      :assert-ranges '((((f01 Q) Q*)       (1 2))
					       (((f12 k) k*)       (3 4))
					       ((Time    t0)       (0 0)))
			      :text "Fill an empty bathtub"))
	 (cc-layout '(( (n2 effort)  nil      nil )
		      ( (F01 Q)      (F12 K))
		      ( (F12 Q)  )
		      nil)))
    (qsim init)			
    (CC-display init ; :layout CC-layout
		)
    ))

;;; Grump:  The (<var> (AT t0)) syntax for Q2 has been disabled!
;;;    Therefore, I had to put a landmark Q* into QPump that I didn't want to.

;;; Grump:  I had to hack make-CC-state to check for the symbol TIME in :assert-ranges.
;;;    Really CC-name and the name-tree should handle it.
