;;;  -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

; 1. Simple spring. 

(define-QDE spring
  (text "Simple spring")
  (quantity-spaces
    (x     (minf 0 inf))
    (v     (minf 0 inf))
    (a     (minf 0 inf)))
  (constraints
    ((d/dt x v))
    ((d/dt v a))
    ((m- x a)      (0 0)     (minf inf)  (inf minf)))
  (layout  (nil x  nil)
	   (nil v  nil)
	   (nil a  nil)))


(defun release-spring ()
  (let* ((sim (make-sim :HOD-constraints nil))
	 (initial
	   (make-new-state :from-qde spring
			   :assert-values '((x ((0 inf) std))
					    (v (0 nil)))
			   :sim sim)))
    (qsim initial)
    (qsim-display initial)))

; 2. Simple spring with auto-curvature constraints.  

(defun release-spring-acc ()
  (let* ((sim (make-sim :HOD-constraints t))
	 (initial
	   (make-new-state :from-qde spring
			   :assert-values '((x ((0 inf) std))
					    (v (0 nil)))
			   :sim sim)))
    (qsim initial)
    (qsim-display initial)))


; 2. Spring with friction. (From pearl:>q>springs.lisp for comparison with auto-cc below)

(define-QDE spring-with-friction
  (text "Spring with friction")
  (quantity-spaces
    (x     (minf 0 inf))
    (v     (minf 0 inf))
    (a     (minf 0 inf))
    (ff    (minf 0 inf))
    (fs    (minf 0 inf))
    (f     (minf 0 inf)))
  (constraints
    ((d/dt x v))
    ((d/dt v a))
    ((m- x fs)      (0 0)     (minf inf)  (inf minf))
    ((m- v ff)      (0 0)     (minf inf)  (inf minf))
    ((add fs ff f))
    ((m+ f a)       (0 0)     (inf inf)   (minf minf)))
  (layout  (x fs nil)
	   (v ff nil)
	   (a f nil)
	   (nil nil nil)))

(defun release-spring-w-friction ()
  (let* ((sim (make-sim :HOD-constraints nil))
	 (initial
	   (make-new-state :from-qde spring-with-friction
			   :assert-values '((x ((0 inf) std))
					    (v (0 nil)))
			   :sim sim)))
    (qsim initial)
    (qsim-display initial)))

(defun release-spring-w-friction-acc ()
  (setf (qde-derived-sd2-expressions spring-with-friction) nil)
  (let* ((sim (make-sim :HOD-constraints t))
	 (initial
	   (make-new-state :from-qde spring-with-friction
			   :assert-values '((x ((0 inf) std))
					    (v (0 nil)))
			   :sim sim)))
    (qsim initial)
    (qsim-display initial)))
