;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package 'QSIM)

(defparameter Q-Features nil)

(or (member 'Q-Features *available-catalogs*)
    (nconc *available-catalogs* (list 'Q-Features)))

(add-to-catalog
  'Q-Features
  '(Occurrence-Branch-Elim
     ("occ-branch-elim")
     nil
     ((brief-description nil (describe-occ-branch))
      (triple-tube nil (fill-trip-tube))
      (4-reactions nil (batch-a->b->c->d->e-short 1200)))))

(add-to-catalog
  'Q-Features
  '(Non-Intersection-Constraint
     ("nic-examples")
     nil
     ((brief-description nil (describe-nic))
      (simple-spring-w-tracing nil (simple-spring-w-tracing))
      (simple-spring-w-o-tracing nil (simple-spring-w-o-tracing))
      (damped-spring-w-o-init-lmk nil (damped-spring-w-o-init-lmk))
      (damped-spring-w-init-lmk nil (damped-spring-w-init-lmk)))))

(add-to-catalog
  'Q-Features
  '(Ignore-Qvals
     ("ignore-qvals-example")
     nil
     ((brief-description nil (describe-ign-qval))
      (bad-heaters-w-o-ign-qval nil (bad-heaters-w-o-ign-qval))
      (bad-heaters-w-ign-qval nil (bad-heaters-w-ign-qval)))))

(add-to-catalog
  'Q-Features
  '(Operating-Region-Transition
     ("region-transition")
     nil
     ((brief-description nil (describe-region-trans))
      (home-heater nil (home-heater))
      (toaster nil (toaster))
      )))

(add-to-catalog
  'Q-Features
  '(Ignore-Qdirs
     ("ignore-qdirs")
     nil
     ((brief-description nil (describe-ignore-qdirs))
      )))

(add-to-catalog
  'Q-Features
  '(Curvature-Constraints
     ("curvature-constraints")
     nil
     ((brief-description nil (describe-curvature-constraints))
      )))

(add-to-catalog
  'Q-Features
  '(Analytic-Function
     ("analytic-function")
     nil
     ((brief-description nil (describe-analytic-function))
      )))

(add-to-catalog
  'Q-Features
  '(Unreachable-Landmarks
     ("unreachable-landmarks")
     nil
     ((brief-descriptions nil (describe-unreachable-landmarks))
      )))

(add-to-catalog
  'Q-Features
  '(|Kinetic Energy Constraint|
     ("ket-derived")
     nil
     ((|Brief description| nil (describe-egf))
      
      (|Gravity, traced| nil (gravity-w-tracing))
      (|Gravity with friction, traced, with analytic functions| nil (gravity-w-friction-n-tracing-n-af))
      (|Gravity with friction, traced| nil (gravity-w-friction-n-tracing))
      
      (|Bouncing ball with friction, traced| nil (bb-w-friction-n-tracing))
      (|Bouncing ball with friction| nil (bb-w-friction))

      
      (|Simple spring, traced| nil (simple-spring-w-tracing-))
      (|Simple spring| nil (simple-spring))
      
      (|Damped spring, traced| nil (damped-spring-w-tracing))
      (|Damped spring| nil (damped-spring)))))

(add-to-catalog 'q-features
   '(Versiplot
      ("versiplot-examples")
      nil
      (("Versiplot Bathtub" nil (versiplot-bathtub ))
       ("Extra width and height" nil (5box))
       ("Offsetting plots" nil (5offbox))
       ("Phase Planes - Chattering Tanks" nil (tank-chatter-phase-plane)))))


