/*
 *  CQ -- main program
 */

#include  <stdio.h>
#include  "defs.h"
/* Note: all other files except this one must say "#define EXTERN extern" */
#define   EXTERN
#include  "global.h"
#include  "io.h"

struct state *remagenda();
long clock();

#ifndef ATTUNIX
#include  <sys/time.h>
#include  <sys/resource.h>

static long  last = 0L;

long
clock()
{
    long  now, diff;
    struct rusage  rusage;

    getrusage( 0, &rusage );
    now = rusage.ru_utime.tv_usec + rusage.ru_stime.tv_usec;
    diff = now - last;
    last = now;
    return(diff);
}
#endif


main( argc, argv )
int  argc;		/* number of command arguments   */
char *argv[];		/* pointers to command arguments */
{
    register int  i;
    char  c, *cp;
    long  millisecs;
    int   root;


    /* Do initialization */
    modified = FALSE;  /* no modified state (yet) */
    nparams = nconstraints = nstates = trace = root = 0;
    curtime = -1;

    symp    = &symspace[0];
    sympmax = &symspace[MAXSYMCHARS];
    qsp     = &qspace[0];
    qspmax  = &qspace[MAXQSPACES];
    pvp     = &pval[0];
    pvpmax  = &pval[MAXPVALS];
    qvp     = &qval[0];
    qvpmax  = &qval[MAXQVALS];
    crp     = &corr[0];
    crpmax  = &corr[MAXCORR];
    scrp    = &scorr[0];
    scrpmax = &scorr[MAXSCORR];
    tup     = &tuple[0];
    tupmax  = &tuple[MAXTUPLES];
    lmp     = &lmark[0];
    lmpmax  = &lmark[MAXLMARKS];
    stp     = &state[0];
    stpmax  = &state[MAXSTATES];

    pvphigh = (struct pval *)  0;
    tuphigh = (struct tuple *) 0;

    if (argc < 2)
    {
	usage(argv);
	exit(1);
    }
    i = 1;
    while (argv[i][0] == '-')
    {
	/*  Decode the optional trace argument.  */
	cp = &argv[i][1];
	while (c = *cp++)
	{
	    switch (c)
	    {
	    case 'i':	trace |= TR_IVALS;	break;
	    case 'p':	trace |= TR_PVALS;	break;
	    case 'c':	trace |= TR_CVALS;	break;
	    case 't':	trace |= TR_TUPLES;	break;
	    case 'w':	trace |= TR_WALTZ;	break;
	    case 's':	trace |= TR_STATES;	break;
	    case 'l':	trace |= TR_LANDMARKS;	break;
	    case 'a':	trace |= TR_IVALS | TR_PVALS | TR_CVALS | TR_TUPLES |
				 TR_WALTZ | TR_STATES | TR_LANDMARKS;	break;
	    case 'd':	trace |= TR_DIVERGENT;	break;
	    case 'q':	trace |= TR_QUIESCENT;	break;
	    case 'x':	trace |= TR_EXEC;	break;
	    default:    printf("Unknown option '%c' ignored\n", c);
	    }
	}
	i++;
    }

    if ((argc <= i) || (argc > (i+1)))  usage(argv);

    /* Read in constraint model */
    mopen(argv[i]);
    xform();
    mkinitstate();
    
    xform();
    if (modified)
    {
	root = 1;
	mkmodstate();
    }

#ifdef TRACE
    if (trace & TR_STATES)
    {   puts("Starting state:\n");
	prstate(&state[root]);
    }
#endif
	

    /* Start execution timing */
    clock();

    /*  Main simulation loop.  */
    while ((curstatep = remagenda()) != ((struct state *) 0))
    {

#ifdef TRACE
    if (trace & TR_STATES)
    {   printf("Predicting from state %d:\n", curstatep - &state[0]);
    }
#endif
	/*  Global curstatep points to state to do prediction from  */
	curtime = curstatep->time;
	genpvals();
	cfilter();
    }

    /*  Record elapsed time. */
    millisecs = clock() / 1000L;

    /*  Print out results as a state graph */
    for (i = root;  i < nstates;  i++)
	prstate(&state[i]);

    /*  Print out execution statistics  */
    if (trace & TR_EXEC)
    {
	printf("Simulator running time = %ld milliseconds\n", millisecs);
	puts(  " Used   Max.");
	printf("%5d %5d  states\n", nstates, MAXSTATES);
	printf("%5d %5d  parameters\n", nparams, MAXPARAMS);
	printf("%5d %5d  constraints\n", nparams, MAXCONSTRAINTS);
	printf("%5d %5d  symbols\n", nsymbols, MAXSYMBOLS);
	printf("%5d %5d  symbol characters\n",symp - &symspace[0],MAXSYMCHARS);
	printf("%5d %5d  pval elements\n", pvphigh - &pval[0], MAXPVALS);
	printf("%5d %5d  qval elements\n", qvp - &qval[0], MAXQVALS);
	printf("%5d %5d  tuples\n", tuphigh - &tuple[0], MAXTUPLES);
	printf("%5d %5d  qspace elements\n", qsp - &qspace[0], MAXQSPACES);
	printf("%5d %5d  landmark elements\n", lmp - &lmark[0], MAXLMARKS);
    }
    exit(0);
}


/*
 *  'usage' prints out the UNIX-style command-line synopsis
 */
usage(argv)
char *argv[];
{
    printf("Usage:  %s  [options]  model_file\n", argv[0]);
#ifdef TRACE
    puts("    -i   trace creation of initial values");
    puts("    -p   trace creation of possible values");
    puts("    -c   trace creation of corresponding values");
    puts("    -t   trace creation of tuples");
    puts("    -w   trace Waltz filtering of tuples");
    puts("    -s   trace creation of new states");
    puts("    -l   trace creation of new landmarks");
    puts("    -a   turn on all of the above trace flags");
#endif
    puts("    -d   allow prediction from divergent states");
    puts("    -q   allow prediction from quiescent states");
    puts("    -x   print execution statistics summary");
}  


/*
 *  "make initial state" routine.
 */
mkinitstate()
{
    register int  i;
    register struct param  *p;
    register struct constraint  *conp;
    register struct scorr  *scorrp;
    register struct qval  *qvalp;

    /*  Form a single consistent initial state */
    curstatep = (struct state *) 0;
    genivals();
    cfilter();

    if (nstates == 0)
    {
	puts("No consistent completions from initial values.\n");
	prpvals();
	exit(1);
    }
    if (nstates > 1)
    {
	puts("Error: initial values are under-specified.\n");
	printf("%d completions from initial values.\n", nstates);
	for (i = 0;  i < nstates;  i++)
	    prstate(&state[i]);
	exit(1);
    }

    /*  Now prepare for and read "make-modified-state" if it is present  */

    /*  For each parameter install state 0's qmag, qdir, and qspace.  */
    for (i = 0, qvalp = state[0].qvalp;  i < nparams;  i++, qvalp++)
    {
	p = &param[i];
	p->qspacep = qvalp->qspacep;
	p->qmagx   = NOTSPECIFIED;
	p->qdir    = NOTSPECIFIED;
    }

    /*  Install the possibly modified correspondences  */
    for (i = 0, scorrp = state[0].scorrp;  i < nconstraints;  i++, scorrp++)
    {
	conp = &constraint[i];
	conp->ncorrs = scorrp->ncorrs;
	conp->corrp  = scorrp->corrp;
/*
  printf("mkinitstate: existing correspondences are:\n");
  pracorr(conp);
*/
    }
}


/*
 *  "make modified state" routine.
 */
mkmodstate()
{
    register int  i;

    /*  Remove initial state from agenda since we are not starting there */
    remagenda();

    /*  Form a single consistent modified state */
    curstatep = (struct state *) 0;
    genivals();
    cfilter();

    if (nstates == 1)
    {
	puts("No consistent completions from modified values.\n");
	prpvals();
	exit(1);
    }
    if (nstates > 2)
    {
	puts("Error: modified values are under-specified.\n");
	printf("%d completions from modified values.\n", nstates-1);
	for (i = 1;  i < nstates;  i++)
    	prstate(&state[i]);
	exit(1);
    }
}
