#include  <stdio.h>
#include  "defs.h"
#define   EXTERN  extern
#include  "global.h"

/*
 *  'setpvals' fills in 1 or 3 pval's depending on whether the qdir is
 *  specified or not.  This is a macro rather than a function for reasons
 *  of speed.  The macro is used in two different places in genivals().
 */
#define  setpvals(X)  	pvp->used = pvp->bad = FALSE;		\
			pvp->ncons = 0;				\
			pvp->qmagx = X;				\
			if (qdir_specified)			\
			    (pvp++)->qdir = p->qdir;		\
			else					\
			{					\
			    (pvp++)->qdir = INC;		\
			    pvp->used = pvp->bad = FALSE;	\
			    pvp->ncons = 0;			\
			    pvp->qmagx    = X;			\
			    (pvp++)->qdir = STD;		\
			    pvp->used = pvp->bad = FALSE;	\
			    pvp->ncons = 0;			\
			    pvp->qmagx    = X;			\
			    (pvp++)->qdir = DEC;		\
			}

/*
 *  'genivals' generates all possible initial values given the perhaps
 *  incompletely specified initial values from the model input file,
 *  which are stored in struct param, items qmagx and qdir.
 */
genivals()
{
    register int  i, j;
    register struct param  *p;
    int  nqmags, n;
    Boolean  qdir_specified;

    pvp = &pval[0];

    /*  Loop over each parameter and generate its possible initial values. */
    for (i = 0;  i < nparams;  i++)
    {
	p = &param[i];
	p->npvals = 0;
	p->pvalp = pvp;
	qdir_specified = (p->qdir == NOTSPECIFIED) ? FALSE : TRUE;
	if (p->qmagx == NOTSPECIFIED)
	{
	    /*  Since qmag is not specified, we must generate all possible
	     *  values.  For example, if the qspace has 3 landmarks then
	     *  there are 5 possible values (0, 1, 2, 3, 4), where 0, 2, and
	     *  4 correspond to the landmarks and 1 and 3 to the intervals
	     *  between them.
	     */
	    nqmags = 2 * p->qspacep->nlmarks - 1;
	    for (j = 0;  j < nqmags;  j++)
	    {
		setpvals(j);
	    }
	    p->npvals = qdir_specified ? nqmags : 3*nqmags;
	}
	else
	{
	    switch( p->range )
	    {
	    case STD:
		/*  qmag is specified exactly (not a range)  */
		setpvals(p->qmagx);
		p->npvals = qdir_specified ? 1 : 3;
		break;

	    case INC:
		/*  qmag specifies a range from qmagx to high end of qspace  */
		nqmags = 2 * p->qspacep->nlmarks - 1;
		for (j = p->qmagx;  j < nqmags;  j++)
		{
		    setpvals(j);
		}
		n = nqmags - p->qmagx;
		p->npvals = qdir_specified ? n : 3*n;
		break;

	    case DEC:
		/*  qmag specifies a range from low end of qspace to qmagx  */
		for (j = 0;  j <= p->qmagx;  j++)
		{
		    setpvals(j);
		}
		n = p->qmagx + 1;
		p->npvals = qdir_specified ? n : 3*n;
		break;

	    default:
		puts("genivals: range not STD, INC, or DEC");
		exit(1);
	    }
	}
    }

    if (pvp > pvpmax)
    {   printf("Exceeded limit of %d pvals\n", MAXPVALS);
	abort();
    }
    else if (pvp > pvphigh)  pvphigh = pvp;	/* (for execution stats) */

#ifdef TRACE
    if (trace & TR_IVALS)
	prpvals();
#endif
}
