;;; -*- Mode:Common-Lisp; Package:MAKE; Base:10 -*-

(in-package 'mk)

;;;  This file is used to customize the Common Lisp defsystem and the
;;;  logical pathname package for our uses of it with QSIM at UT.
;;;  It is designed to contain any additional code which is needed
;;;  or patches to other code.
;;;  Using this file will simplify getting updates to the Common Lisp
;;;  defsystem

(defun get-bin-dir-name ()
  (mk::afs-component (mk::machine-type-translation (machine-type))
		     (mk::software-type-translation (software-type))))

;;; This is needed for the allegro at NASA-Ames.  Maybe others need it too?
;;; Added by BKay 13Nov91
;;;
#+:allegro-v4.0 (mk::machine-type-translation "Sun4" "sun4")

;;;
;;;  This is a re-definition of the Common LIsp Merge-pathnames so that
;;;  it will work with logical pathnames.  The current version of the
;;;  logical-pathname code does not include a redefition of this
;;;  function.
;;;  DJC 09/14/91

(in-package 'lp)

(unless (fboundp 'old-merge-pathnames)
  (setf (symbol-function 'old-merge-pathnames)
	(symbol-function 'lisp::merge-pathnames))
  (defun lisp::merge-pathnames (pathname &optional (defaults nil) (default-version nil))
    (let ((default-pathname (if (logical-pathnamep defaults)
				defaults
				(parse-namestring defaults))))
      (cond ((null pathname)
	     (error "Pathname should not be nil."))
	    ((logical-pathnamep default-pathname)
	     (let* ((new-pathname (logical-pathname pathname))
		    (default-host        (%logical-pathname-host default-pathname))
		    (default-directory   (%logical-pathname-directory default-pathname))
		    (default-name        (%logical-pathname-name default-pathname))
		    (default-type        (%logical-pathname-type default-pathname))
		    (default-version     (if (%logical-pathname-name new-pathname)
					     default-version
					     (%logical-pathname-version default-pathname))))
	       (unless (%logical-pathname-host new-pathname)
		 (setf (%logical-pathname-host new-pathname)
		       default-host))
	       (unless (> (length (%logical-pathname-directory new-pathname)) 1)
		 (setf (%logical-pathname-directory new-pathname)
		       default-directory))
	       (unless (%logical-pathname-name new-pathname)
		 (setf (%logical-pathname-name new-pathname)
		       default-name))
	       (unless (%logical-pathname-type new-pathname)
		 (setf (%logical-pathname-type new-pathname)
		       default-type))
	       (unless (%logical-pathname-version new-pathname)
		 (setf (%logical-pathname-version new-pathname)
		       default-version))
	       new-pathname))
	    (t (old-merge-pathnames pathname defaults default-version))))))


