(in-package :qsim)


(defparameter *treat-abs-qdir-as-ign* t)


;;;  This temporary fix is used to eliminate the need to redefine all
;;;  of the cosntraint check functions.  All abstracted qdirs are
;;;  changed to IGN before cfilter is run.  After cfilter and the
;;;  alist filters are run, then they are changed back.  The only
;;;  problem with this is that the NO-CHANGE-FILTER will not work
;;;  correctly.  Thus, a change has also been added so that the
;;;  NO-CHANGE-FILTER will

(defun successors-of-state (current-state)
  (declare (special Current-State))		; make visible to cfilter, etc.
  (let* ((*current-qde* (state-qde current-state))  ; Now a local def BKay 27May92
	 (old-time (state-time current-state))
	 (new-time (copy-qval old-time))
	 (time-var (car (qde-variables *current-qde*)))
	 (successor-function (if (qpointp old-time)
				 #'P-successors
				 #'I-successors)))
    (declare (special *current-qde*))

    ;; Compute next time value and install it as the only possible value
    ;; for the time variable.
    (setf (qmag new-time) (if (qpointp old-time)
			      (list (qmag old-time) (succ (qmag old-time) (time-qspace current-state)))
			      (cadr (qmag old-time)))
	  (variable--qspace time-var) (time-qspace current-state)
	  (variable--pvals  time-var) (list new-time))

    ;; Do P- or I-successor, setting each variable's possible values,
    ;; plus its qspace.
    (mapc #'(lambda (qvalue qspace-pair)
	      (let* ((qval   (cdr qvalue))
		     (qspace (cdr qspace-pair))
		     (var    (qval-variable qval)))
		(setf (variable--qspace var) qspace
		      (variable--pvals var)
		      (if (or (variable-independent-p var)
			      (variable-discrete-p var))
			  (list qval)
			  (funcall successor-function qval qspace var)
			  ;;(eliminate-unreachable-values     ; removed -> global filter
			  ;;  var
			  ;;  (funcall successor-function qval qspace var))
			  ))))
	  (cdr (state-qvalues current-state))		; skip over time qvalue
	  (cdr (state-qspaces current-state)))		; skip over time qspace
    (install-corresponding-values current-state)
    (filter-pvals-for-explanation current-state)   ; Fitlers the possible values when this
					; function is being called to perform
					; explanation.  DJC  11/25/92

    ;; Run cfilter, then filter the resulting value completions.
    (let* ((vars-abs-qdirs (when *treat-abs-qdir-as-ign*
			     (replace-abs-qdir-w-ign current-state))) ; Added as a termporary fix
	                                                              ; before changing the cons
	   (*filtering-condition* :successors)
	   (candidates (cfilter (state-qde current-state) #'check-qsim-constraint))
	   (alists1 (mapcan #'(lambda (alist)
				(apply-global-alist-filters current-state alist))
			    candidates))
	   (alists (if vars-abs-qdirs
		       (mapcar #'(lambda (cand)
				   (replace-ign-w-abs-qdir cand vars-abs-qdirs))
			       alists1)
		       alists1))
	   )
      (when vars-abs-qdirs (replace-ign-w-abs-qdir current-state vars-abs-qdirs))
      (cond ((null alists)
	     (when (and (not (member 'quiescent (state-status current-state)))     ; mark inconsistent only
			*prune-inconsistent-states*)
	       (prune-inconsistent-state current-state "No successors"))      ; if non-quiescent
	     nil)
	    (t (build-successors-from-alists current-state alists))))))


(defun replace-abs-qdir-w-ign (state)
  (let* ((chvar-names (state-chattering-vars state))
	 (chvars (mapcar #'(lambda (var-name)
			     (var var-name state))
			 chvar-names))
	 (state-qvalues (state-qvalues state)))
    (when chvars
      (loop for var in chvars
	    for var-name in chvar-names
	    for abs-pval = (find-if #'(lambda (pval)
					(and (qdir pval)
					     (listp (qdir pval))))
				    (variable--pvals var))
	    for state-qval = (alookup var-name state-qvalues)
	    when abs-pval
	    collect (list var-name (qdir abs-pval)) into ret-val
	    and
	    do (setf (qdir abs-pval) 'ign)
	    and
	    do (setf (qdir state-qval) 'ign)
	    finally (return ret-val)))))

(defun replace-ign-w-abs-qdir (state-or-alist var-qdirs)
  (let ((alist (if (listp state-or-alist)
		   state-or-alist
		   (state-qvalues state-or-alist))))
    (mapcar #'(lambda (var-qval)
		(when (equal (qdir (cdr var-qval)) 'ign)
		  (let ((abs-qdir (cadr (find (car var-qval) var-qdirs
					      :test #'(lambda (var pair)
							(equal var (car pair)))))))
		    (when abs-qdir
		      (setf (qdir (cdr var-qval)) abs-qdir))))
		var-qval)
	    alist)
    alist))

