(in-package :qsim)

;;;  New code added to qplot.lisp to provide for the qsim-extensions menu.
;;;
;;;  QSIM-EXTENSIONS-MENU
;;;
;;;  This function allows the user to add extensions to the qsim display
;;;  without changing functions in qplot.lisp.  An extensiosn menu has been added
;;;  off of the main menu.  This menu will get its choices from the special
;;;  variable *qsim-extensions-menu*.  An entry on this special variable should take
;;;  the following form:
;;;
;;;     (<entry-string> <descriptive-text> <function-call>)
;;;
;;;  where
;;;
;;;      <entry-string> is a a character or a short string that the user enters to
;;;                     make this selection
;;;      <descriptive text> describes what this extension does and is displayed on the
;;;                     menu.
;;;      <function-call> is a function that is called when this selection is made.
;;;
;;;   An entry to the qsim extensions menu can be added by calling add-to-qsim-extension-menu.
;;;   This function takes three arguments corresponding to the three entries for
;;;   the entry in *qsim-extensions-menu*
;;;
;;;   The format of the lambda list for a function called from the QSIM extentions
;;;   menu should be as follows:
;;;
;;;       (initials behaviors btotal)
;;;
;;;   Include these in the lambda list even of all of them are not needed.
;;;

(defparameter *qsim-extensions-menu* nil)

(defun add-to-qsim-extension-menu (new-option new-text new-function)
  "This function is used to add a new entry to the qsim-extensions-menu."
  (when
      (loop for (option text function) in *qsim-extensions-menu*
	    do (cond ((and (equal option new-option)
			   (not (equal new-function function)))
		      (cerror "Do not add this option to the menu"
			      "Qsim extensions menu conflict. New entry ~a ~%conflicts with current entry ~a"
			      (list new-option new-text new-function)
			      (list option text function))
		      (return nil))
		     ((and (equal new-function function)
			   (equal option new-option))
		      (format *qsim-report* "~%Warning:  Qsim extensions menu entry ~
                                             ~%          ~a ~
                                             ~%          is already in the list as ~
                                             ~%          ~a."
			      (list new-option new-text new-function)
			      (list option text function))
		      (return nil)))
	    finally (return t))
    (push (list new-option new-text new-function) *qsim-extensions-menu*)))



(defun qsim-extensions-menu (initials behaviors btotal)
  (loop for cmd = (general-menu *qsim-extensions-menu* :skip-lines t)
	when (null cmd) return nil
	do (if (fboundp (third cmd))
	       (funcall (third cmd) initials behaviors btotal)
	       (format *qsim-report* "~%WARNING: The entry in *qsim-extensions* of ~a ~
                            ~%  does not have a function entry in the third element."
		       cmd))))
;;;
;;;   Code added to qplot.lisp since last distribution
;;;   THis code is needed for people outside of UT to load.
;;;

(defun get-qsim-command ()
  "This function will call read and then convert the input to the
qsim package."
  (clear-input)
  (conv-to-qsim-symbol (read)))

(defun conv-to-qsim-symbol (cmd)
  (cond ((symbolp cmd)
	 (intern (string cmd) :qsim))
	((listp cmd)
	 (mapcar #'conv-to-qsim-symbol cmd))
	(t cmd)))

(defun get-valid-state ()
  (loop for state = (get-state-name)
	if (or (null state)
	       (and (boundp state)
		    (state-p (get-state state))))
	return (get-state state)
	else
	do (format *qsim-report* "Entry is not a valid state.  Try again.  Enter () to exit.")))

(defun get-state-name ()
  (format *qsim-report* "~%Enter the state: ")
  (get-qsim-command))
 

;;;   FROM QPLOT.LISP


;;; Modified to add a command to eliminate occurrence branching
;;; 15 May 1991  DJC
;;; Modified to handle command entry on the Mac.  The mac does not
;;; implement the read-char unread-car cycle correctly.
;;; The Mac version will simply use read initially and will then handle the
;;; input appropriately.
;;; DJC 21Oct91
;;; Modified to provide an extensions menu that uses general-menu
;;; DJC 01/19/93

(defun GET-DISPLAY-COMMAND (bnum btotal click-p plot-mode)
  (let* ((next-bnum (if (or (null bnum) (eql bnum btotal)) 1 (1+ bnum)))
	 (return-strings '(C T O Q V P L S I A
			   G   ; BKay 25Sept91
			   B 
			   Z  ; DJC  02/21/92
			   K  ; DJC  03/30/92
			   TR ; DJC  05/1/92
			   CH ; DJC  07/6/92
			   E  ; DJC 01/19/92
			   )))
    (loop
     for cmd = (prompt-for-display-command next-bnum btotal click-p plot-mode)
     do (cond ((member cmd (if click-p return-strings (cdr return-strings))
		       :test #'equal)
	       (return cmd))
	      ((equal cmd 'n)
	       (return next-bnum))
	      ((numberp cmd)
	       (if (or (not (typep cmd 'fixnum))
		       (< cmd 1)
		       (> cmd btotal))
		   (format *Qsim-Report*
			   "~&Invalid behavior number: must be between 1 and ~A."
			   btotal)
		   (return cmd)))
	      (t (format *Qsim-Report*
			 "~%Invalid Entry: Try again."))))))





;;; Modified to handle a bug in the Mac Lisp.  See comment in GET-DISPLAY-COMMAND
;;; DJC  21 Oct 91
;;; Modified to call get-qsim-command which will make sure that the
;;; input is in the qsim-package.  DJC 20 Oct 92

(defun PROMPT-FOR-DISPLAY-COMMAND (bnum btotal click-p plot-mode)
  (format *Qsim-Report*
	  "~%~A.  Enter~A N=Next beh (~A of ~A), beh number, ~
                          O=Other commands, K=Symbol Key, CH=Change Output Routing, ~
                          E=QSIM Extensions, Q=Quit:"
	  (plot-mode-to-string plot-mode)
	  (if click-p
	      #+Symbolics " C=Click for beh," #-Symbolics ""
	      " T=beh Tree,")
	  bnum btotal)
  (get-qsim-command))


;;; New version of Displays (old version --> boneyard).
;;; Cleaned up slightly 19 Oct 90 RSM

;;; Modified so that it can handle aggregate-intervals which are
;;; created when occurrence branching is eliminated.
;;; 15 May 1991  DJC
;;; Modified to display envisionments
;;; 04 Jun 1991  PF
;;; Modified to make numeric timeplots using qgraph.
;;; 25 Sep 1991  BKay
;;; Added a keyword states which can be list of states to display.
;;; 23 Oct 91
;;;  Modified to work off of single character strings as opposed
;;;  to the characters as it had previously been  DJC 04/20/92
;;; Modified to add a QSIM extensions sub-menu DJC 01/19/93

(defun DISPLAYS (&key (state *initial-state*)
		 (states (list state))
		 (reference-states nil)
		 (trees *plot-small-state-tree*)
		 (tree-ystep nil)          ; BKay 3Feb92
		 (*plot-intervals* (display-block-plot-intervals *current-display-block*))
		 (layout)
		 (plot-mode 'time-plot)    ; BKay 25Sept91
		 (show-inconsistent-successors *show-inconsistent-successors*))    ;  28 Feb DJC
  (let* ((*show-inconsistent-successors* show-inconsistent-successors)    ;   28 Feb  DJC
	 (display-block *current-display-block*)
	 (*envisionment* (display-block-envisionment-p display-block))
	 (*develop-graph* nil)			; PF 02 May 1991
	 (*traverse-xedges* nil)
	 (initials (cond ((mapcan #'(lambda (state)    ;  DJC 23 Oct 91
				      (get-list-of-initial-states state :complete-partial-state nil))
				  states))
			 ; In case a state is incomplete and has no consistent successors DJC 03/15/92
			 ((incomplete-p state)
			  (cerror "Show the inconsistent successors" 
				  "The initial-state is incomplete and has no consistent successors.")
			    (let ((*show-inconsistent-successors* t))
			      (mapcan #'(lambda (state)    
				      (get-list-of-initial-states state :complete-partial-state nil))
				  states)))))
	 (qde (state-qde (car initials)))
	 (qspaces nil)				; Ignored in Display-Behavior
	 (behaviors (get-behaviors initials))
	 (visible-aggregates (unless *envisionment* (find-aggregates-in-behaviors behaviors)))
	 (all-aggregates (get-all-aggregates states))
	 (*agg-stack* nil)
	 (btotal (length behaviors))
;        The above line was deleted because the max function is not guaranteed
;	 to accept more than 256 arguments.  The loop below can take as many
;	 as needed.  BKay and AF 3Feb92
	 (bmax (loop for b in behaviors maximize (length b)))
	 (click-p nil)
	 (bnum nil)
	 (pplanes nil)
	 rows cols)
    (if (and *envisionment* (null *plot-state-indices*))	;  3 Oct 90 RSM
	;; setq, not let, permits user change during displays with break
	(setq *plot-state-indices* :above-node))		; 22 Oct 90 RSM
    (unless layout
      (setf layout (find-some-layout behaviors reference-states)))
    (compute-layout (if (eq plot-mode 'numeric-time-plot)
		        (display-block-numeric-time-plot-layout
			 *current-display-block*)
			layout))     ; If clause added BKay 25Sept91
    (loop							; 19 Oct 90 RSM
      for cmd = (get-display-command bnum btotal click-p plot-mode)
      do
      (setq click-p nil)
      (case cmd
	((Q) (close-postscript-file-if-needed)
	 (return-from displays t))		; BJK:  10-25-90
	((C) 
	 (click-input initials reference-states bmax btotal cols layout qspaces trees
		      plot-mode behaviors pplanes))
	((T)
	 (qplot-behavior-tree initials bmax btotal 0 :tree-ystep tree-ystep)
	 (setq click-p t))
	((K)   ; added DJC  03/30/92
	 (qplot-state-symbol-key))
	((CH)
	 (change-output-routing))
	((E)
	 (qsim-extensions-menu initials behaviors btotal))
	((O V P L S I A  
	  G  ;BKay 25Sept91
	  B  ;DJC 05Feb92
	  Z  ; DJC 21Feb92  (selective continuation of the tree)
	  TR ; DJC 1May92  Truncate behavior tree or display
	  )
	 (loop
	   for (key values)
	   in (do-other-commands
		(if (equal cmd 'O) (get-other-command plot-mode all-aggregates) cmd)
		initials reference-states behaviors layout 
		display-block plot-mode ; BKay 25Sept91
		qspaces bmax btotal 
		bnum pplanes rows cols qde trees visible-aggregates all-aggregates)
	   do (case key
		(layout  (if (eq plot-mode 'time-plot)
			     (setq layout values))) ; If clause added BKay 22Oct91
		(pplanes (setq pplanes (first values)
			       rows (second values)
			       cols (third values)))
		(plot-mode (setq plot-mode values))
		;;  Recalculate the behavior information if the level of abstraction
		;;  is changed.
		(recalc-beh (setf behaviors (get-behaviors initials)
				  btotal (length behaviors)
				  bmax (apply #'max (mapcar #'length behaviors))
				  bnum nil
				  visible-aggregates (unless *envisionment* (find-aggregates-in-behaviors behaviors)))
			    (when values 
			      (setf all-aggregates (get-all-aggregates states)))))))
	(t
	  (setq bnum cmd)
	  (case plot-mode
	    (time-plot (time-plot-behavior initials reference-states behaviors
					   layout qspaces bmax btotal bnum trees :display-block display-block))
	    (phase-plot (phase-plot-behavior initials behaviors pplanes cols
					     bmax btotal bnum))
	    ;; Added 25Sept91 by BKay 
	    (numeric-time-plot
	     (numeric-time-plot-behavior
	      behaviors 
	      (display-block-numeric-time-plot-layout *current-display-block*)
	      (display-block-numeric-time-plot-options *current-display-block*)
	      btotal
	      bnum))
	    ))))))

