(in-package :pos)


(defun qplot-abs-qdir (symbol x y asiz alu color)
  "Plots the symbols for abstract qdirs for the display. "
  (case symbol
    (:inc-std-dec
     (q-double-arrow x (+ y 2) x (- y 2) :alu alu :color color))
    (:inc-std
     (let ((y (- y 2)))
       (qvec x (+ y asiz) x (- y asiz)     :alu alu :color color)
       (qplot-circle (round x) (round (+ y 6)) 2 :alu alu :color color)
       ))
    (:dec-std
     (let ((y (+ y 2)))
       (qvec x (- y asiz) x (+ y asiz)     :alu alu :color color)
       (qplot-circle (round x) (round (- y 6)) 2 :alu alu :color color)
       ))))


(defun ps-abs-qdir (symbol xloc yloc small-sym-ps alu)
  "Plots the symbols for abstract qdirs for the psotscript file output."
  (case symbol
    (:inc-std-dec
     (ps-special-char xloc yloc 173
		      :size small-sym-ps
		      :alu alu)
     (ps-special-char xloc yloc 175
		      :size small-sym-ps
		      :alu alu))
    (:inc-std
     (ps-special-char (- xloc 0) (+ yloc 5.5) 176
		      :alu alu)
     (ps-special-char xloc (- yloc 3) 173
		      :size small-sym-ps
		      :alu alu))
    (:dec-std
     (ps-special-char (- xloc 0) (- yloc 0) 176
		      :alu alu)
     (ps-special-char xloc (+ yloc 2) 175
		      :size small-sym-ps
		      :alu alu))
    ))






; Special symbols.  If you add any new symbols to this list; they must be added to 
; the list of exported functions from the POS package, (the parameter *EXPORTS*).

(defun qplot-symbol (x y symbol &rest keys
		      &key (alu   #-:pos-lispview *black*
				  #+:pos-lispview (posgcon-color (pos-gcon *qplot-output*)))
		           (color #-:pos-lispview *black*
				  #+:pos-lispview (posgcon-color (pos-gcon *qplot-output*))))
  #-:pos-lispview (declare (ignore keys))
  (let ((xloc (round (+ x *symbol-x-offset*)))
	(yloc (round (+ y *symbol-y-offset*)))
	(small-sym-ps (round (* .66 *symbol-ps-size*)))
	#+ti (xti (round (+ x -5)))
	#+ti (yti (round (+ y -4)))
	#+(or lucid x-windows) (asiz 5)
        #+:ccl (asiz 3))
    (when (image-to-postscript-p)
      (case symbol
	((std :std) (ps-special-char (- x 2.5) (+ y 6.5) 176 
                                     :alu        (get-color alu color)))
	((inc :inc) (ps-special-char xloc yloc 173 
                                     :size       small-sym-ps
                                     :alu        (get-color alu color)))
	((dec :dec) (ps-special-char xloc yloc 175 
                                     :size       small-sym-ps
                                     :alu        (get-color alu color)))
	((ign :ign) (ps-draw-string "*" xloc yloc
                                        :alu        (get-color alu color)))
	((left :left) (ps-special-char xloc yloc 172 
                                       :size       small-sym-ps
                                       :alu        (get-color alu color)))
	((right :right) (ps-special-char xloc yloc 174 
                                         :size       small-sym-ps
                                         :alu        (get-color alu color)))
	((:inc-std :dec-std :inc-std-dec)   ; added to display abstract qdir DJC
	 (ps-abs-qdir symbol xloc yloc small-sym-ps (get-color alu color)))
	(T (ps-draw-string "?"  (- x 1)(+ y 2)
                                :alu        (get-color alu color)))))
    (when (image-to-screen-p)
      #+symbolics (case symbol
		    ((std :std) (graphics:draw-circle
			   (round x) (round y) 2 :filled nil
			   :stream     *qplot-output* 
                           :alu        tv:alu-seta
                           :gray-level (get-color alu color)))
		    ((inc :inc) (graphics:draw-string
			   "" xloc yloc :stream     *qplot-output* 
                                          :alu        tv:alu-seta
                                          :gray-level (get-color alu color)))
		    ((dec :dec) (graphics:draw-string
			   "" xloc yloc :stream     *qplot-output* 
                                          :alu        tv:alu-seta
                                          :gray-level (get-color alu color)))
		    ((ign :ign) (graphics:draw-string
			   "*" xloc yloc :stream     *qplot-output* 
                                         :alu        tv:alu-seta
                                         :gray-level (get-color alu color)))
		    ((left :left) (graphics:draw-string
			    "" xloc yloc :stream     *qplot-output* 
                                           :alu        tv:alu-seta
                                           :gray-level (get-color alu color)))
		    ((right :right) (graphics:draw-string
			     "" xloc yloc :stream     *qplot-output* 
                                            :alu        tv:alu-seta
                                            :gray-level (get-color alu color)))
		    (t (graphics:draw-string "?" xloc yloc
					     :stream     *qplot-output* 
                                             :alu        tv:alu-seta
                                             :gray-level (get-color alu color))))

      #+ti (case symbol
	     ((std :std) (send *qplot-output* :draw-circle  (round x)(round y) 2))
	     ((inc :inc) (send *qplot-output* :draw-string w:cptfont-font  ""
			(1+ xti) yti w:black 0 8 1 (get-color alu color)))
	     ((dec :dec) (send *qplot-output* :draw-string w:cptfont-font ""
			(1+ xti) yti w:black 0 8 1 (get-color alu color)))
	     ((ign :ign) (send *qplot-output* :draw-string w:cptfont-font "*"
			xti yti w:black 0 8 1 (get-color alu color)))   
	     ((left :left) (send *qplot-output* :draw-string w:cptfont-font ""
			 xti yti w:black 0 8 1 (get-color alu color)))
	     ((right :right) (send *qplot-output* :draw-string w:cptfont-font ""
			  xti yti w:black 0 8 1 (get-color alu color)))
	     (t (send *qplot-output* :draw-string w:cptfont-font "?"
		      (+ 2 xti) yti w:black 0 8 1 (get-color alu color))))
      #+(or x-windows l-windows)
      (with-plotting-to-postscript-inhibited
	      (case symbol
	        ((std :std)	(qplot-circle (round x) (round y) 2 :alu alu :color color))
	        ((inc :inc)	(qvec x (+ y asiz) x (- y asiz)     :alu alu :color color))
	        ((dec :dec)	(qvec x (- y asiz) x (+ y asiz)     :alu alu :color color))
	        ((ign :ign)	(qplot-string "*" xloc yloc         :alu alu :color color))
	        ((left :left)	(qvec (+ x asiz) y (- x asiz) y     :alu alu :color color))
	        ((right :right)	(qvec (- x asiz)  y (+ x asiz) y    :alu alu :color color))
		((:inc-std :dec-std :inc-std-dec)    ; added to display abstract qdir DJC
		 (qplot-abs-qdir symbol x y asiz alu color))
	        (t (qplot-string "?" xloc yloc         :alu alu :color color))))

      #+:ccl   
      (with-plotting-to-postscript-inhibited
	      (case symbol
	        ((std :std)	(qplot-circle (round x) (round y) 2 :alu alu :color color))
	        ((inc :inc)	(qvec x (+ y asiz) x (- y asiz)     :alu alu :color color))
	        ((dec :dec)	(qvec x (- y asiz) x (+ y asiz)     :alu alu :color color))
	        ((ign :ign)	(qplot-string "*" xloc yloc         :alu alu :color color))
	        ((left :left)	(qvec (+ x asiz) y (- x asiz) y     :alu alu :color color))
	        ((right :right)	(qvec (- x asiz)  y (+ x asiz) y    :alu alu :color color))
		((:inc-std :dec-std :inc-std-dec)
		 (qplot-abs-qdir symbol x y asiz alu color))
	        (t		(qplot-string "?" xloc yloc         :alu alu :color color))))
      #+:pos-lispview
      (progn
	(if (use-lv-call *qplot-output*)
	    (lv-qplot-symbol
	     (window *qplot-output*) x y symbol
	     alu color)
	    (qpush
	     `(qplot-symbol ,x ,y ,symbol ,@keys)
	     (commands *qplot-output*)))
	NIL)
      )))



#+(or l-windows x-windows :ccl)
(defun q-double-arrow (x1 y1 x2 y2 &key (alu *black*) (color *black*))
  "Used to set the paramters for the different versions of the display."
  #+x-windows       (qplot-double-arrow x1 y1 x2 y2 :arrow-head-length  5
					:arrow-base-width   5
					:shaftthick         2
					:alu                alu
					:color              color)
  #+:ccl           (qplot-double-arrow x1 y1 x2 y2
				       :arrow-head-length  2 ;modified DJC 21Oct91
				       :arrow-base-width   4
				       :shaftthick         1
				       :alu                alu
				       :color              color))


;;; Displays a vertical arrow with an arrow head on both ends.  Used
;;; to represent and abstract qdir DJC

(defun qplot-double-arrow (from-x from-y to-x to-y &rest keys
		      &key  (alu   #-:pos-lispview *black*
				   #+:pos-lispview (posgcon-color (pos-gcon *qplot-output*)))
		      (color #-:pos-lispview *black*
			     #+:pos-lispview (posgcon-color (pos-gcon *qplot-output*)))
		      (dashed #-:pos-lispview nil
			      #+:pos-lispview (posgcon-dashed (pos-gcon *qplot-output*)))
		      (dash-pattern #-:pos-lispview '(10 10)
				    #+:pos-lispview (posgcon-dash-pattern
						     (pos-gcon *qplot-output*)))
		      #+:lucid (thickness #-:pos-lispview *black*
					  #+:pos-lispview (posgcon-thickness
							   (pos-gcon *qplot-output*)))
		      (arrow-head-length #+symbolics tv:*default-arrow-length* #-symbolics 10)
		      (arrow-base-width #+symbolics tv:*default-arrow-width* #-symbolics 5)
		      (filled t) (shaftthick 1))
  #-:pos-lispview (declare (ignore keys thickness))
  #-(or pos-lispview ccl) (declare (ignore dash-pattern dashed))
  (when (image-to-postscript-p)
    (warn "The code has not been modified to display a double arrow in the postscript output"))
  (when (image-to-screen-p)
    #+(or x-windows symbolics)
    (let ((up-points (triangle-point-translation to-x to-y to-x (- to-y arrow-head-length)
						 arrow-base-width arrow-head-length))
	  (down-points (triangle-point-translation from-x from-y from-x (+ from-y arrow-head-length)
						   arrow-base-width
						   arrow-head-length)))
      (with-plotting-to-postscript-inhibited
	  (qplot-line from-x from-y to-x to-y
		      :thickness shaftthick 
		      :alu alu
		      :color color)
	(qplot-polygon up-points :alu alu 
		       :color color
		       :filled filled 
		       :thickness shaftthick)
	(qplot-polygon down-points :alu alu
		       :color color
		       :filled filled
		       :thickness shaftthick)
	)))
  #+:ccl
  (let ((up-points (triangle-point-translation to-x to-y to-x (- to-y arrow-head-length)
						 arrow-base-width arrow-head-length))
	(down-points (triangle-point-translation from-x from-y from-x (+ from-y arrow-head-length)
						 arrow-base-width
						 arrow-head-length)))
    (with-plotting-to-postscript-inhibited
	(qplot-line (round (- from-x (/ shaftthick 2))) 
		    (round (- (- from-y arrow-head-length) (/ shaftthick 2)))
		    (round (- to-x (/ shaftthick 2)))   
		    (round (- (+ to-y arrow-head-length) (/ shaftthick 2)))
		    :thickness      shaftthick 
		    :alu            alu
		    :color          color
		    :dash-pattern   dash-pattern
		    :dashed         dashed)
      (qplot-polygon up-points :alu alu 
		      :color color
		      :filled filled 
		      :thickness shaftthick)
      (qplot-polygon down-points :alu alu
		     :color color
		     :filled filled
		      :thickness shaftthick)
      ))
    #+:pos-lispview
    (progn
      (warn "The code has not been modified to display a double arrow in the postscript output")
;;      (if (use-lv-call *qplot-output*)
;;	  (lv-qplot-vector
;;	   (window *qplot-output*) from-x from-y to-x to-y
;;	   alu color arrow-head-length arrow-base-width
;;	   filled #+lucid thickness dashed dash-pattern
;;	   shaftthick)
;;	  (qpush
;;	 `(qplot-vector ,from-x ,from-y ,to-x ,to-y
;;	   ,@keys)
;;	 (commands *qplot-output*)))
      NIL)
    ))
			  

