;;; -*- Syntax: Common-lisp; Package: USER; Mode: LISP -*-

;;; Copyright (c) 1990 by James Crawford
;;;  $Id: aload_aux.lisp,v 1.1 92/04/16 09:30:08 clancy Exp $

;;;                        ****** ALOAD_AUX ******

; Some customized loading and compiling routines:

(defun update-load-times (file)
  (let ((old-time (assoc file *load-times*)))
    (if old-time
	(rplacd old-time (get-universal-time))
	(setq *load-times* (acons file (get-universal-time) *load-times*)))))

(defun load-date (file)
  (let ((time (cdr (assoc file *load-times* :test #'equal))))
    (cond (time)
	  (t 0))))

(defun algy-compile-load (file &optional (path @algy-source-path))
  (let ((lisp-file (concatenate 'string path file @lisp-file-extension))
	(binary-file (concatenate 'string @algy-object-path file @obj-file-extension)))
    (cond ((probe-file lisp-file)
	   (cond ((probe-file binary-file)
		  (let ((lisp-date   (file-write-date lisp-file))
			(binary-date (file-write-date binary-file)))
		    (cond ((> lisp-date binary-date)
			   (compile-file lisp-file :output-file binary-file)
			   (load binary-file)
			   (update-load-times file))
			  ((> binary-date (load-date file))
			   (load binary-file)
			   (update-load-times file)))))
		 (t
		  (compile-file lisp-file :output-file binary-file)
		  (load binary-file)
		  (update-load-times file)))
	   lisp-file)
	  (t
	   (format t "No file ~(~a~)." lisp-file)))))

(defun algy-load-file (file path)
  (let ((lisp-file (format nil "~a~(~a~)~a" path file @lisp-file-extension)))
    (cond ((probe-file lisp-file)
	   (load lisp-file)
	   lisp-file)
	  (t
	   (format t "No file ~(~a~)." lisp-file)))))

(defun load-algy ()
  (print "Checking files.")
  (mapc #'algy-compile-load *algy-files*)
  (format t "~& Initializing Algernon.")
  (reset-algy)
  (let ((result (catch 'error (load-common-sense-kb))))
    (if (eql result t)
        (format t "~& Algernon initialized.")
        (format t "~%ALGERNON ERROR in intialization: ~@(~a~)" result))))

