;;;   -*- Syntax: Common-Lisp; Package: USER; Base: 10; Mode: LISP -*-    ;;;
;;;                                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;                        ****** UNP-TEST ******
;;;
;;; This example illustrates the use of the flag *work-hard-on-unp*.  Try running it with the
;;; flag set to nil, then try it with the flag set to true.

(defun facts-about-unp-test ()
  (a-assert "Taxonomy"
	    '((:taxonomy (physical-objects (blocks block1 block2)))
	      (:taxonomy (colors red blue purple green))))
  (a-assert "Slots"
	    '((:slot pretty (physical-objects booleans))
	      (:slot ugly (physical-objects booleans))))
  (a-assert "A fairly strange idea of pretty and ugly"
	    '((:rules physical-objects
	       ((pretty ?x true) <- (color ?x red))
	       ((ugly ?x true) <- (:unp (pretty ?x true))))))
  (a-assert "Block colors"
	    '((color block1 red)
	      (color block2 green))))

(defun queries-about-unp-test ()
  (a-query "Which blocks are ugly ?"
	   '((member blocks ?x)
	     (ugly ?x true))))