(defun facts-about-setof ()
  (a-assert "Taxonomy"
            '((:taxonomy (sets (described-sets)))))
  (a-assert "Slots"
            '((:slot setof (sets nil described-sets)
                     :partition set-partition
                     :comment "(setof s1 (:lambda ?x path) s2) <-> s2 = {?x in s1 | path}")
              (:slot description (sets nil)
                     :partition set-partition
                     :comment "(description s1 (:lambda ?x path)) <-> s1 = {?x in (domain s1) | path}")
              (:slot domain (described-sets sets)
                     :partition set-partition
                     :backlink subset
                     :comment "(domain s1 s2) <-> s1 = {?x in s2 | (description s1)}")
              (:slot cardinality (sets nil)
                     :partition set-partition)))
  (a-assert "Rules"
            '((:rules sets
                      ((setof ?s1 ?desc ?s2) -> (description ?s2 ?desc) (domain ?s2 ?s1))
                      ((cardinality ?s ?n) <- (:bind-to-values ?list ?s member)
                                              (:bind ?n (length '?list))))
              (:rules described-sets
                      ((description ?s ?desc) (domain ?s ?dom)
                       ->
                       (:forc ?ss (selfset ?s ?ss)
                                  ;; Also add isa link to hack partition problem:
                                  (isa ?s ?ss))
                       (:rules ?ss (:lisp (build-setof-rule '?s '?dom '?desc))))))))


(defun build-setof-rule (set domain description)
  (let ((free-var (second description))
        (path (third description)))
    (cond ((input-var? (frame (car path)))
           (preprocess `((member (:quote ,set) ,free-var)
                         <-
                         (member (:quote ,domain) ,free-var)
                         ,@path)))
          (t
           (preprocess `((member (:quote ,set) ,free-var)
                         <-
                         ,@path
                         (isa ,free-var (:quote ,domain))))))))
           

(defun test-setof ()
  (a-assert "More slots"
            '((:slot parent (people people))
              (:slot child (people people)
                     :inverse parent)
              (:slot likes (objects objects))))

  (a-assert "For this example link the set people to all people."
            '((:rules people ((isa ?x people) -> (member people ?x)))))

  (a-assert "Facts"
            '((:create ?tom Tom)
              (:create ?lisa Lisa)
              (:create ?fred Fred)
              (:create ?betty Betty)

              (child ?tom ?lisa)
              (child ?tom ?fred)
              (child ?tom ?betty)

              (:create ?c chocolate)
              (likes ?lisa ?c)
              (likes ?fred ?c)))

  (a-query "Which of Tom's children like chocolate ?"
           '((child tom ?x)
             (likes ?x chocolate)))

  (a-query "How many people like chocolate ?"
           '((:forc ?s (setof people (:lambda ?x ((likes ?x chocolate))) ?s))
             (cardinality ?s ?n)))

  (a-query "Do two of Tom's children like chocolate ?"
           '((:forc ?s (setof people (:lambda ?x ((child tom ?x) (likes ?x chocolate))) ?s))
             (cardinality ?s 2)))

  (a-query "Some interesting frames:"
           '((:show people)
             (setof people ?desc ?s)
             (:show ?s))))

(defun test-setof2 ()
  (a-assert "Taxonomy"
            '((:taxonomy (objects (nodes n1 n2 n3 n4 n5 n6 n7 n8 n9 n10)))))
  (a-assert "A new slot"
            '((:slot connection (nodes nodes))))
  (a-assert "Connections"
            '((connection n1 n2)
              (connection n1 n3)
              (connection n1 n4)
              (connection n2 n5)
              (connection n2 n6)
              (connection n3 n7)
              (connection n3 n8)
              (connection n4 n9)
              (connection n4 n10)))

  (a-query "How many nodes are connected to two other nodes ?"
           '((:forc ?set1
                    (setof nodes
                           (:lambda ?x ((:forc ?set2
                                               (setof nodes
                                                      (:lambda ?y ((connection ?x ?y)))
                                                      ?set2))
                                        (cardinality ?set2 2)))
                           ?set1))
             (cardinality ?set1 ?n)))

  (a-query "How many nodes are two nodes from six nodes ?"
           '((:forc ?set1
                    (setof nodes
                           (:lambda ?x ((:forc ?set2
                                               (setof nodes
                                                      (:lambda ?y ((connection ?x ?z)
                                                                   (connection ?z ?y)))
                                                      ?set2))
                                        (cardinality ?set2 6)))
                           ?set1))
             (cardinality ?set1 ?n))))
