;;;   -*- Syntax: Common-Lisp; Package: USER; Base: 10; Mode: LISP -*-    ;;;
;;;                                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; JOHN ALDEN STORY
;;;
;;; Illustrates the use of Algernon to express
;;; definite descriptions and represent a simple narrative.
;;; Part of the aim here is for the Algernon predicates to be,
;;; as nearly as possible, syntatic variants of the english.
;;;
(defun facts-about-john ()
  
  ;; First the title of the story to establish a new context.
  ;; The context is used principally to resolve the pronouns in
  ;; the narrative.
  ;;
  (a-assert "The John Alden Story."
	    '((:clear-slot global-context current-context)
	      (:create ?ja-story ja-story)
	      (current-context global-context ?ja-story)))

  ;; This example uses the taxonomy in the background knowledge-base, plus
  ;; the new set "time-units".
  ;;
  (a-assert "Extension to taxonomy."
	    '((:taxonomy (objects
			   (time-units years)))))

  ;; The new slot "age" is a three place relation between a physical
  ;; object, its age (which is not typed (i.e. is typed to nil)
  ;; since it will just be a  number), and the time-unit the age is
  ;; measured in.
  ;;
  (a-assert "Age."
	    '((:slot age (physical-objects nil time-units)
		     :cardinality 1)))
  
  ;; We use the "speaker" slot in the current context to hold
  ;; the speaker in the story.  We then treat
  ;; "my" or "I" as a definite description, creating the
  ;; speaker if none is known.
  ;;
  (a-assert "My name is John Alden."
	    '((:the ?me (speaker (current-context global-context) ?me))
	      (name ?me (:quote (John Alden)))))
  
  (a-assert "I am 25 years old."
	    '((:the ?me (speaker (current-context global-context) ?me))
	      (age ?me 25 years)))
  
  ;; When another frame is mentioned we put it in the "recent" slot
  ;; of the current context so we can access it with third person
  ;; pronouns later.
  ;;
  (a-assert "My wife is 23 years old."
	  '((:the ?me (speaker (current-context global-context) ?me))
	    (:the ?w (wife ?me ?w))
	    (age ?w 23 years)
	    (recent (current-context global-context) ?w)))		; => add to (unordered) context
  
  ;; It is not clear if "her" should be a definite description or not ...
  ;; What should we do with a sentence like "She went for a walk every day." ??
  ;;
  (a-assert "Her name is Priscilla."
	  '((:the ?her
	     (recent (current-context global-context) ?her)
	     (gender ?her female))
	    (name ?her (:quote (Priscilla)))))
  
  ;; Indefinite descriptions (e.g. "a friend") are usually represented
  ;; using ":forc" (find or create).
  ;;
  (a-assert "She has a friend named Miles Standish."
	  '((:the ?her
	     (recent (current-context global-context) ?her)
	     (gender ?her female))
	    (:forc ?ms
	     (friend ?her ?ms)
	     (name ?ms (:quote (Miles Standish)))
	     (gender ?ms male))			; Have to explicitly add this since
						; Algernon doesn't know Miles is a
						; man's name.
	    (recent (current-context global-context) ?ms)))
 
  (a-assert "He is 40 years old."
	  '((:the ?him
	     (recent (current-context global-context) ?him)
	     (gender ?him male))
	    (age ?him 40 years)))
 
  (a-assert "Priscilla also has a friend named Cotton Mather."
	  '((:forc ?cm
	     (friend Priscilla ?cm)
	     (name ?cm (:quote (Cotton Mather)))
	     (gender ?cm male))
	    (recent (current-context global-context) ?cm))))



;;; JOHN ALDEN STORY QUERIES
;;;
(defun queries-about-john ()
  
  ;; First we return attention to the John Alden story:
  ;;
  (a-assert "In the John Alden story ..."
	    '((:clear-slot global-context current-context)
	      (current-context global-context ja-story)))
  
  (a-query "How old is my wife ?"
	   '((:the ?me (speaker (current-context global-context) ?me))
	     (:the ?w (wife ?me ?w))
	     (age ?w ?a ?units)))
  
  (a-query "Who is Priscilla's husband?"
	  '((:show (husband Priscilla))))
  
  (a-query "What is Priscilla's friend's name ?"
	   '((name (friend Priscilla) ?name))))
