;;; -*- Mode:Common-Lisp; Package:USER; Syntax:COMMON-LISP; Base:10 -*-

;;;                        ****** FLU ******
;;;
;;; This example illustrates the use of Algernon to build a very simple
;;; expert system.  In particular it illustrates the use of the :ask
;;; form to query the user.

(defun facts-about-flu ()
  (a-assert "Taxonomy"
	    '((:taxonomy (Objects
			  (Diseases Flu)
			  (Symptoms Fever Nausea)))))

  ;; Four new slots:
  ;;  (has-disease x d) = x has disease d.
  ;;  (has-symptom x s) = x has symptom s.
  ;;  (temperature x t) = x has temperature t.
  ;;  (symptom d s)     = disease d causes symptom s.
  ;;
  (a-assert "Slot specifications"
	    '((:slot has-disease (people diseases))
	      (:slot has-symptom (people symptoms))
              (:slot temperature (physical-objects nil)
                     :cardinality 1)
	      (:slot symptom     (diseases symptoms))))

  ;; In the diagnosis rule below we will need to be able to access
  ;; all diseases so store all diseases in the member slot of the set of diseases:
  ;; (this is not done for all sets since some sets (e.g. things) could
  ;; have thousands of members).
  ;;
  (a-assert "Backlink diseases"
  	    '((:rules Diseases
  	       ((isa ?d1 Diseases) -> (member Diseases ?d1)))))

  (a-assert "Diagnostic rules"
	    '((:rules People

	       ;; Collecting symptoms:
	       ((has-symptom ?p fever) <- (temperature ?p ?t) (:test (> ?t 99)))
	       ((has-symptom ?p nausea) <- (:ask (has-symptom ?p nausea)))
	       ((temperature ?p ?t) <- (:ask (temperature ?p ?t)))

	       ;; Diagnosing disease.  This is a fairly simpleminded idea of diagnosis ---
	       ;; a person has a disease if they have all symptoms of the disease ...
	       ((has-disease ?x ?d1)
		<-
		(member Diseases ?d1)
		(:all-paths ((symptom ?d1 ?s)) ((has-symptom ?x ?s)))))))

  (a-assert "Symptoms"
	    '((symptom Flu Fever)
	      (symptom Flu Nausea))))


(defun queries-about-flu ()

  ;; Now we access the frame for the person John and find out
  ;; what disease he has:
  ;;
  (a-query "What does John have?"
	   '((:the ?john (name ?john (:quote (John))) (isa ?john People))
	     (has-disease ?john ?d))))

